/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.file;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.jboss.logging.Logger;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.EntityField;
import org.keycloak.models.map.common.StringKeyConverter;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.common.delegate.EntityFieldDelegate;
import org.keycloak.models.map.storage.ModelEntityUtil;
import org.keycloak.models.map.storage.chm.ConcurrentHashMapStorage;
import org.keycloak.models.map.storage.chm.MapFieldPredicates;
import org.keycloak.models.map.storage.file.FileCrudOperations;
import org.keycloak.storage.ReadOnlyException;

public class FileMapStorage<V extends AbstractEntity & UpdatableEntity, M>
extends ConcurrentHashMapStorage<String, V, M, FileCrudOperations<V, M>> {
    private static final Logger LOG = Logger.getLogger(FileMapStorage.class);
    private final List<Path> createdPaths = new LinkedList<Path>();
    private final List<Path> pathsToDelete = new LinkedList<Path>();
    private final Map<Path, Path> renameOnCommit = new LinkedHashMap<Path, Path>();
    private final Map<Path, FileTime> lastModified = new HashMap<Path, FileTime>();
    private final String txId = StringKeyConverter.StringKey.INSTANCE.yieldNewUniqueKey();

    public static <V extends AbstractEntity & UpdatableEntity, M> FileMapStorage<V, M> newInstance(Class<V> entityClass, Function<String, Path> dataDirectoryFunc, Function<V, String[]> suggestedPath, boolean isExpirableEntity) {
        Crud crud = new Crud(entityClass, dataDirectoryFunc, suggestedPath, isExpirableEntity);
        FileMapStorage store = new FileMapStorage(entityClass, crud);
        crud.store = store;
        return store;
    }

    private FileMapStorage(Class<V> entityClass, Crud<V, M> crud) {
        super(crud, (StringKeyConverter)StringKeyConverter.StringKey.INSTANCE, DeepCloner.DUMB_CLONER, MapFieldPredicates.getPredicates((Class)ModelEntityUtil.getModelType(entityClass)), ModelEntityUtil.getRealmIdField(entityClass));
    }

    public void rollback() {
        this.renameOnCommit.keySet().forEach(FileMapStorage::silentDelete);
        this.createdPaths.forEach(FileMapStorage::silentDelete);
        super.rollback();
    }

    public void commit() {
        super.commit();
        HashSet<Path> allChangedPaths = new HashSet<Path>();
        allChangedPaths.addAll(this.renameOnCommit.values());
        allChangedPaths.addAll(this.pathsToDelete);
        allChangedPaths.forEach(this::checkIsSafeToModify);
        try {
            this.renameOnCommit.forEach(FileMapStorage::move);
            this.pathsToDelete.forEach(FileMapStorage::silentDelete);
        }
        finally {
            this.renameOnCommit.keySet().forEach(FileMapStorage::silentDelete);
            this.createdPaths.forEach(path -> FileMapStorage.silenteDelete(path, true));
        }
    }

    private static void move(Path from, Path to) {
        try {
            Files.move(from, to, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static void silentDelete(Path p) {
        FileMapStorage.silenteDelete(p, false);
    }

    private static void silenteDelete(Path path, boolean checkEmpty) {
        try {
            if (Files.exists(path, new LinkOption[0]) && (!checkEmpty || Files.size(path) == 0L)) {
                Files.delete(path);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void touch(String proposedId, Path path) throws IOException {
        if (Optional.ofNullable(this.tasks.get(proposedId)).map(ConcurrentHashMapStorage.MapTaskWithValue::getOperation).orElse(null) == ConcurrentHashMapStorage.MapOperation.DELETE) {
            return;
        }
        Files.createFile(path, new FileAttribute[0]);
        this.createdPaths.add(path);
    }

    public boolean removeIfExists(Path path) {
        boolean res = !this.pathsToDelete.contains(path) && Files.exists(path, new LinkOption[0]);
        this.pathsToDelete.add(path);
        return res;
    }

    void registerRenameOnCommit(Path from, Path to) {
        this.pathsToDelete.remove(to);
        this.renameOnCommit.put(from, to);
    }

    FileTime getLastModifiedTime(Path path) {
        try {
            BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            FileTime lastModifiedTime = attr.lastModifiedTime();
            this.lastModified.put(path, lastModifiedTime);
            return lastModifiedTime;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Could not read file attributes " + path, ex);
        }
    }

    void checkIsSafeToModify(Path path) {
        try {
            if (this.lastModified.get(path) == null) {
                LOG.debugf("File %s was not previously loaded, skipping validation prior to writing", (Object)path);
                return;
            }
            if (!Files.exists(path, new LinkOption[0])) {
                throw new IllegalStateException("File " + path + " was removed by another transaction");
            }
            BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            long lastModifiedTime = attr.lastModifiedTime().toMillis();
            if (this.lastModified.get(path).toMillis() < lastModifiedTime) {
                throw new IllegalStateException("File " + path + " was changed by another transaction");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public V registerEntityForChanges(V origEntity) {
        AbstractEntity watchedValue = super.registerEntityForChanges(origEntity);
        return (V)DeepCloner.DUMB_CLONER.entityFieldDelegate(watchedValue, (EntityFieldDelegate)new IdProtector(this, watchedValue));
    }

    private static class Crud<V extends AbstractEntity & UpdatableEntity, M>
    extends FileCrudOperations<V, M> {
        private FileMapStorage<V, M> store;

        public Crud(Class<V> entityClass, Function<String, Path> dataDirectoryFunc, Function<V, String[]> suggestedPath, boolean isExpirableEntity) {
            super(entityClass, dataDirectoryFunc, suggestedPath, isExpirableEntity);
        }

        @Override
        protected void touch(String proposedId, Path sp) throws IOException {
            this.store.touch(proposedId, sp);
        }

        @Override
        protected void registerRenameOnCommit(Path from, Path to) {
            this.store.registerRenameOnCommit(from, to);
        }

        @Override
        protected boolean removeIfExists(Path sp) {
            return this.store.removeIfExists(sp);
        }

        @Override
        protected String getTxId() {
            return this.store.txId;
        }

        @Override
        protected FileTime getLastModifiedTime(Path sp) {
            return this.store.getLastModifiedTime(sp);
        }

        @Override
        protected void checkIsSafeToModify(Path sp) {
            this.store.checkIsSafeToModify(sp);
        }
    }

    private static class IdProtector
    extends EntityFieldDelegate.WithEntity<V> {
        final /* synthetic */ FileMapStorage this$0;

        public IdProtector(V entity) {
            this.this$0 = var1_1;
            super(entity);
        }

        public <T, EF extends Enum<? extends EntityField<V>>> void set(EF field, T value) {
            String id = ((AbstractEntity)this.entity).getId();
            super.set(field, value);
            this.checkIdMatches(id, field);
        }

        public <T, EF extends Enum<? extends EntityField<V>>> void collectionAdd(EF field, T value) {
            String id = ((AbstractEntity)this.entity).getId();
            super.collectionAdd(field, value);
            this.checkIdMatches(id, field);
        }

        public <T, EF extends Enum<? extends EntityField<V>>> Object collectionRemove(EF field, T value) {
            String id = ((AbstractEntity)this.entity).getId();
            Object res = super.collectionRemove(field, value);
            this.checkIdMatches(id, field);
            return res;
        }

        public <K, T, EF extends Enum<? extends EntityField<V>>> void mapPut(EF field, K key, T value) {
            String id = ((AbstractEntity)this.entity).getId();
            super.mapPut(field, key, value);
            this.checkIdMatches(id, field);
        }

        public <K, EF extends Enum<? extends EntityField<V>>> Object mapRemove(EF field, K key) {
            String id = ((AbstractEntity)this.entity).getId();
            Object res = super.mapRemove(field, key);
            this.checkIdMatches(id, field);
            return res;
        }

        private <EF extends Enum<? extends EntityField<V>>> void checkIdMatches(String id, EF field) throws ReadOnlyException {
            String idNow = ((FileCrudOperations)this.this$0.map).determineKeyFromValue((AbstractEntity)this.entity, "");
            if (!Objects.equals(id, idNow)) {
                if (idNow.endsWith(":") && id.startsWith(idNow)) {
                    return;
                }
                throw new ReadOnlyException("Cannot change " + field + " as that would change primary key");
            }
        }

        public String toString() {
            return super.toString() + " [protected ID]";
        }
    }
}

