/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.file;

import java.util.function.Function;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.ExpirableEntity;
import org.keycloak.models.map.common.SessionAttributesUtils;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.MapStorageProvider;
import org.keycloak.models.map.storage.MapStorageProviderFactory;
import org.keycloak.models.map.storage.ModelEntityUtil;
import org.keycloak.models.map.storage.chm.ConcurrentHashMapStorage;
import org.keycloak.models.map.storage.file.FileMapStorage;
import org.keycloak.models.map.storage.file.FileMapStorageProviderFactory;

public class FileMapStorageProvider
implements MapStorageProvider {
    private final KeycloakSession session;
    private final FileMapStorageProviderFactory factory;
    private final int factoryId;

    public FileMapStorageProvider(KeycloakSession session, FileMapStorageProviderFactory factory, int factoryId) {
        this.session = session;
        this.factory = factory;
        this.factoryId = factoryId;
    }

    public <V extends AbstractEntity, M> MapStorage<V, M> getMapStorage(Class<M> modelType, MapStorageProviderFactory.Flag ... flags) {
        return SessionAttributesUtils.createMapStorageIfAbsent((KeycloakSession)this.session, this.getClass(), modelType, (int)this.factoryId, () -> this.createFileMapStorage(modelType));
    }

    private <V extends AbstractEntity & UpdatableEntity, M> ConcurrentHashMapStorage<?, V, M> createFileMapStorage(Class<M> modelType) {
        String areaName = ModelEntityUtil.getModelName(modelType, (String)modelType.getSimpleName());
        Class et = ModelEntityUtil.getEntityType(modelType);
        Function<?, String[]> uniqueHumanReadableField = FileMapStorageProviderFactory.UNIQUE_HUMAN_READABLE_NAME_FIELD.get(et);
        FileMapStorage mapStorage = FileMapStorage.newInstance(et, this.factory.getDataDirectoryFunc(areaName), uniqueHumanReadableField == null ? v -> {
            String[] stringArray;
            if (v.getId() == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = v.getId();
            }
            return stringArray;
        } : uniqueHumanReadableField, ExpirableEntity.class.isAssignableFrom(et));
        this.session.getTransactionManager().enlist(mapStorage);
        return mapStorage;
    }

    public void close() {
    }
}

