/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import org.jboss.logging.Logger;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.RealmRepresentation;

public class MigrateTo22_0_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("22.0.0");
    public static final String HTTP_CHALLENGE_FLOW = "http challenge";
    private static final Logger LOG = Logger.getLogger(MigrateTo22_0_0.class);

    public void migrate(KeycloakSession session) {
        session.realms().getRealmsStream().forEach(realm -> {
            this.removeHttpChallengeFlow((RealmModel)realm);
            this.updateAccountTheme((RealmModel)realm);
        });
    }

    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        this.removeHttpChallengeFlow(realm);
        this.updateAccountTheme(realm);
    }

    private void removeHttpChallengeFlow(RealmModel realm) {
        AuthenticationFlowModel httpChallenge = realm.getFlowByAlias(HTTP_CHALLENGE_FLOW);
        if (httpChallenge == null) {
            return;
        }
        try {
            KeycloakModelUtils.deepDeleteAuthenticationFlow((RealmModel)realm, (AuthenticationFlowModel)httpChallenge, () -> {}, () -> {});
            LOG.debugf("Removed '%s' authentication flow in realm '%s'", (Object)HTTP_CHALLENGE_FLOW, (Object)realm.getName());
        }
        catch (ModelException me) {
            LOG.errorf("Authentication flow '%s' is in use in realm '%s' and cannot be removed. Please update your deployment to avoid using this flow before migration to latest Keycloak", (Object)HTTP_CHALLENGE_FLOW, (Object)realm.getName());
            throw me;
        }
    }

    private void updateAccountTheme(RealmModel realm) {
        String accountTheme = realm.getAccountTheme();
        if ("keycloak".equals(accountTheme) || "rh-sso".equals(accountTheme)) {
            realm.setAccountTheme("keycloak.v2");
        }
    }

    public ModelVersion getVersion() {
        return VERSION;
    }
}

