/*
 * Decompiled with CFR 0.152.
 */
package recoder.util;

import java.util.concurrent.CopyOnWriteArrayList;
import recoder.util.ProgressEvent;
import recoder.util.ProgressListener;

public final class ProgressListenerManager {
    private final ReuseableProgressEvent progressEvent;
    private final Object source;
    private final CopyOnWriteArrayList<ProgressListener> progressListeners = new CopyOnWriteArrayList();

    public ProgressListenerManager(Object source) {
        this.source = source;
        this.progressEvent = new ReuseableProgressEvent(source, 0, 0, null);
    }

    public ProgressEvent getLastProgressEvent() {
        return this.progressEvent;
    }

    public void fireProgressEvent(int workCount) {
        if (!this.progressListeners.isEmpty()) {
            this.progressEvent.setWorkDoneCount(workCount);
            for (ProgressListener pl : this.progressListeners) {
                pl.workProgressed(this.progressEvent);
            }
        }
    }

    public void fireProgressEvent(int workCount, Object state) {
        if (!this.progressListeners.isEmpty()) {
            this.progressEvent.setWorkDoneCount(workCount);
            this.progressEvent.setState(state);
            for (ProgressListener pl : this.progressListeners) {
                pl.workProgressed(this.progressEvent);
            }
        }
    }

    public void fireProgressEvent(int workCount, int newMaximum) {
        if (!this.progressListeners.isEmpty()) {
            this.progressEvent.setWorkDoneCount(workCount);
            this.progressEvent.setWorkToDoCount(newMaximum);
            for (ProgressListener pl : this.progressListeners) {
                pl.workProgressed(this.progressEvent);
            }
        }
    }

    public void fireProgressEvent(int workCount, int newMaximum, Object state) {
        if (!this.progressListeners.isEmpty()) {
            this.progressEvent.setWork(workCount, newMaximum, state);
            for (ProgressListener pl : this.progressListeners) {
                pl.workProgressed(this.progressEvent);
            }
        }
    }

    public void addProgressListener(ProgressListener l) {
        this.progressListeners.addIfAbsent(l);
    }

    public void removeProgressListener(ProgressListener chl) {
        this.progressListeners.remove(chl);
    }

    private static class ReuseableProgressEvent
    extends ProgressEvent {
        private static final long serialVersionUID = -8120253607435943831L;

        public ReuseableProgressEvent(Object source, int workDone, int workToDo, Object state) {
            super(source, workDone, workToDo, state);
        }
    }
}

