/*
 * Decompiled with CFR 0.152.
 */
package recoder.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import recoder.util.HashCode;

public abstract class AbstractIndex
implements HashCode {
    private static final float THRESHOLD = 0.75f;
    private static final Object DELETED = new Object(){

        public boolean equals(Object x) {
            return false;
        }

        public String toString() {
            return "<DELETED>";
        }
    };
    Object[] table;
    long[] id;
    int count;
    int ld;

    public AbstractIndex() {
        this(4);
    }

    public AbstractIndex(int initialCapacity) {
        int cap;
        if (initialCapacity < 4) {
            initialCapacity = 4;
        }
        this.ld = 2;
        for (cap = 4; cap < initialCapacity; cap += cap) {
            ++this.ld;
        }
        this.table = new Object[cap];
        this.id = new long[cap];
        this.ld = 32 - this.ld;
    }

    @Override
    public abstract boolean equals(Object var1, Object var2);

    @Override
    public abstract int hashCode(Object var1);

    public final int size() {
        return this.count;
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    private void rehash() {
        Object[] oldMap = this.table;
        long[] oldId = this.id;
        int oldCapacity = oldMap.length;
        --this.ld;
        this.table = new Object[oldCapacity * 2];
        this.id = new long[oldCapacity * 2];
        this.count = 0;
        for (int i = oldCapacity - 1; i >= 0; --i) {
            Object ob = oldMap[i];
            if (ob == null || ob == DELETED) continue;
            this.insert(ob, oldId[i]);
        }
    }

    public boolean contains(Object key) {
        int hash;
        if (key == null) {
            return false;
        }
        int index = hash = -1640531527 * this.hashCode(key) >>> this.ld;
        do {
            Object ob;
            if ((ob = this.table[index]) == null) {
                return false;
            }
            if (!this.equals(ob, key)) continue;
            return true;
        } while ((index = index + (hash | 1) & this.table.length - 1) != hash);
        return false;
    }

    public final long get(Object key) {
        int hash;
        if (key == null) {
            return -1L;
        }
        int index = hash = -1640531527 * this.hashCode(key) >>> this.ld;
        do {
            Object ob;
            if ((ob = this.table[index]) == null) {
                return -1L;
            }
            if (!this.equals(ob, key)) continue;
            return this.id[index];
        } while ((index = index + (hash | 1) & this.table.length - 1) != hash);
        return -1L;
    }

    public final long put(Object key, long id) {
        if (key == null) {
            throw new IllegalArgumentException("Null key");
        }
        if ((float)this.count >= (float)this.table.length * 0.75f) {
            this.rehash();
        }
        return this.insert(key, id);
    }

    private long insert(Object key, long id) {
        int hash;
        int index = hash = -1640531527 * this.hashCode(key) >>> this.ld;
        do {
            Object ob;
            if ((ob = this.table[index]) == null || ob == DELETED) {
                this.table[index] = key;
                this.id[index] = id;
                ++this.count;
                return -1L;
            }
            if (!this.equals(ob, key)) continue;
            long i = this.id[index];
            this.table[index] = key;
            this.id[index] = id;
            return i;
        } while ((index = index + (hash | 1) & this.table.length - 1) != hash);
        this.rehash();
        return this.insert(key, id);
    }

    public final long remove(Object key) {
        int hash;
        if (key == null) {
            throw new IllegalArgumentException("Null key");
        }
        int index = hash = -1640531527 * this.hashCode(key) >>> this.ld;
        do {
            Object ob;
            if ((ob = this.table[index]) == null) {
                return -1L;
            }
            if (!this.equals(ob, key)) continue;
            this.table[index] = DELETED;
            --this.count;
            return this.id[index];
        } while ((index = index + (hash | 1) & this.table.length - 1) != hash);
        return -1L;
    }

    public void clear() {
        int index = this.table.length;
        while (--index >= 0) {
            this.table[index] = null;
        }
        this.count = 0;
    }

    public final Enumeration elements() {
        return new Enumerator(this.table);
    }

    public boolean equals(Object ob) {
        if (!(ob instanceof AbstractIndex)) {
            return false;
        }
        AbstractIndex x = (AbstractIndex)ob;
        if (x.size() != this.size()) {
            return false;
        }
        Enumeration enum2 = x.elements();
        while (enum2.hasMoreElements()) {
            Object z = enum2.nextElement();
            if (this.get(z) == x.get(z)) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        try {
            AbstractIndex t = (AbstractIndex)super.clone();
            t.table = new Object[this.table.length];
            int i = this.table.length;
            while (i-- > 0) {
                t.table[i] = this.table[i];
                t.id[i] = this.id[i];
            }
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String toString() {
        int max = this.size() - 1;
        StringBuilder buf = new StringBuilder();
        Enumeration e = this.elements();
        buf.append("{");
        for (int i = 0; i <= max; ++i) {
            String s = e.nextElement().toString();
            buf.append(s);
            buf.append("=");
            buf.append(this.get(s));
            if (i >= max) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    static class Enumerator
    implements Enumeration {
        int index;
        final Object[] table;

        Enumerator(Object[] table) {
            this.table = table;
            this.index = 0;
        }

        @Override
        public boolean hasMoreElements() {
            while (this.index < this.table.length) {
                if (this.table[this.index] != null && this.table[this.index] != DELETED) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        public Object nextElement() {
            while (this.index < this.table.length) {
                if (this.table[this.index] != null && this.table[this.index] != DELETED) {
                    return this.table[this.index++];
                }
                ++this.index;
            }
            throw new NoSuchElementException("Enumerator");
        }
    }
}

