/*
 * Decompiled with CFR 0.152.
 */
package recoder.service;

import java.util.EventObject;
import recoder.ModelElement;
import recoder.ModelException;
import recoder.java.ProgramElement;
import recoder.service.ErrorHandler;
import recoder.service.UnresolvedReferenceException;

public class DefaultErrorHandler
implements ErrorHandler {
    private int errorCount = 0;
    private int errorThreshold;

    public DefaultErrorHandler() {
        this.setErrorThreshold(20);
    }

    public DefaultErrorHandler(int errorThreshold) {
        this.setErrorThreshold(errorThreshold);
    }

    protected int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public int getErrorThreshold() {
        return this.errorThreshold;
    }

    @Override
    public void setErrorThreshold(int maxCount) {
        if (maxCount < 0) {
            throw new IllegalArgumentException("Threshold should be >= 0");
        }
        this.errorThreshold = maxCount;
    }

    protected boolean isReferingUnavailableCode(ModelElement me) {
        return false;
    }

    protected boolean isTemplateCode(ProgramElement pe) {
        return false;
    }

    protected boolean isIgnorable(Exception e) {
        if (e instanceof UnresolvedReferenceException) {
            ProgramElement unresolvedReference = ((UnresolvedReferenceException)e).getUnresolvedReference();
            if (this.isReferingUnavailableCode(unresolvedReference)) {
                return true;
            }
            return this.isTemplateCode(unresolvedReference);
        }
        return false;
    }

    protected void warningMessage(Exception e) {
        String className = e.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1);
        System.err.println("+++ Warning: " + className);
        System.err.println(e.getMessage());
        System.err.println();
    }

    protected void errorMessage(Exception e) {
        String className = e.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1);
        System.err.println("*** " + this.errorCount + ": " + className);
        System.err.println(e.getMessage());
        System.err.println();
    }

    protected void exitAction() {
        String msg = this.errorCount + " errors have occured - aborting.";
        System.err.println(msg);
        throw new ModelException(msg);
    }

    @Override
    public void reportError(Exception e) {
        if (this.isIgnorable(e)) {
            this.warningMessage(e);
        } else {
            ++this.errorCount;
            this.errorMessage(e);
            if (this.errorCount > this.errorThreshold) {
                this.exitAction();
            }
        }
    }

    @Override
    public void modelUpdating(EventObject event) {
    }

    @Override
    public void modelUpdated(EventObject event) {
        if (this.errorCount > 0) {
            this.exitAction();
        }
    }
}

