/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit.transformation.java5to4;

import java.util.ArrayList;
import java.util.List;
import recoder.CrossReferenceServiceConfiguration;
import recoder.ProgramFactory;
import recoder.abstraction.ArrayType;
import recoder.abstraction.ClassType;
import recoder.abstraction.IntersectionType;
import recoder.abstraction.Method;
import recoder.abstraction.PrimitiveType;
import recoder.abstraction.Type;
import recoder.convenience.TreeWalker;
import recoder.java.Expression;
import recoder.java.Identifier;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.declaration.VariableSpecification;
import recoder.java.expression.ArrayInitializer;
import recoder.java.expression.Operator;
import recoder.java.expression.ParenthesizedExpression;
import recoder.java.reference.ArrayReference;
import recoder.java.reference.MethodReference;
import recoder.java.reference.TypeReference;
import recoder.java.statement.Assert;
import recoder.java.statement.Return;
import recoder.java.statement.Switch;
import recoder.kit.MiscKit;
import recoder.kit.ProblemReport;
import recoder.kit.TwoPassTransformation;
import recoder.list.generic.ASTArrayList;
import recoder.service.NameInfo;
import recoder.service.SourceInfo;

public class ResolveBoxing
extends TwoPassTransformation {
    private final NonTerminalProgramElement root;
    private final List<Expression> toUnbox = new ArrayList<Expression>();
    private final List<Expression> toBox = new ArrayList<Expression>();

    public ResolveBoxing(CrossReferenceServiceConfiguration sc, NonTerminalProgramElement root) {
        super(sc);
        this.root = root;
    }

    @Override
    public ProblemReport analyze() {
        SourceInfo si = this.getServiceConfiguration().getSourceInfo();
        TreeWalker tw = new TreeWalker(this.root);
        while (tw.next()) {
            ProgramElement pe = tw.getProgramElement();
            if (!(pe instanceof Expression)) continue;
            NonTerminalProgramElement parent = pe.getASTParent();
            Expression e = (Expression)pe;
            Type t = si.getType(e);
            Type tt = null;
            if (parent instanceof MethodReference) {
                int idx;
                MethodReference mr = (MethodReference)parent;
                Method m = si.getMethod(mr);
                if (mr.getArguments() != null && (idx = mr.getArguments().indexOf(e)) != -1) {
                    tt = m.getSignature().get(idx);
                }
            } else if (parent instanceof Operator) {
                Type target;
                Operator op = (Operator)parent;
                if (op.getArity() == 2) {
                    target = si.getType(op);
                    if (target instanceof PrimitiveType && e instanceof ClassType) {
                        tt = target;
                    }
                } else if (op.getArity() == 3 && op.getArguments().get(0) != e) {
                    target = si.getType(op);
                    if (target instanceof IntersectionType) {
                        this.toBox.add(e);
                    }
                    if (t instanceof PrimitiveType && target instanceof ClassType) {
                        this.toBox.add(e);
                    }
                }
            } else if (parent instanceof VariableSpecification) {
                tt = ((VariableSpecification)parent).getType();
            } else if (parent instanceof Return) {
                tt = si.getType(MiscKit.getParentMemberDeclaration(parent));
            } else if (parent instanceof Switch) {
                if (t instanceof ClassType && !((ClassType)t).isEnumType()) {
                    this.toUnbox.add(e);
                }
            } else if (parent instanceof Assert) {
                if (t instanceof ClassType) {
                    this.toUnbox.add(e);
                }
            } else if (parent instanceof ArrayReference) {
                if (t instanceof ClassType) {
                    this.toUnbox.add(e);
                }
            } else if (parent instanceof ArrayInitializer) {
                tt = ((ArrayType)si.getType((ArrayInitializer)parent)).getBaseType();
            }
            if (tt == null) continue;
            if (tt instanceof ClassType && t instanceof PrimitiveType) {
                this.toBox.add(e);
                continue;
            }
            if (!(tt instanceof PrimitiveType) || !(t instanceof ClassType)) continue;
            this.toUnbox.add(e);
        }
        return super.analyze();
    }

    @Override
    public void transform() {
        MethodReference replacement;
        Identifier id;
        Type t;
        super.transform();
        ProgramFactory f = this.getProgramFactory();
        SourceInfo si = this.getServiceConfiguration().getSourceInfo();
        NameInfo ni = this.getServiceConfiguration().getNameInfo();
        for (Expression e : this.toBox) {
            t = (PrimitiveType)si.getType(e);
            if (t == ni.getBooleanType()) {
                id = f.createIdentifier("Boolean");
            } else if (t == ni.getByteType()) {
                id = f.createIdentifier("Byte");
            } else if (t == ni.getShortType()) {
                id = f.createIdentifier("Short");
            } else if (t == ni.getCharType()) {
                id = f.createIdentifier("Character");
            } else if (t == ni.getIntType()) {
                id = f.createIdentifier("Integer");
            } else if (t == ni.getLongType()) {
                id = f.createIdentifier("Long");
            } else if (t == ni.getFloatType()) {
                id = f.createIdentifier("Float");
            } else if (t == ni.getDoubleType()) {
                id = f.createIdentifier("Double");
            } else {
                throw new Error();
            }
            TypeReference tr = f.createTypeReference(id);
            replacement = f.createMethodReference(tr, f.createIdentifier("valueOf"), new ASTArrayList<Expression>(e.deepClone()));
            this.replace(e, replacement);
        }
        for (Expression e : this.toUnbox) {
            t = (ClassType)si.getType(e);
            if (t == ni.getJavaLangBoolean()) {
                id = f.createIdentifier("booleanValue");
            } else if (t == ni.getJavaLangByte()) {
                id = f.createIdentifier("byteValue");
            } else if (t == ni.getJavaLangShort()) {
                id = f.createIdentifier("shortValue");
            } else if (t == ni.getJavaLangCharacter()) {
                id = f.createIdentifier("charValue");
            } else if (t == ni.getJavaLangInteger()) {
                id = f.createIdentifier("intValue");
            } else if (t == ni.getJavaLangLong()) {
                id = f.createIdentifier("longValue");
            } else if (t == ni.getJavaLangFloat()) {
                id = f.createIdentifier("floatValue");
            } else if (t == ni.getJavaLangDouble()) {
                id = f.createIdentifier("doubleValue");
            } else {
                throw new Error("cannot unbox type " + t.getFullName() + " (" + String.valueOf(t.getClass()) + ")");
            }
            ParenthesizedExpression rp = e instanceof ParenthesizedExpression ? (ParenthesizedExpression)e.deepClone() : f.createParenthesizedExpression(e.deepClone());
            replacement = f.createMethodReference(rp, id);
            this.replace(e, replacement);
        }
    }
}

