/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit.transformation.java5to4;

import java.util.ArrayList;
import java.util.List;
import recoder.CrossReferenceServiceConfiguration;
import recoder.abstraction.ClassType;
import recoder.abstraction.Type;
import recoder.convenience.Naming;
import recoder.convenience.TreeWalker;
import recoder.java.CompilationUnit;
import recoder.java.Import;
import recoder.java.ProgramElement;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.reference.FieldReference;
import recoder.java.reference.MemberReference;
import recoder.java.reference.MethodReference;
import recoder.java.reference.NameReference;
import recoder.java.reference.ReferenceSuffix;
import recoder.java.reference.TypeReference;
import recoder.kit.MiscKit;
import recoder.kit.ProblemReport;
import recoder.kit.TwoPassTransformation;
import recoder.kit.UnitKit;
import recoder.list.generic.ASTList;

public class RemoveStaticImports
extends TwoPassTransformation {
    private final CompilationUnit cu;
    private List<Item> hotSpots;
    private List<Import> statics;

    public RemoveStaticImports(CrossReferenceServiceConfiguration sc, CompilationUnit cu) {
        super(sc);
        this.cu = cu;
    }

    @Override
    public ProblemReport analyze() {
        this.hotSpots = new ArrayList<Item>();
        this.statics = new ArrayList<Import>();
        ASTList<Import> il = this.cu.getImports();
        if (il == null || il.isEmpty()) {
            return IDENTITY;
        }
        for (Import im : il) {
            if (!im.isStaticImport()) continue;
            this.statics.add(im);
        }
        if (this.statics.isEmpty()) {
            return IDENTITY;
        }
        TreeWalker tw = new TreeWalker(this.cu);
        block1: while (tw.next()) {
            ClassType targetCT;
            ProgramElement pe = tw.getProgramElement();
            if (!(pe instanceof MemberReference) || !(pe instanceof ReferenceSuffix) || !(pe instanceof NameReference)) continue;
            MemberReference r = (MemberReference)pe;
            ReferenceSuffix s = (ReferenceSuffix)pe;
            NameReference nr = (NameReference)pe;
            if (s.getReferencePrefix() != null) continue;
            if (r instanceof MethodReference) {
                targetCT = this.getSourceInfo().getMethod((MethodReference)r).getContainingClassType();
            } else if (r instanceof FieldReference) {
                targetCT = this.getSourceInfo().getField((FieldReference)r).getContainingClassType();
            } else {
                Type t;
                if (!(r instanceof TypeReference) || !((t = this.getSourceInfo().getType((TypeReference)r)) instanceof ClassType)) continue;
                targetCT = (ClassType)t;
            }
            if (targetCT instanceof TypeDeclaration && UnitKit.getCompilationUnit((TypeDeclaration)targetCT) == this.cu) continue;
            String n = nr.getName();
            for (Import im : this.statics) {
                TypeReference tr = im.getTypeReference();
                if (this.getSourceInfo().getType(tr) != targetCT || !im.isMultiImport() && !n.equals(im.getStaticIdentifier().getText())) continue;
                TypeReference prefix = im.getTypeReference();
                this.hotSpots.add(new Item(nr, prefix));
                continue block1;
            }
        }
        return super.analyze();
    }

    @Override
    public void transform() {
        super.transform();
        for (Import i : this.statics) {
            this.detach(i);
        }
        for (Item hs : this.hotSpots) {
            String x = Naming.toPathName(hs.prefix, hs.r.getName());
            if (x.startsWith("java.lang.")) {
                x = x.substring(10);
            }
            this.replace(hs.r, MiscKit.createUncollatedReferenceQualifier(this.getProgramFactory(), x));
        }
    }

    private static class Item {
        final NameReference r;
        final TypeReference prefix;

        Item(NameReference r, TypeReference prefix) {
            this.r = r;
            this.prefix = prefix;
        }
    }
}

