/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit.transformation.java5to4;

import java.util.ArrayList;
import java.util.List;
import recoder.CrossReferenceServiceConfiguration;
import recoder.ModelException;
import recoder.ProgramFactory;
import recoder.abstraction.ArrayType;
import recoder.abstraction.ClassType;
import recoder.abstraction.Method;
import recoder.abstraction.ParameterizedType;
import recoder.abstraction.PrimitiveType;
import recoder.abstraction.Type;
import recoder.abstraction.TypeArgument;
import recoder.abstraction.TypeParameter;
import recoder.convenience.TreeWalker;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.TypeArgumentDeclaration;
import recoder.java.reference.MemberReference;
import recoder.java.reference.MethodReference;
import recoder.java.reference.TypeReference;
import recoder.kit.MethodKit;
import recoder.kit.ProblemReport;
import recoder.kit.TwoPassTransformation;
import recoder.kit.TypeKit;
import recoder.list.generic.ASTArrayList;
import recoder.list.generic.ASTList;
import recoder.service.DefaultSourceInfo;

public class RemoveCoVariantReturnTypes
extends TwoPassTransformation {
    private final NonTerminalProgramElement root;
    private List<Item> items;

    public RemoveCoVariantReturnTypes(CrossReferenceServiceConfiguration sc, NonTerminalProgramElement root) {
        super(sc);
        this.root = root;
    }

    @Override
    public ProblemReport analyze() {
        this.items = new ArrayList<Item>();
        TreeWalker tw = new TreeWalker(this.root);
        while (tw.next()) {
            List<Method> ml;
            ProgramElement pe = tw.getProgramElement();
            if (!(pe instanceof MethodDeclaration)) continue;
            MethodDeclaration md = (MethodDeclaration)pe;
            Type returnType = this.getSourceInfo().getReturnType(md);
            if (returnType == null || returnType instanceof PrimitiveType || (ml = MethodKit.getRedefinedMethods(md)).size() == 0) continue;
            ArrayList<ClassType> ctml = new ArrayList<ClassType>(ml.size());
            for (Method method : ml) {
                Type rt = this.getSourceInfo().getReturnType(method);
                if (!(rt instanceof ClassType) || ctml.contains(rt)) continue;
                ctml.add((ClassType)rt);
            }
            ArrayList ctml_copy = new ArrayList(ctml);
            TypeKit.removeCoveredSubtypes(this.getSourceInfo(), ctml);
            if (ctml.size() != 1) {
                if (ctml.size() == 0 && returnType instanceof ArrayType) continue;
                throw new ModelException();
            }
            Type originalType = (Type)ctml.get(0);
            if (((DefaultSourceInfo)this.getSourceInfo()).containsTypeParameter(originalType)) {
                originalType = this.makeSomething(originalType);
            }
            if (originalType == returnType) continue;
            TypeReference originalTypeReference = TypeKit.createTypeReference(this.getProgramFactory(), originalType);
            TypeReference castToReference = TypeKit.createTypeReference(this.getProgramFactory(), returnType);
            ASTList<TypeArgumentDeclaration> targs = md.getTypeReference().getTypeArguments();
            if (targs != null && targs.size() > 0) {
                castToReference.setTypeArguments(targs.deepClone());
            }
            if (originalType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)originalType;
                targs = TypeKit.makeTypeArgRef(this.getProgramFactory(), pt.getTypeArgs());
                originalTypeReference.setTypeArguments(targs);
            }
            this.items.add(new Item(md, this.getCrossReferenceSourceInfo().getReferences(md), originalTypeReference, castToReference));
        }
        return super.analyze();
    }

    private Type makeSomething(Type originalType) {
        if (originalType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)originalType;
            ClassType baseType = (ClassType)this.makeSomething0(pt.getGenericType());
            ASTArrayList<int> targs = new ASTArrayList<int>(pt.getTypeArgs().size());
            for (TypeArgument typeArgument : pt.getTypeArgs()) {
                targs.add((int)this.makeSomething1(typeArgument));
            }
            return new ParameterizedType(baseType, targs);
        }
        return this.makeSomething0(originalType);
    }

    private Type makeSomething0(Type originalType) {
        if (!(originalType instanceof TypeParameter)) {
            return originalType;
        }
        TypeParameter tp = (TypeParameter)originalType;
        if (tp.getBoundCount() == 0) {
            originalType = this.getNameInfo().getJavaLangObject();
        } else {
            String tname = tp.getBoundName(0);
            originalType = this.getNameInfo().getClassType(tname);
            if (((ClassType)originalType).isInterface()) {
                originalType = this.getNameInfo().getJavaLangObject();
            }
        }
        return originalType;
    }

    private TypeArgumentDeclaration makeSomething1(TypeArgument ta) {
        TypeArgumentDeclaration res = new TypeArgumentDeclaration();
        res.setTypeReference(TypeKit.createTypeReference(this.getProgramFactory(), ta.getTypeName()));
        if (ta.getTypeArguments() != null && ta.getTypeArguments().size() > 0) {
            ASTArrayList<int> targs = new ASTArrayList<int>(ta.getTypeArguments().size());
            for (TypeArgument typeArgument : ta.getTypeArguments()) {
                targs.add((int)this.makeSomething1(typeArgument));
            }
            res.getTypeReference().setTypeArguments(targs);
            res.getTypeReference().makeParentRoleValid();
        }
        return res;
    }

    @Override
    public void transform() {
        super.transform();
        ProgramFactory f = this.getProgramFactory();
        for (Item it : this.items) {
            this.replace(it.md.getTypeReference(), it.rt.deepClone());
            for (int i = 0; i < it.mrl.size(); ++i) {
                MethodReference mr = (MethodReference)it.mrl.get(i);
                this.replace(mr, f.createParenthesizedExpression(f.createTypeCast(mr.deepClone(), it.t.deepClone())));
            }
        }
    }

    private static class Item {
        final MethodDeclaration md;
        final List<MemberReference> mrl;
        final TypeReference t;
        final TypeReference rt;

        Item(MethodDeclaration md, List<MemberReference> mrl, TypeReference rt, TypeReference t) {
            this.md = md;
            this.mrl = mrl;
            this.rt = rt;
            this.t = t;
        }
    }
}

