/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit.transformation.java5to4;

import java.util.ArrayList;
import java.util.List;
import recoder.CrossReferenceServiceConfiguration;
import recoder.ProgramFactory;
import recoder.abstraction.IntersectionType;
import recoder.abstraction.Method;
import recoder.abstraction.PrimitiveType;
import recoder.abstraction.Type;
import recoder.convenience.TreeWalker;
import recoder.java.Expression;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.expression.operator.Conditional;
import recoder.java.reference.MethodReference;
import recoder.kit.ProblemReport;
import recoder.kit.TwoPassTransformation;
import recoder.kit.TypeKit;

public class MakeConditionalCompatible
extends TwoPassTransformation {
    private final NonTerminalProgramElement root;
    private List<Item> list;

    public MakeConditionalCompatible(CrossReferenceServiceConfiguration sc, NonTerminalProgramElement root) {
        super(sc);
        this.root = root;
    }

    @Override
    public ProblemReport analyze() {
        this.list = new ArrayList<Item>();
        this.setProblemReport(NO_PROBLEM);
        TreeWalker tw = new TreeWalker(this.root);
        while (tw.next()) {
            Type target;
            ProgramElement pe = tw.getProgramElement();
            if (!(pe instanceof Conditional)) continue;
            Conditional c = (Conditional)pe;
            Type t = this.getSourceInfo().getType(c);
            Type e1 = this.getSourceInfo().getType(c.getExpressionAt(1));
            Type e2 = this.getSourceInfo().getType(c.getExpressionAt(2));
            if (!(t instanceof IntersectionType) && (e1 == e2 || e1 instanceof PrimitiveType && e2 instanceof PrimitiveType || e1 == this.getNameInfo().getNullType() || e2 == this.getNameInfo().getNullType() || this.getSourceInfo().isWidening(e1, e2) || this.getSourceInfo().isWidening(e2, e1))) continue;
            Expression parent = (Expression)((Object)c.getASTParent());
            if (parent instanceof MethodReference) {
                Method m = this.getSourceInfo().getMethod((MethodReference)parent);
                target = m.getContainingClassType();
            } else {
                target = this.getSourceInfo().getType(parent);
            }
            this.list.add(new Item(c, target));
        }
        if (this.list.isEmpty()) {
            return IDENTITY;
        }
        return NO_PROBLEM;
    }

    @Override
    public void transform() {
        super.transform();
        ProgramFactory f = this.getProgramFactory();
        for (Item i : this.list) {
            Expression e1 = i.c.getExpressionAt(1);
            Expression e2 = i.c.getExpressionAt(2);
            this.replace(e1, f.createTypeCast(e1.deepClone(), TypeKit.createTypeReference(f, i.t)));
            this.replace(e2, f.createTypeCast(e2.deepClone(), TypeKit.createTypeReference(f, i.t)));
        }
    }

    private static class Item {
        final Conditional c;
        final Type t;

        Item(Conditional c, Type t) {
            this.c = c;
            this.t = t;
        }
    }
}

