/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit.transformation;

import java.util.ArrayList;
import java.util.List;
import recoder.CrossReferenceServiceConfiguration;
import recoder.ProgramFactory;
import recoder.abstraction.Type;
import recoder.java.Expression;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.Statement;
import recoder.java.StatementBlock;
import recoder.java.declaration.ClassInitializer;
import recoder.java.declaration.FieldDeclaration;
import recoder.java.declaration.FieldSpecification;
import recoder.java.declaration.LocalVariableDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.declaration.VariableSpecification;
import recoder.java.expression.operator.CopyAssignment;
import recoder.java.reference.TypeReference;
import recoder.java.reference.VariableReference;
import recoder.kit.ExpressionKit;
import recoder.kit.Problem;
import recoder.kit.ProblemReport;
import recoder.kit.TwoPassTransformation;
import recoder.kit.TypeKit;
import recoder.kit.VariableKit;
import recoder.kit.transformation.PrepareStatementList;
import recoder.list.generic.ASTList;
import recoder.service.SourceInfo;
import recoder.util.Debug;

public class ShiftPreceedingStatementExpressions
extends TwoPassTransformation {
    private final Expression expression;
    private List<Expression> preceeding;
    private List<Statement> tempVarDecls;
    private List<VariableReference> tempVarRefs;
    private NonTerminalProgramElement parent;
    private PrepareStatementList preparer;
    private Statement newParent;

    public ShiftPreceedingStatementExpressions(CrossReferenceServiceConfiguration sc, Expression x) {
        super(sc);
        if (x == null) {
            throw new IllegalArgumentException("Missing expression");
        }
        this.expression = x;
    }

    @Override
    public ProblemReport analyze() {
        this.preceeding = ExpressionKit.collectPreceedingExpressions(this.expression);
        int exSize = this.preceeding.size();
        for (int i = exSize - 1; i >= 0; --i) {
            if (ExpressionKit.containsStatements(this.preceeding.get(i))) continue;
            this.preceeding.remove(i);
        }
        if (this.expression instanceof Statement && ((Statement)((Object)this.expression)).getStatementContainer() != null) {
            this.parent = (NonTerminalProgramElement)((Object)this.expression);
        } else {
            ProgramElement pe = this.expression;
            while (pe != null) {
                this.parent = pe.getASTParent();
                if (this.parent instanceof Statement && ((Statement)((Object)this.parent)).getStatementContainer() != null || this.parent instanceof FieldSpecification) break;
                pe = this.parent;
            }
        }
        exSize = this.preceeding.size();
        if (exSize == 0 && this.parent instanceof Statement) {
            return this.setProblemReport(IDENTITY);
        }
        ProgramFactory f = this.getProgramFactory();
        SourceInfo si = this.getSourceInfo();
        if (exSize > 0) {
            Type[] exTypes = new Type[exSize];
            for (int i = 0; i < exSize; ++i) {
                Expression ex = this.preceeding.get(i);
                exTypes[i] = si.getType(ex);
            }
            String[] varNames = VariableKit.getNewVariableNames(si, exTypes, this.expression);
            this.tempVarDecls = new ArrayList<Statement>(exSize);
            this.tempVarRefs = new ArrayList<VariableReference>(exSize);
            for (int i = 0; i < exSize; ++i) {
                Type t = exTypes[i];
                TypeReference minTypeRef = TypeKit.createTypeReference(si, t, this.expression);
                String varName = varNames[i];
                LocalVariableDeclaration vdecl = f.createLocalVariableDeclaration(minTypeRef, f.createIdentifier(varName));
                VariableSpecification vspec = vdecl.getVariables().get(0);
                ShiftPreceedingStatementExpressions.doAttach(this.preceeding.get(i).deepClone(), vspec);
                this.tempVarDecls.add(vdecl);
                VariableReference vref = f.createVariableReference(f.createIdentifier(varName));
                vref.makeAllParentRolesValid();
                this.tempVarRefs.add(vref);
            }
        }
        if (this.parent instanceof Statement) {
            this.preparer = new PrepareStatementList(this.getServiceConfiguration(), (Statement)((Object)this.parent), this.isVisible());
            ProblemReport report = this.preparer.analyze();
            if (report instanceof Problem) {
                return this.setProblemReport(report);
            }
        }
        return this.setProblemReport(EQUIVALENCE);
    }

    @Override
    public void transform() {
        int exSize;
        super.transform();
        if (this.parent instanceof Statement) {
            this.newParent = (Statement)((Object)this.parent);
        }
        if ((exSize = this.preceeding.size()) == 0) {
            return;
        }
        int tempSize = this.tempVarDecls.size();
        if (this.parent instanceof Statement) {
            this.preparer.transform();
            ASTList<Statement> destination = this.preparer.getStatementList();
            this.parent = (NonTerminalProgramElement)((Object)this.preparer.getStatement());
            int destIndex = 0;
            while (destination.get(destIndex) != this.parent) {
                ++destIndex;
            }
            for (Statement child : this.tempVarDecls) {
                destination.add(destIndex, child);
                child.setStatementContainer(((Statement)((Object)this.parent)).getStatementContainer());
                if (!this.isVisible()) continue;
                this.getChangeHistory().attached(child);
            }
            for (int i = 0; i < exSize; ++i) {
                this.replace(this.preceeding.get(i), this.tempVarRefs.get(i));
            }
        } else if (this.parent instanceof FieldSpecification) {
            ProgramFactory f = this.getProgramFactory();
            FieldSpecification fs = (FieldSpecification)this.parent;
            StatementBlock body = f.createStatementBlock();
            for (int i = 0; i < tempSize; ++i) {
                ShiftPreceedingStatementExpressions.doAttach(this.tempVarDecls.get(i), body, i);
            }
            Expression init = fs.getInitializer();
            Debug.assertNonnull(init);
            for (int i = 0; i < exSize; ++i) {
                this.replace(this.preceeding.get(i), this.tempVarRefs.get(i));
            }
            this.detach(init);
            CopyAssignment ca = f.createCopyAssignment(f.createVariableReference(f.createIdentifier(fs.getName())), init.deepClone());
            this.newParent = ca;
            ShiftPreceedingStatementExpressions.doAttach((Statement)ca, body, tempSize);
            FieldDeclaration fd = (FieldDeclaration)fs.getParent();
            ClassInitializer ci = fd.isStatic() ? f.createClassInitializer(f.createStatic(), body) : f.createClassInitializer(body);
            ci.makeAllParentRolesValid();
            TypeDeclaration tdecl = fd.getMemberParent();
            this.attach(ci, tdecl, tdecl.getMembers().indexOf(fd) + 1);
        }
    }

    public NonTerminalProgramElement getTopMostParent() {
        return this.parent;
    }

    public Statement getEnclosingStatement() {
        if (this.newParent == null) {
            throw new IllegalStateException("Only valid after transformation");
        }
        return this.newParent;
    }
}

