/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit.transformation;

import java.util.ArrayList;
import java.util.List;
import recoder.CrossReferenceServiceConfiguration;
import recoder.ProgramFactory;
import recoder.java.declaration.VariableSpecification;
import recoder.java.reference.VariableReference;
import recoder.kit.ProblemReport;
import recoder.kit.TwoPassTransformation;

public class RenameVariable
extends TwoPassTransformation {
    private final VariableSpecification vs;
    private final String newName;
    private List<VariableReference> refs;

    public RenameVariable(CrossReferenceServiceConfiguration sc, VariableSpecification vs, String newName) {
        super(sc);
        if (vs == null) {
            throw new IllegalArgumentException("Missing variable");
        }
        if (newName == null) {
            throw new IllegalArgumentException("Missing name");
        }
        this.vs = vs;
        this.newName = newName;
    }

    @Override
    public ProblemReport analyze() {
        this.refs = new ArrayList<VariableReference>();
        if (this.newName.equals(this.vs.getName())) {
            return this.setProblemReport(IDENTITY);
        }
        this.refs.addAll(this.getCrossReferenceSourceInfo().getReferences(this.vs));
        return this.setProblemReport(EQUIVALENCE);
    }

    @Override
    public void transform() {
        super.transform();
        ProgramFactory pf = this.getProgramFactory();
        this.replace(this.vs.getIdentifier(), pf.createIdentifier(this.newName));
        for (int i = this.refs.size() - 1; i >= 0; --i) {
            this.replace(this.refs.get(i).getIdentifier(), pf.createIdentifier(this.newName));
        }
    }
}

