/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit.transformation;

import java.util.ArrayList;
import java.util.List;
import recoder.CrossReferenceServiceConfiguration;
import recoder.ProgramFactory;
import recoder.abstraction.ArrayType;
import recoder.abstraction.Constructor;
import recoder.java.declaration.ConstructorDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.reference.TypeReference;
import recoder.kit.ProblemReport;
import recoder.kit.TwoPassTransformation;
import recoder.service.NameInfo;

public class RenameType
extends TwoPassTransformation {
    private final TypeDeclaration type;
    private final String newName;
    private List<TypeReference> refs;
    private List<? extends Constructor> cons;

    public RenameType(CrossReferenceServiceConfiguration sc, TypeDeclaration type, String newName) {
        super(sc);
        if (type == null) {
            throw new IllegalArgumentException("Missing type");
        }
        if (type.getName() == null) {
            throw new IllegalArgumentException("May not rename anonymous types");
        }
        if (newName == null) {
            throw new IllegalArgumentException("Missing name");
        }
        this.type = type;
        this.newName = newName;
    }

    @Override
    public ProblemReport analyze() {
        this.refs = new ArrayList<TypeReference>();
        if (this.newName.equals(this.type.getName())) {
            return this.setProblemReport(IDENTITY);
        }
        NameInfo ni = this.getNameInfo();
        this.refs.addAll(this.getCrossReferenceSourceInfo().getReferences(this.type));
        this.cons = this.type.getConstructors();
        if (this.cons == null) {
            this.cons = new ArrayList<Constructor>(0);
        }
        ArrayType atype = ni.getArrayType(this.type);
        while (atype != null) {
            this.refs.addAll(this.getCrossReferenceSourceInfo().getReferences(atype));
            atype = ni.getArrayType(atype);
        }
        return this.setProblemReport(EQUIVALENCE);
    }

    @Override
    public void transform() {
        int i;
        super.transform();
        ProgramFactory pf = this.getProgramFactory();
        this.replace(this.type.getIdentifier(), pf.createIdentifier(this.newName));
        for (i = this.cons.size() - 1; i >= 0; --i) {
            Constructor con = this.cons.get(i);
            if (!(con instanceof ConstructorDeclaration)) continue;
            this.replace(((ConstructorDeclaration)con).getIdentifier(), pf.createIdentifier(this.newName));
        }
        for (i = this.refs.size() - 1; i >= 0; --i) {
            this.replace(this.refs.get(i).getIdentifier(), pf.createIdentifier(this.newName));
        }
    }
}

