/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit;

import java.util.ArrayList;
import java.util.List;
import recoder.ProgramFactory;
import recoder.abstraction.ArrayType;
import recoder.abstraction.ClassType;
import recoder.abstraction.ClassTypeContainer;
import recoder.abstraction.Constructor;
import recoder.abstraction.Member;
import recoder.abstraction.Package;
import recoder.abstraction.ParameterizedType;
import recoder.abstraction.PrimitiveType;
import recoder.abstraction.Type;
import recoder.abstraction.TypeArgument;
import recoder.convenience.TreeWalker;
import recoder.java.Identifier;
import recoder.java.NamedProgramElement;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.declaration.ClassDeclaration;
import recoder.java.declaration.ConstructorDeclaration;
import recoder.java.declaration.DeclarationSpecifier;
import recoder.java.declaration.FieldDeclaration;
import recoder.java.declaration.FieldSpecification;
import recoder.java.declaration.Implements;
import recoder.java.declaration.InterfaceDeclaration;
import recoder.java.declaration.MemberDeclaration;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.Throws;
import recoder.java.declaration.TypeArgumentDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.declaration.VariableSpecification;
import recoder.java.declaration.modifier.VisibilityModifier;
import recoder.java.reference.FieldReference;
import recoder.java.reference.TypeReference;
import recoder.kit.MethodKit;
import recoder.kit.MiscKit;
import recoder.kit.NameClashException;
import recoder.kit.PackageKit;
import recoder.list.generic.ASTArrayList;
import recoder.list.generic.ASTList;
import recoder.service.ChangeHistory;
import recoder.service.CrossReferenceSourceInfo;
import recoder.service.NameInfo;
import recoder.service.ProgramModelInfo;
import recoder.service.SourceInfo;
import recoder.util.Debug;

public class TypeKit {
    private TypeKit() {
    }

    public static TypeReference createTypeReference(ConstructorDeclaration decl) {
        ProgramFactory f = decl.getFactory();
        TypeReference result = f.createTypeReference(f.createIdentifier(decl.getName()));
        result.makeAllParentRolesValid();
        return result;
    }

    public static TypeReference createTypeReference(ProgramFactory f, String qualifiedName) {
        return MiscKit.createUncollatedReferenceQualifier(f, qualifiedName).toTypeReference();
    }

    public static ASTList<TypeArgumentDeclaration> makeTypeArgRef(ProgramFactory f, List<? extends TypeArgument> tas) {
        ASTArrayList<int> res = new ASTArrayList<int>(tas.size());
        for (TypeArgument typeArgument : tas) {
            TypeReference tr = TypeKit.createTypeReference(f, typeArgument.getTypeName());
            if (typeArgument.getTypeArguments() != null) {
                tr.setTypeArguments(TypeKit.makeTypeArgRef(f, typeArgument.getTypeArguments()));
            }
            res.add((int)new TypeArgumentDeclaration(tr, typeArgument.getWildcardMode()));
        }
        return res;
    }

    public static TypeReference createTypeReference(ProgramFactory f, Type t, boolean addTypeArgs) {
        TypeReference result = null;
        if (t instanceof PrimitiveType) {
            result = f.createTypeReference(f.createIdentifier(t.getName()));
        } else if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            result = TypeKit.createTypeReference(f, pt.getGenericType());
            if (addTypeArgs) {
                result.setTypeArguments(TypeKit.makeTypeArgRef(f, pt.getTypeArgs()));
            }
        } else if (t instanceof ClassType) {
            result = f.createTypeReference(f.createIdentifier(t.getName()));
            ClassTypeContainer ctc = ((ClassType)t).getContainer();
            if (ctc instanceof Package) {
                result.setReferencePrefix(PackageKit.createPackageReference(f, (Package)ctc));
            } else if (ctc instanceof ClassType) {
                result.setReferencePrefix(TypeKit.createTypeReference(f, (ClassType)ctc));
            }
        } else if (t instanceof ArrayType) {
            result = TypeKit.createTypeReference(f, ((ArrayType)t).getBaseType());
            result.setDimensions(result.getDimensions() + 1);
        }
        result.makeParentRoleValid();
        return result;
    }

    public static TypeReference createTypeReference(ProgramFactory f, Type t) {
        return TypeKit.createTypeReference(f, t, false);
    }

    public static TypeReference createTypeReference(SourceInfo si, Type t, ProgramElement context) {
        TypeReference result = null;
        ProgramFactory f = context.getFactory();
        if (t instanceof PrimitiveType) {
            result = f.createTypeReference(f.createIdentifier(t.getName()));
        } else if (t instanceof ClassType) {
            result = f.createTypeReference(f.createIdentifier(t.getName()));
            ClassTypeContainer ctc = ((ClassType)t).getContainer();
            if (ctc != null && si.getType(t.getName(), context) != t) {
                if (ctc instanceof Package) {
                    result.setReferencePrefix(PackageKit.createPackageReference(f, (Package)ctc));
                } else if (ctc instanceof ClassType) {
                    result.setReferencePrefix(TypeKit.createTypeReference(f, (ClassType)ctc));
                }
            }
        } else if (t instanceof ArrayType) {
            result = TypeKit.createTypeReference(si, ((ArrayType)t).getBaseType(), context);
            result.setDimensions(result.getDimensions() + 1);
        }
        result.makeAllParentRolesValid();
        return result;
    }

    public static InterfaceDeclaration createAbstractSuperClass(NameInfo ni, ClassDeclaration cdecl, String abstractsupername) throws NameClashException {
        String message = "Sorry, only public classes which are neither interfaces nor enums can be transformed.";
        Debug.assertBoolean(cdecl.isPublic() && !cdecl.isInterface() && !cdecl.isEnumType(), message);
        if (ni.getType(abstractsupername) != null) {
            throw new NameClashException("Error: Name " + abstractsupername + "is already declared.");
        }
        ProgramFactory pf = cdecl.getFactory();
        ASTArrayList<boolean> imembers = new ASTArrayList<boolean>(true);
        ASTList<MemberDeclaration> cmems = cdecl.getMembers();
        if (cmems != null) {
            for (MemberDeclaration cmemd : cmems) {
                if (!cmemd.isPublic()) continue;
                if (cmemd instanceof FieldDeclaration) {
                    if (!((FieldDeclaration)cmemd).isFinal() || !cmemd.isStatic()) continue;
                    FieldDeclaration d = (FieldDeclaration)cmemd.deepClone();
                    ASTList<FieldSpecification> vars = d.getFieldSpecifications();
                    int z = vars.size();
                    for (int j = 0; j < z; ++j) {
                        if (((FieldSpecification)vars.get(j)).getInitializer() != null) continue;
                        vars.remove(j);
                        --j;
                        --z;
                    }
                    if (vars.size() <= 0) continue;
                    imembers.add((boolean)d);
                    continue;
                }
                if (cmemd instanceof MethodDeclaration) {
                    MethodDeclaration md = (MethodDeclaration)cmemd;
                    if (md.isStatic() || !md.isPublic() || md instanceof ConstructorDeclaration) continue;
                    imembers.add((boolean)MethodKit.createAbstractMethodDeclaration(md, true));
                    continue;
                }
                if (!(cmemd instanceof TypeDeclaration)) continue;
                imembers.add((boolean)((TypeDeclaration)cmemd.deepClone()));
            }
            if (!imembers.isEmpty()) {
                Identifier iid = pf.createIdentifier(abstractsupername);
                VisibilityModifier vis = cdecl.getVisibilityModifier();
                ASTArrayList<boolean> imods = null;
                if (vis != null) {
                    imods = new ASTArrayList<boolean>(true);
                    imods.add((boolean)((DeclarationSpecifier)vis.deepClone()));
                }
                InterfaceDeclaration idecl = pf.createInterfaceDeclaration(imods, iid, null, imembers);
                ASTList<Object> itypes = new ASTArrayList<boolean>(true);
                TypeReference iref = pf.createTypeReference(iid);
                Implements impl = cdecl.getImplementedTypes();
                if (impl == null) {
                    impl = new Implements(iref);
                } else {
                    itypes = impl.getSupertypes();
                    itypes.add((boolean)iref);
                    impl.setSupertypes(itypes);
                }
                cdecl.setImplementedTypes(impl);
                return idecl;
            }
            return null;
        }
        return null;
    }

    public static InterfaceDeclaration createInterfaceDeclaration(ClassDeclaration decl) {
        ProgramFactory factory = decl.getFactory();
        InterfaceDeclaration res = factory.createInterfaceDeclaration();
        res.setIdentifier(factory.createIdentifier("Abstract" + decl.getName()));
        VisibilityModifier vis = decl.getVisibilityModifier();
        if (vis != null) {
            ASTArrayList<boolean> imods = new ASTArrayList<boolean>(true);
            imods.add((boolean)((DeclarationSpecifier)vis.deepClone()));
            res.setDeclarationSpecifiers(imods);
        }
        ASTArrayList<MemberDeclaration> imembers = new ASTArrayList<MemberDeclaration>();
        res.setMembers(imembers);
        ASTList<MemberDeclaration> cmems = decl.getMembers();
        if (cmems == null) {
            return res;
        }
        for (MemberDeclaration cmemd : cmems) {
            if (!cmemd.isPublic()) continue;
            if (cmemd instanceof FieldDeclaration) {
                if (!((FieldDeclaration)cmemd).isFinal() || !cmemd.isStatic()) continue;
                FieldDeclaration d = (FieldDeclaration)cmemd.deepClone();
                ASTList<FieldSpecification> vars = d.getFieldSpecifications();
                int z = vars.size();
                for (int j = 0; j < z; ++j) {
                    if (((FieldSpecification)vars.get(j)).getInitializer() != null) continue;
                    vars.remove(j);
                    --j;
                    --z;
                }
                if (vars.size() <= 0) continue;
                imembers.add(d);
                continue;
            }
            if (cmemd instanceof MethodDeclaration) {
                if (cmemd instanceof ConstructorDeclaration || cmemd.isStatic()) continue;
                imembers.add(MethodKit.createAbstractMethodDeclaration((MethodDeclaration)cmemd, true));
                continue;
            }
            if (!(cmemd instanceof TypeDeclaration)) continue;
            imembers.add((TypeDeclaration)cmemd.deepClone());
        }
        return res;
    }

    @Deprecated
    public static ClassDeclaration createAdapterClass(String adapterName, ClassDeclaration classDecl) {
        ProgramFactory factory = classDecl.getFactory();
        FieldReference delegationObject = new FieldReference(factory.createIdentifier("delegationObject" + classDecl.getName()));
        ClassDeclaration adapterClass = factory.createClassDeclaration(new ASTArrayList<DeclarationSpecifier>(), factory.createIdentifier(adapterName), factory.createExtends(), factory.createImplements(), new ASTArrayList<MemberDeclaration>());
        for (int i2 = 0; i2 < classDecl.getMembers().size(); ++i2) {
            MethodDeclaration method;
            MemberDeclaration member = (MemberDeclaration)classDecl.getMembers().get(i2);
            if (!(member instanceof MethodDeclaration) || !(method = (MethodDeclaration)member).isPublic()) continue;
            Debug.info(2, "adapting public method " + method.getName());
            MethodDeclaration clone = MethodKit.createAdapterMethod(delegationObject, method);
            if (clone == null) continue;
            adapterClass.getMembers().add(clone);
        }
        return adapterClass;
    }

    @Deprecated
    public static boolean rename(ChangeHistory ch, CrossReferenceSourceInfo xr, NameInfo ni, TypeDeclaration type, String newName) {
        Debug.assertNonnull(xr, ni, type, newName);
        Debug.assertNonnull(type.getName());
        if (!newName.equals(type.getName())) {
            int i;
            ArrayList<TypeReference> refs = new ArrayList<TypeReference>();
            refs.addAll(xr.getReferences(type));
            List<? extends Constructor> cons = type.getConstructors();
            ArrayType atype = ni.getArrayType(type);
            while (atype != null) {
                refs.addAll(xr.getReferences(atype));
                atype = ni.getArrayType(atype);
            }
            MiscKit.rename(ch, type, newName);
            if (cons != null) {
                for (i = cons.size() - 1; i >= 0; --i) {
                    Constructor con = cons.get(i);
                    if (!(con instanceof ConstructorDeclaration)) continue;
                    MiscKit.rename(ch, (ConstructorDeclaration)con, newName);
                }
            }
            if (refs != null) {
                for (i = refs.size() - 1; i >= 0; --i) {
                    MiscKit.rename(ch, (NamedProgramElement)refs.get(i), newName);
                }
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public static List<TypeReference> getInfluencedReferences(CrossReferenceSourceInfo xr, String newTypeName, NonTerminalProgramElement context) {
        Debug.assertNonnull(xr, newTypeName, context);
        context = MiscKit.getScopeDefiningElement(context);
        Type t = xr.getType(newTypeName, context);
        if (t == null) {
            return new ArrayList<TypeReference>(0);
        }
        List<TypeReference> list = xr.getReferences(t);
        if (list.isEmpty()) {
            return list;
        }
        ArrayList<TypeReference> result = new ArrayList<TypeReference>();
        for (int i = list.size() - 1; i >= 0; --i) {
            TypeReference tr = list.get(i);
            if (!MiscKit.contains(context, tr)) continue;
            result.add(tr);
        }
        return result;
    }

    public static List<TypeReference> getReferences(CrossReferenceSourceInfo xr, Type t, NonTerminalProgramElement root, boolean scanTree) {
        Debug.assertNonnull(xr, t, root);
        ArrayList<TypeReference> result = new ArrayList<TypeReference>();
        if (scanTree) {
            TreeWalker tw = new TreeWalker(root);
            while (tw.next(TypeReference.class)) {
                TypeReference tr = (TypeReference)tw.getProgramElement();
                if (xr.getType(tr) != t) continue;
                result.add(tr);
            }
        } else {
            List<TypeReference> refs = xr.getReferences(t);
            for (TypeReference tr : refs) {
                if (!MiscKit.contains(root, tr)) continue;
                result.add(tr);
            }
        }
        return result;
    }

    public static List<Member> getMembers(ClassTypeContainer ctc) {
        List<Member> mlist;
        ArrayList<Member> result = new ArrayList<Member>();
        if (ctc instanceof ClassType) {
            ClassType ct = (ClassType)ctc;
            mlist = ct.getConstructors();
            if (mlist != null) {
                result.addAll(mlist);
            }
            if ((mlist = ct.getFields()) != null) {
                result.addAll(mlist);
            }
            if ((mlist = ct.getMethods()) != null) {
                result.addAll(mlist);
            }
        }
        if ((mlist = ctc.getTypes()) != null) {
            result.addAll(mlist);
        }
        return result;
    }

    public static ClassType getSuperClass(NameInfo ni, ClassType ct) {
        if (!ct.isInterface()) {
            List<ClassType> ctl = ct.getSupertypes();
            for (ClassType classType : ctl) {
                ct = classType;
                if (ct.isInterface()) continue;
                return ct;
            }
        }
        return ni.getJavaLangObject();
    }

    public static boolean isLessVisible(Member x, Member y) {
        if (x.isPublic()) {
            return false;
        }
        if (y.isPublic()) {
            return true;
        }
        if (x.isProtected()) {
            return false;
        }
        if (y.isProtected()) {
            return true;
        }
        return x.isPrivate() && !y.isPrivate();
    }

    public static boolean isCovered(ProgramModelInfo pmi, List<? extends ClassType> x, List<? extends ClassType> y) {
        Debug.assertNonnull(x, y);
        boolean found = true;
        block0: for (int i = x.size() - 1; i >= 0 && found; --i) {
            ClassType ct = x.get(i);
            found = false;
            for (int j = y.size() - 1; j >= 0; --j) {
                if (!pmi.isSubtype(ct, y.get(j))) continue;
                found = true;
                continue block0;
            }
        }
        return found;
    }

    public static boolean isValidInterfaceMember(MemberDeclaration member) {
        if (!member.isPublic()) {
            return false;
        }
        if (member instanceof FieldDeclaration) {
            if (!member.isStatic() || !((FieldDeclaration)member).isFinal()) {
                return false;
            }
            List<FieldSpecification> vars = ((FieldDeclaration)member).getVariables();
            for (VariableSpecification variableSpecification : vars) {
                if (variableSpecification.getInitializer() != null) continue;
                return false;
            }
            return true;
        }
        if (member instanceof MethodDeclaration) {
            return !(member instanceof ConstructorDeclaration) && !member.isStatic() && ((MethodDeclaration)member).getBody() == null;
        }
        return member instanceof TypeDeclaration;
    }

    public static List<? extends ClassType> getCoveredSubtypes(ProgramModelInfo pmi, List<? extends ClassType> list) {
        ArrayList<ClassType> copy = new ArrayList<ClassType>();
        copy.addAll(list);
        return TypeKit.removeCoveredSubtypes(pmi, copy);
    }

    public static List<ClassType> removeCoveredSubtypes(ProgramModelInfo pmi, List<ClassType> list) {
        ArrayList<ClassType> removed = new ArrayList<ClassType>();
        block0: for (int i = list.size() - 1; i >= 0; --i) {
            ClassType ct = list.get(i);
            for (int j = list.size() - 1; j >= 0; --j) {
                ClassType ct2;
                if (j == i || !pmi.isSubtype(ct, ct2 = list.get(j))) continue;
                removed.add(ct);
                list.remove(i);
                continue block0;
            }
        }
        return removed;
    }

    public static List<TypeReference> getRedundantSuperInterfaces(SourceInfo si, TypeDeclaration td) {
        ClassType superclass = null;
        List<Object> superinterfaces = new ArrayList(0);
        if (td instanceof InterfaceDeclaration) {
            InterfaceDeclaration id = (InterfaceDeclaration)td;
            if (id.getExtendedTypes() != null) {
                superinterfaces = id.getExtendedTypes().getSupertypes();
            }
        } else {
            ClassDeclaration cd = (ClassDeclaration)td;
            if (cd.getImplementedTypes() != null) {
                superinterfaces = cd.getImplementedTypes().getSupertypes();
            }
            if (cd.getExtendedTypes() != null) {
                superclass = (ClassType)si.getType((TypeReference)cd.getExtendedTypes().getSupertypes().get(0));
            }
        }
        ArrayList<TypeReference> redundantReferences = new ArrayList<TypeReference>();
        ArrayList<ClassType> types = new ArrayList<ClassType>();
        for (TypeReference typeReference : superinterfaces) {
            types.add((ClassType)si.getType(typeReference));
        }
        block1: for (int i = superinterfaces.size() - 1; i >= 0; --i) {
            TypeReference typeReference = (TypeReference)superinterfaces.get(i);
            ClassType ct = (ClassType)types.get(i);
            if (superclass != null && si.isSubtype(superclass, ct)) {
                redundantReferences.add(typeReference);
                continue;
            }
            for (int j = superinterfaces.size() - 1; j >= 0; --j) {
                ClassType st;
                if (i == j || !si.isSubtype(st = (ClassType)types.get(j), ct)) continue;
                redundantReferences.add(typeReference);
                continue block1;
            }
        }
        return redundantReferences;
    }

    public static List<TypeReference> getRedundantExceptions(SourceInfo si, Throws t) {
        ASTList<TypeReference> exceptions = t.getExceptions();
        ArrayList<TypeReference> redundantReferences = new ArrayList<TypeReference>();
        ArrayList<ClassType> types = new ArrayList<ClassType>(exceptions.size());
        for (TypeReference exception : exceptions) {
            types.add((ClassType)si.getType(exception));
        }
        block1: for (int i = exceptions.size() - 1; i >= 0; --i) {
            ClassType ct = (ClassType)types.get(i);
            for (int j = exceptions.size() - 1; j >= 0; --j) {
                ClassType st;
                if (i == j || !si.isSubtype(ct, st = (ClassType)types.get(j))) continue;
                redundantReferences.add((TypeReference)exceptions.get(i));
                continue block1;
            }
        }
        return redundantReferences;
    }
}

