/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit;

import java.util.ArrayList;
import java.util.List;
import recoder.ProgramFactory;
import recoder.abstraction.ClassType;
import recoder.abstraction.Package;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.reference.PackageReference;
import recoder.kit.MiscKit;
import recoder.service.ChangeHistory;
import recoder.service.CrossReferenceSourceInfo;
import recoder.util.Debug;

public class PackageKit {
    private PackageKit() {
    }

    public static PackageReference createPackageReference(ProgramFactory f, Package p) {
        int i;
        PackageReference result = null;
        String name = p.getFullName();
        if (name.equals("")) {
            return null;
        }
        int j = -1;
        do {
            String token = (j = name.indexOf(".", i = j + 1)) > i ? name.substring(i, j) : name.substring(i);
            result = f.createPackageReference(result, f.createIdentifier(token));
        } while (j > i);
        return result;
    }

    public static List<ClassType> getNonSourcePackageTypes(Package pkg) {
        ArrayList<ClassType> result = new ArrayList<ClassType>();
        List<? extends ClassType> classes = pkg.getTypes();
        for (int i = classes.size() - 1; i >= 0; --i) {
            ClassType ct = classes.get(i);
            if (ct instanceof TypeDeclaration) continue;
            result.add(ct);
        }
        return result;
    }

    @Deprecated
    public static boolean rename(ChangeHistory ch, CrossReferenceSourceInfo xr, Package pkg, String newName) {
        Debug.assertNonnull(xr, pkg, newName);
        Debug.assertNonnull(pkg.getName());
        if (!newName.equals(pkg.getName())) {
            List<PackageReference> refs = xr.getReferences(pkg);
            for (int i = refs.size() - 1; i >= 0; --i) {
                MiscKit.rename(ch, refs.get(i), newName);
            }
            return true;
        }
        return false;
    }
}

