/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit;

import java.util.List;
import recoder.ProgramFactory;
import recoder.abstraction.PrimitiveType;
import recoder.abstraction.Type;
import recoder.java.Expression;
import recoder.java.ExpressionContainer;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.ScopeDefiningElement;
import recoder.java.Statement;
import recoder.java.StatementBlock;
import recoder.java.StatementContainer;
import recoder.java.declaration.ClassInitializer;
import recoder.java.declaration.FieldDeclaration;
import recoder.java.declaration.FieldSpecification;
import recoder.java.declaration.LocalVariableDeclaration;
import recoder.java.declaration.MemberDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.expression.Assignment;
import recoder.java.expression.Literal;
import recoder.java.expression.Operator;
import recoder.java.expression.ParenthesizedExpression;
import recoder.java.expression.operator.CopyAssignment;
import recoder.java.reference.ArrayReference;
import recoder.java.reference.ConstructorReference;
import recoder.java.reference.MethodReference;
import recoder.java.reference.ReferencePrefix;
import recoder.java.reference.ReferenceSuffix;
import recoder.java.reference.TypeReference;
import recoder.java.reference.VariableReference;
import recoder.kit.MiscKit;
import recoder.kit.StatementKit;
import recoder.kit.TypeKit;
import recoder.kit.VariableKit;
import recoder.list.generic.ASTArrayList;
import recoder.list.generic.ASTList;
import recoder.service.ChangeHistory;
import recoder.service.NameInfo;
import recoder.service.SourceInfo;
import recoder.util.Debug;

public class ExpressionKit {
    private ExpressionKit() {
    }

    public static boolean containsStatements(Expression expr) {
        if (expr instanceof Statement && !(expr instanceof ParenthesizedExpression)) {
            return true;
        }
        if (expr instanceof ExpressionContainer) {
            ExpressionContainer con = (ExpressionContainer)((Object)expr);
            int s = con.getExpressionCount();
            for (int i = 0; i < s; ++i) {
                if (!ExpressionKit.containsStatements(con.getExpressionAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isLValue(Expression r) {
        if (r instanceof VariableReference || r instanceof ArrayReference) {
            ExpressionContainer c = r.getExpressionContainer();
            return c instanceof Assignment && c.getExpressionAt(0) == r;
        }
        return false;
    }

    public static List<Expression> collectPreceedingExpressions(Expression x) {
        ReferencePrefix rp;
        Debug.assertNonnull(x);
        ASTArrayList<Expression> dest = new ASTArrayList<Expression>();
        if (x instanceof MethodReference || x instanceof ConstructorReference) {
            ExpressionContainer ec = (ExpressionContainer)((Object)x);
            int s = ec.getExpressionCount();
            for (int i = 0; i < s; ++i) {
                dest.add(ec.getExpressionAt(i));
            }
        } else if (x instanceof ReferenceSuffix && (rp = ((ReferenceSuffix)((Object)x)).getReferencePrefix()) instanceof Expression) {
            dest.add((Expression)((Object)rp));
        }
        ExpressionContainer parent;
        while ((parent = x.getExpressionContainer()) != null) {
            Expression expr;
            int i;
            boolean leftAssociative = parent instanceof Operator ? ((Operator)parent).isLeftAssociative() : true;
            if (leftAssociative) {
                i = 0;
                if (parent instanceof ReferenceSuffix && ((ReferenceSuffix)((Object)parent)).getReferencePrefix() instanceof Expression) {
                    i = 1;
                }
                while ((expr = parent.getExpressionAt(i)) != x) {
                    dest.add(expr);
                    ++i;
                }
            } else {
                i = parent.getExpressionCount() - 1;
                while ((expr = parent.getExpressionAt(i)) != x) {
                    dest.add(expr);
                    --i;
                }
            }
            if (!(parent instanceof Expression)) {
                return dest;
            }
            x = (Expression)((Object)parent);
        }
        return dest;
    }

    @Deprecated
    public static boolean shiftPreceedingStatementExpressions(SourceInfo si, Expression x, ChangeHistory ch) {
        List<Expression> exprs = ExpressionKit.collectPreceedingExpressions(x);
        for (int i = exprs.size() - 1; i >= 0; --i) {
            if (ExpressionKit.containsStatements(exprs.get(i))) continue;
            exprs.remove(i);
        }
        if (exprs.isEmpty()) {
            return false;
        }
        ProgramFactory f = x.getFactory();
        int exSize = exprs.size();
        ASTArrayList<int> tempVarDecls = new ASTArrayList<int>(exSize);
        ScopeDefiningElement sde = MiscKit.getScopeDefiningElement(x);
        Type[] exTypes = new Type[exSize];
        for (int i = 0; i < exSize; ++i) {
            Expression ex = exprs.get(i);
            exTypes[i] = si.getType(ex);
        }
        String[] varNames = VariableKit.getNewVariableNames(si, exTypes, sde);
        for (int i = 0; i < exSize; ++i) {
            Expression ex = exprs.get(i);
            Type t = exTypes[i];
            TypeReference minTypeRef = TypeKit.createTypeReference(si, t, sde);
            String varName = varNames[i];
            LocalVariableDeclaration localVariableDeclaration = f.createLocalVariableDeclaration(minTypeRef, f.createIdentifier(varName));
            localVariableDeclaration.getVariables().get(0).setInitializer(ex);
            tempVarDecls.add((int)localVariableDeclaration);
            VariableReference vref = f.createVariableReference(f.createIdentifier(varName));
            ex.getASTParent().replaceChild(ex, vref);
            Debug.assertNonnull(vref.getASTParent());
            if (ch == null) continue;
            ch.replaced(ex, vref);
        }
        ASTList<Statement> destination = null;
        StatementContainer destParent = null;
        int destIndex = 0;
        ProgramElement pe = x;
        while (true) {
            NonTerminalProgramElement parent = pe.getASTParent();
            Debug.assertNonnull(parent);
            if (parent instanceof Statement && ((Statement)((Object)parent)).getStatementContainer() != null) {
                Statement statement = (Statement)((Object)parent);
                destination = StatementKit.prepareStatementMutableList(statement, ch);
                destParent = statement.getStatementContainer();
                destIndex = 0;
                while (destination.get(destIndex) != parent) {
                    ++destIndex;
                }
                break;
            }
            if (parent instanceof FieldSpecification) {
                FieldSpecification fieldSpecification = (FieldSpecification)parent;
                FieldDeclaration fd = (FieldDeclaration)fieldSpecification.getParent();
                destination = new ASTArrayList<Statement>();
                StatementBlock body = f.createStatementBlock(destination);
                ClassInitializer ci = fd.isStatic() ? f.createClassInitializer(f.createStatic(), body) : f.createClassInitializer(body);
                destParent = ci;
                TypeDeclaration tdecl = fd.getMemberParent();
                ASTList<MemberDeclaration> mdml = tdecl.getMembers();
                mdml.add(mdml.indexOf(fd) + 1, ci);
                ci.setMemberParent(tdecl);
                if (ch != null) {
                    ch.attached(ci);
                }
                Expression init = fieldSpecification.getInitializer();
                int initIndex = fieldSpecification.getChildPositionCode(init);
                fieldSpecification.setInitializer(null);
                if (ch != null) {
                    ch.detached(init, initIndex);
                }
                CopyAssignment ca = f.createCopyAssignment(f.createVariableReference(f.createIdentifier(fieldSpecification.getName())), init);
                ca.makeAllParentRolesValid();
                destination.add(ca);
                destIndex = 0;
                break;
            }
            pe = parent;
        }
        destination.addAll(destIndex, tempVarDecls);
        destParent.makeAllParentRolesValid();
        if (ch != null) {
            for (Statement statement : tempVarDecls) {
                ch.attached(statement);
            }
        }
        return true;
    }

    public static Literal createDefaultValue(ProgramFactory f, NameInfo ni, Type t) {
        Debug.assertNonnull(f, ni, t);
        if (t instanceof PrimitiveType) {
            if (t == ni.getIntType()) {
                return f.createIntLiteral(0);
            }
            if (t == ni.getBooleanType()) {
                return f.createBooleanLiteral(false);
            }
            if (t == ni.getCharType()) {
                return f.createCharLiteral('\u0000');
            }
            if (t == ni.getShortType()) {
                return f.createIntLiteral(0);
            }
            if (t == ni.getByteType()) {
                return f.createIntLiteral(0);
            }
            if (t == ni.getLongType()) {
                return f.createLongLiteral(0L);
            }
            if (t == ni.getFloatType()) {
                return f.createFloatLiteral(0.0f);
            }
            if (t == ni.getDoubleType()) {
                return f.createDoubleLiteral(0.0);
            }
            throw new IllegalArgumentException("Unknown primitive type " + t.getName());
        }
        return f.createNullLiteral();
    }
}

