/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.reference;

import recoder.java.Expression;
import recoder.java.ExpressionContainer;
import recoder.java.Identifier;
import recoder.java.Import;
import recoder.java.JavaNonTerminalProgramElement;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.Reference;
import recoder.java.SourceElement;
import recoder.java.SourceVisitor;
import recoder.java.declaration.TypeArgumentDeclaration;
import recoder.java.reference.ArrayLengthReference;
import recoder.java.reference.FieldReference;
import recoder.java.reference.PackageReference;
import recoder.java.reference.PackageReferenceContainer;
import recoder.java.reference.ReferencePrefix;
import recoder.java.reference.ReferenceSuffix;
import recoder.java.reference.TypeReference;
import recoder.java.reference.TypeReferenceContainer;
import recoder.java.reference.TypeReferenceInfix;
import recoder.java.reference.VariableReference;
import recoder.list.generic.ASTList;

public class UncollatedReferenceQualifier
extends JavaNonTerminalProgramElement
implements TypeReferenceInfix,
ExpressionContainer,
TypeReferenceContainer,
PackageReferenceContainer,
Reference,
Expression {
    private static final long serialVersionUID = -1896030875000030810L;
    protected NonTerminalProgramElement parent;
    protected ReferenceSuffix suffix;
    protected ReferencePrefix prefix;
    protected ASTList<TypeArgumentDeclaration> typeArguments;
    protected Identifier name;

    public UncollatedReferenceQualifier() {
    }

    public UncollatedReferenceQualifier(Identifier id) {
        this.setIdentifier(id);
        this.makeParentRoleValid();
    }

    public UncollatedReferenceQualifier(ReferencePrefix prefix, Identifier id) {
        this.setIdentifier(id);
        this.setReferencePrefix(prefix);
        this.makeParentRoleValid();
    }

    protected UncollatedReferenceQualifier(UncollatedReferenceQualifier proto) {
        super(proto);
        if (proto.prefix != null) {
            this.prefix = (ReferencePrefix)proto.prefix.deepClone();
        }
        if (proto.name != null) {
            this.name = proto.name.deepClone();
        }
        if (proto.typeArguments != null) {
            this.typeArguments = proto.typeArguments.deepClone();
        }
        this.makeParentRoleValid();
    }

    @Override
    public UncollatedReferenceQualifier deepClone() {
        return new UncollatedReferenceQualifier(this);
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.prefix != null) {
            this.prefix.setReferenceSuffix(this);
        }
        if (this.name != null) {
            this.name.setParent(this);
        }
        if (this.typeArguments != null) {
            for (TypeArgumentDeclaration ta : this.typeArguments) {
                ta.setParent(this);
            }
        }
    }

    @Override
    public SourceElement getFirstElement() {
        return this.prefix == null ? this.name : this.prefix.getFirstElement();
    }

    @Override
    public NonTerminalProgramElement getASTParent() {
        return this.parent != null ? this.parent : this.suffix;
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        int idx;
        if (p == null) {
            throw new NullPointerException();
        }
        if (this.prefix == p) {
            ReferencePrefix r;
            this.prefix = r = (ReferencePrefix)q;
            if (r != null) {
                r.setReferenceSuffix(this);
            }
            return true;
        }
        if (this.name == p) {
            Identifier r;
            this.name = r = (Identifier)q;
            if (r != null) {
                r.setParent(this);
            }
            return true;
        }
        if (this.typeArguments != null && (idx = this.typeArguments.indexOf(p)) != -1) {
            if (q == null) {
                this.typeArguments.remove(idx);
            } else {
                this.typeArguments.set(idx, (TypeArgumentDeclaration)q);
                ((TypeArgumentDeclaration)q).setParent(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public ExpressionContainer getExpressionContainer() {
        if (this.parent instanceof ExpressionContainer) {
            return (ExpressionContainer)this.parent;
        }
        return null;
    }

    @Override
    public void setExpressionContainer(ExpressionContainer c) {
        this.parent = c;
        this.suffix = null;
    }

    @Override
    public int getChildCount() {
        int result = 0;
        if (this.prefix != null) {
            ++result;
        }
        if (this.name != null) {
            ++result;
        }
        if (this.typeArguments != null) {
            result += this.typeArguments.size();
        }
        return result;
    }

    @Override
    public ProgramElement getChildAt(int index) {
        if (this.prefix != null) {
            if (index == 0) {
                return this.prefix;
            }
            --index;
        }
        if (this.name != null) {
            if (index == 0) {
                return this.name;
            }
            --index;
        }
        if (this.typeArguments != null) {
            return (ProgramElement)this.typeArguments.get(index);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        int idx;
        if (this.prefix == child) {
            return 0;
        }
        if (this.name == child) {
            return 1;
        }
        if (this.typeArguments != null && (idx = this.typeArguments.indexOf(child)) != -1) {
            return idx << 4 | 2;
        }
        return -1;
    }

    @Override
    public int getTypeReferenceCount() {
        return this.prefix instanceof TypeReference ? 1 : 0;
    }

    @Override
    public TypeReference getTypeReferenceAt(int index) {
        if (this.prefix instanceof TypeReference && index == 0) {
            return (TypeReference)this.prefix;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public PackageReference getPackageReference() {
        return this.prefix instanceof PackageReference ? (PackageReference)this.prefix : null;
    }

    @Override
    public int getExpressionCount() {
        return this.prefix instanceof Expression ? 1 : 0;
    }

    @Override
    public Expression getExpressionAt(int index) {
        if (this.prefix instanceof Expression && index == 0) {
            return (Expression)((Object)this.prefix);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public ReferencePrefix getReferencePrefix() {
        return this.prefix;
    }

    @Override
    public void setReferencePrefix(ReferencePrefix prefix) {
        this.prefix = prefix;
    }

    @Override
    public ReferenceSuffix getReferenceSuffix() {
        return this.suffix;
    }

    @Override
    public void setReferenceSuffix(ReferenceSuffix x) {
        this.suffix = x;
        this.parent = null;
    }

    public void setParent(Import imp) {
        this.parent = imp;
        this.suffix = null;
    }

    @Override
    public final String getName() {
        return this.name == null ? null : this.name.getText();
    }

    @Override
    public Identifier getIdentifier() {
        return this.name;
    }

    @Override
    public void setIdentifier(Identifier id) {
        this.name = id;
    }

    private void copySourceInfos(Reference ref) {
        ref.setRelativePosition(this.getRelativePosition());
        ref.setStartPosition(this.getStartPosition());
        ref.setEndPosition(this.getEndPosition());
        ref.setComments(this.comments);
    }

    public ArrayLengthReference toArrayLengthReference() {
        ArrayLengthReference ref = this.getFactory().createArrayLengthReference();
        ref.setExpressionContainer(this.getExpressionContainer());
        ref.setReferencePrefix(this.prefix);
        this.copySourceInfos(ref);
        ref.makeParentRoleValid();
        return ref;
    }

    public VariableReference toVariableReference() {
        VariableReference ref = this.getFactory().createVariableReference();
        ref.setExpressionContainer(this.getExpressionContainer());
        ref.setReferenceSuffix(this.getReferenceSuffix());
        ref.setIdentifier(this.name);
        this.copySourceInfos(ref);
        ref.makeParentRoleValid();
        return ref;
    }

    public VariableReference toFieldReference() {
        FieldReference ref = this.getFactory().createFieldReference();
        ref.setExpressionContainer(this.getExpressionContainer());
        ref.setReferenceSuffix(this.getReferenceSuffix());
        ref.setReferencePrefix(this.prefix);
        ref.setIdentifier(this.name);
        this.copySourceInfos(ref);
        ref.makeParentRoleValid();
        return ref;
    }

    public TypeReference toTypeReference() {
        TypeReference ref = this.getFactory().createTypeReference();
        ref.setReferenceSuffix(this.getReferenceSuffix());
        ref.setReferencePrefix(this.prefix);
        ref.setIdentifier(this.name);
        ref.setTypeArguments(this.typeArguments);
        ref.makeParentRoleValid();
        this.copySourceInfos(ref);
        ref.makeParentRoleValid();
        return ref;
    }

    public PackageReference toPackageReference() {
        if (this.prefix instanceof UncollatedReferenceQualifier) {
            this.prefix = ((UncollatedReferenceQualifier)this.prefix).toPackageReference();
        }
        PackageReference ref = this.getFactory().createPackageReference();
        ref.setReferenceSuffix(this.getReferenceSuffix());
        ref.setReferencePrefix(this.prefix);
        ref.setIdentifier(this.name);
        this.copySourceInfos(ref);
        ref.makeParentRoleValid();
        return ref;
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitUncollatedReferenceQualifier(this);
    }

    public ASTList<TypeArgumentDeclaration> getTypeArguments() {
        return this.typeArguments;
    }

    public void setTypeArguments(ASTList<TypeArgumentDeclaration> ta) {
        this.typeArguments = ta;
    }
}

