/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.reference;

import recoder.java.Expression;
import recoder.java.Identifier;
import recoder.java.JavaNonTerminalProgramElement;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.SourceElement;
import recoder.java.SourceVisitor;
import recoder.java.declaration.TypeArgumentDeclaration;
import recoder.java.reference.MemberReference;
import recoder.java.reference.PackageReference;
import recoder.java.reference.PackageReferenceContainer;
import recoder.java.reference.ReferencePrefix;
import recoder.java.reference.ReferenceSuffix;
import recoder.java.reference.TypeReferenceContainer;
import recoder.java.reference.TypeReferenceInfix;
import recoder.list.generic.ASTList;

public class TypeReference
extends JavaNonTerminalProgramElement
implements TypeReferenceInfix,
TypeReferenceContainer,
PackageReferenceContainer,
MemberReference {
    private static final long serialVersionUID = -8415845940952618808L;
    protected TypeReferenceContainer parent;
    protected ReferencePrefix prefix;
    protected int dimensions;
    protected ASTList<TypeArgumentDeclaration> typeArguments;
    protected Identifier name;

    public TypeReference() {
    }

    public TypeReference(Identifier name) {
        this.setIdentifier(name);
        this.makeParentRoleValid();
    }

    public TypeReference(ReferencePrefix prefix, Identifier name) {
        this.setIdentifier(name);
        this.setReferencePrefix(prefix);
        this.makeParentRoleValid();
    }

    public TypeReference(Identifier name, int dim) {
        this.setIdentifier(name);
        this.setDimensions(dim);
        this.makeParentRoleValid();
    }

    public TypeReference(Identifier name, ASTList<TypeArgumentDeclaration> typeArgs) {
        this.setIdentifier(name);
        this.typeArguments = typeArgs;
        this.makeParentRoleValid();
    }

    protected TypeReference(TypeReference proto) {
        super(proto);
        if (proto.prefix != null) {
            this.prefix = (ReferencePrefix)proto.prefix.deepClone();
        }
        if (proto.name != null) {
            this.name = proto.name.deepClone();
        }
        if (proto.typeArguments != null) {
            this.typeArguments = proto.typeArguments.deepClone();
        }
        this.dimensions = proto.dimensions;
        this.makeParentRoleValid();
    }

    @Override
    public TypeReference deepClone() {
        return new TypeReference(this);
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.prefix != null) {
            this.prefix.setReferenceSuffix(this);
        }
        if (this.name != null) {
            this.name.setParent(this);
        }
        if (this.typeArguments != null) {
            for (TypeArgumentDeclaration ta : this.typeArguments) {
                ta.setParent(this);
            }
        }
    }

    @Override
    public SourceElement getFirstElement() {
        return this.prefix == null ? this.name : this.prefix.getFirstElement();
    }

    @Override
    public NonTerminalProgramElement getASTParent() {
        return this.parent;
    }

    @Override
    public int getChildCount() {
        int result = 0;
        if (this.prefix != null) {
            ++result;
        }
        if (this.name != null) {
            ++result;
        }
        if (this.typeArguments != null) {
            result += this.typeArguments.size();
        }
        return result;
    }

    @Override
    public ProgramElement getChildAt(int index) {
        if (this.prefix != null) {
            if (index == 0) {
                return this.prefix;
            }
            --index;
        }
        if (this.name != null) {
            if (index == 0) {
                return this.name;
            }
            --index;
        }
        if (this.typeArguments != null) {
            return (ProgramElement)this.typeArguments.get(index);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        int idx;
        if (this.prefix == child) {
            return 0;
        }
        if (this.name == child) {
            return 1;
        }
        if (this.typeArguments != null && (idx = this.typeArguments.indexOf(child)) != -1) {
            return idx << 4 | 2;
        }
        return -1;
    }

    @Override
    public int getTypeReferenceCount() {
        return this.prefix instanceof TypeReference ? 1 : 0;
    }

    @Override
    public TypeReference getTypeReferenceAt(int index) {
        if (this.prefix instanceof TypeReference && index == 0) {
            return (TypeReference)this.prefix;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getExpressionCount() {
        return this.prefix instanceof Expression ? 1 : 0;
    }

    @Override
    public Expression getExpressionAt(int index) {
        if (this.prefix instanceof Expression && index == 0) {
            return (Expression)((Object)this.prefix);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        int idx;
        if (p == null) {
            throw new NullPointerException();
        }
        if (this.prefix == p) {
            ReferencePrefix r;
            this.prefix = r = (ReferencePrefix)q;
            if (r != null) {
                r.setReferenceSuffix(this);
            }
            return true;
        }
        if (this.name == p) {
            Identifier r;
            this.name = r = (Identifier)q;
            if (r != null) {
                r.setParent(this);
            }
            return true;
        }
        if (this.typeArguments != null && (idx = this.typeArguments.indexOf(p)) != -1) {
            if (q == null) {
                this.typeArguments.remove(idx);
            } else {
                this.typeArguments.set(idx, (TypeArgumentDeclaration)q);
                ((TypeArgumentDeclaration)q).setParent(this);
            }
            return true;
        }
        return false;
    }

    public TypeReferenceContainer getParent() {
        return this.parent;
    }

    public void setParent(TypeReferenceContainer elem) {
        this.parent = elem;
    }

    @Override
    public ReferencePrefix getReferencePrefix() {
        return this.prefix;
    }

    @Override
    public void setReferencePrefix(ReferencePrefix x) {
        this.prefix = x;
    }

    @Override
    public PackageReference getPackageReference() {
        return this.prefix instanceof PackageReference ? (PackageReference)this.prefix : null;
    }

    @Override
    public ReferenceSuffix getReferenceSuffix() {
        return this.parent instanceof ReferenceSuffix ? (ReferenceSuffix)((Object)this.parent) : null;
    }

    @Override
    public void setReferenceSuffix(ReferenceSuffix x) {
        this.parent = (TypeReferenceContainer)((Object)x);
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(int dim) {
        this.dimensions = dim;
    }

    @Override
    public final String getName() {
        return this.name == null ? null : this.name.getText();
    }

    @Override
    public Identifier getIdentifier() {
        return this.name;
    }

    @Override
    public void setIdentifier(Identifier id) {
        this.name = id;
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitTypeReference(this);
    }

    public ASTList<TypeArgumentDeclaration> getTypeArguments() {
        return this.typeArguments;
    }

    public void setTypeArguments(ASTList<TypeArgumentDeclaration> ta) {
        this.typeArguments = ta;
    }
}

