/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.reference;

import recoder.java.Expression;
import recoder.java.JavaNonTerminalProgramElement;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.StatementContainer;
import recoder.java.reference.ConstructorReference;
import recoder.list.generic.ASTList;

public abstract class SpecialConstructorReference
extends JavaNonTerminalProgramElement
implements ConstructorReference {
    protected StatementContainer parent;
    protected ASTList<Expression> arguments;

    public SpecialConstructorReference() {
    }

    public SpecialConstructorReference(ASTList<Expression> arguments) {
        this.setArguments(arguments);
    }

    protected SpecialConstructorReference(SpecialConstructorReference proto) {
        super(proto);
        if (proto.arguments != null) {
            this.arguments = proto.arguments.deepClone();
        }
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.arguments != null) {
            for (int i = this.arguments.size() - 1; i >= 0; --i) {
                ((Expression)this.arguments.get(i)).setExpressionContainer(this);
            }
        }
    }

    @Override
    public NonTerminalProgramElement getASTParent() {
        return this.parent;
    }

    @Override
    public StatementContainer getStatementContainer() {
        return this.parent;
    }

    @Override
    public void setStatementContainer(StatementContainer s) {
        this.parent = s;
    }

    @Override
    public int getChildCount() {
        return this.arguments != null ? this.arguments.size() : 0;
    }

    @Override
    public ProgramElement getChildAt(int index) {
        if (this.arguments != null) {
            return (ProgramElement)this.arguments.get(index);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getExpressionCount() {
        return this.arguments != null ? this.arguments.size() : 0;
    }

    @Override
    public Expression getExpressionAt(int index) {
        if (this.arguments != null) {
            return (Expression)this.arguments.get(index);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        if (p == null) {
            throw new NullPointerException();
        }
        int count = this.arguments == null ? 0 : this.arguments.size();
        for (int i = 0; i < count; ++i) {
            if (this.arguments.get(i) != p) continue;
            if (q == null) {
                this.arguments.remove(i);
            } else {
                Expression r = (Expression)q;
                this.arguments.set(i, r);
                r.setExpressionContainer(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public ASTList<Expression> getArguments() {
        return this.arguments;
    }

    @Override
    public void setArguments(ASTList<Expression> list) {
        this.arguments = list;
    }
}

