/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.expression.operator;

import recoder.java.Expression;
import recoder.java.ProgramElement;
import recoder.java.expression.Operator;
import recoder.java.reference.TypeReference;
import recoder.java.reference.TypeReferenceContainer;

public abstract class TypeOperator
extends Operator
implements TypeReferenceContainer {
    protected TypeReference typeReference;

    public TypeOperator() {
    }

    public TypeOperator(Expression unaryChild, TypeReference typeref) {
        super(unaryChild);
        this.setTypeReference(typeref);
    }

    public TypeOperator(Expression lhs, Expression rhs, TypeReference typeref) {
        super(lhs, rhs);
        this.setTypeReference(typeref);
    }

    protected TypeOperator(TypeOperator proto) {
        super(proto);
        if (proto.typeReference != null) {
            this.typeReference = proto.typeReference.deepClone();
        }
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.typeReference != null) {
            this.typeReference.setParent(this);
        }
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        int index;
        if (this.children != null && (index = this.children.indexOf(child)) >= 0) {
            return index << 4 | 0;
        }
        if (this.typeReference == child) {
            return 1;
        }
        return -1;
    }

    @Override
    public int getTypeReferenceCount() {
        return this.typeReference != null ? 1 : 0;
    }

    @Override
    public TypeReference getTypeReferenceAt(int index) {
        if (this.typeReference != null && index == 0) {
            return this.typeReference;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        if (p == null) {
            throw new NullPointerException();
        }
        int count = this.children == null ? 0 : this.children.size();
        for (int i = 0; i < count; ++i) {
            if (this.children.get(i) != p) continue;
            if (q == null) {
                this.children.remove(i);
            } else {
                Expression r = (Expression)q;
                this.children.set(i, r);
                r.setExpressionContainer(this);
            }
            return true;
        }
        if (this.typeReference == p) {
            TypeReference r;
            this.typeReference = r = (TypeReference)q;
            if (r != null) {
                r.setParent(this);
            }
            return true;
        }
        return false;
    }

    public TypeReference getTypeReference() {
        return this.typeReference;
    }

    public void setTypeReference(TypeReference t) {
        this.typeReference = t;
    }
}

