/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.expression.operator;

import recoder.java.Expression;
import recoder.java.ExpressionContainer;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.SourceElement;
import recoder.java.SourceVisitor;
import recoder.java.StatementContainer;
import recoder.java.declaration.ClassDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.declaration.TypeDeclarationContainer;
import recoder.java.expression.ExpressionStatement;
import recoder.java.expression.operator.TypeOperator;
import recoder.java.reference.ConstructorReference;
import recoder.java.reference.ReferencePrefix;
import recoder.java.reference.ReferenceSuffix;
import recoder.java.reference.TypeReference;
import recoder.list.generic.ASTList;

public class New
extends TypeOperator
implements ConstructorReference,
ExpressionStatement,
ReferencePrefix,
ReferenceSuffix,
TypeDeclarationContainer {
    private static final long serialVersionUID = -4983184360698832328L;
    protected ClassDeclaration anonymousClass;
    protected ReferencePrefix accessPath;
    protected ReferenceSuffix referenceParent;
    protected StatementContainer statementParent;

    public New() {
    }

    public New(ReferencePrefix accessPath, TypeReference constructorName, ASTList<Expression> arguments) {
        this.setReferencePrefix(accessPath);
        this.setTypeReference(constructorName);
        this.setArguments(arguments);
        this.makeParentRoleValid();
    }

    public New(ReferencePrefix accessPath, TypeReference constructorName, ASTList<Expression> arguments, ClassDeclaration anonymousClass) {
        this(accessPath, constructorName, arguments);
        this.setClassDeclaration(anonymousClass);
        this.makeParentRoleValid();
    }

    protected New(New proto) {
        super(proto);
        if (proto.anonymousClass != null) {
            this.anonymousClass = proto.anonymousClass.deepClone();
        }
        if (proto.accessPath != null) {
            this.accessPath = (ReferencePrefix)proto.accessPath.deepClone();
        }
        this.makeParentRoleValid();
    }

    @Override
    public New deepClone() {
        return new New(this);
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.children != null) {
            for (int i = this.children.size() - 1; i >= 0; --i) {
                ((Expression)this.children.get(i)).setExpressionContainer(this);
            }
        }
        if (this.accessPath != null) {
            this.accessPath.setReferenceSuffix(this);
        }
        if (this.anonymousClass != null) {
            this.anonymousClass.setParent(this);
        }
    }

    @Override
    public SourceElement getFirstElement() {
        return this.accessPath != null ? this.accessPath.getFirstElement() : this;
    }

    @Override
    public SourceElement getLastElement() {
        return this.getChildAt(this.getChildCount() - 1).getLastElement();
    }

    @Override
    public NonTerminalProgramElement getASTParent() {
        if (this.statementParent != null) {
            return this.statementParent;
        }
        if (this.expressionParent != null) {
            return this.expressionParent;
        }
        return this.referenceParent;
    }

    @Override
    public int getArity() {
        return 0;
    }

    @Override
    public int getPrecedence() {
        return 0;
    }

    @Override
    public int getNotation() {
        return 0;
    }

    @Override
    public StatementContainer getStatementContainer() {
        return this.statementParent;
    }

    @Override
    public void setStatementContainer(StatementContainer parent) {
        this.statementParent = parent;
    }

    @Override
    public ExpressionContainer getExpressionContainer() {
        return this.expressionParent;
    }

    @Override
    public void setExpressionContainer(ExpressionContainer parent) {
        this.expressionParent = parent;
    }

    public ClassDeclaration getClassDeclaration() {
        return this.anonymousClass;
    }

    public void setClassDeclaration(ClassDeclaration decl) {
        this.anonymousClass = decl;
    }

    @Override
    public int getTypeDeclarationCount() {
        return this.anonymousClass != null ? 1 : 0;
    }

    @Override
    public TypeDeclaration getTypeDeclarationAt(int index) {
        if (this.anonymousClass != null && index == 0) {
            return this.anonymousClass;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildCount() {
        int result = 0;
        if (this.accessPath != null) {
            ++result;
        }
        if (this.typeReference != null) {
            ++result;
        }
        if (this.children != null) {
            result += this.children.size();
        }
        if (this.anonymousClass != null) {
            ++result;
        }
        return result;
    }

    @Override
    public ProgramElement getChildAt(int index) {
        if (this.accessPath != null) {
            if (index == 0) {
                return this.accessPath;
            }
            --index;
        }
        if (this.typeReference != null) {
            if (index == 0) {
                return this.typeReference;
            }
            --index;
        }
        if (this.children != null) {
            int len = this.children.size();
            if (len > index) {
                return (ProgramElement)this.children.get(index);
            }
            index -= len;
        }
        if (this.anonymousClass != null) {
            if (index == 0) {
                return this.anonymousClass;
            }
            --index;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        int index;
        if (this.children != null && (index = this.children.indexOf(child)) >= 0) {
            return index << 4 | 0;
        }
        if (this.typeReference == child) {
            return 1;
        }
        if (this.accessPath == child) {
            return 2;
        }
        if (this.anonymousClass == child) {
            return 3;
        }
        return -1;
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        if (p == null) {
            throw new NullPointerException();
        }
        int count = this.children == null ? 0 : this.children.size();
        for (int i = 0; i < count; ++i) {
            if (this.children.get(i) != p) continue;
            if (q == null) {
                this.children.remove(i);
            } else {
                Expression r = (Expression)q;
                this.children.set(i, r);
                r.setExpressionContainer(this);
            }
            return true;
        }
        if (this.typeReference == p) {
            TypeReference r;
            this.typeReference = r = (TypeReference)q;
            if (r != null) {
                r.setParent(this);
            }
            return true;
        }
        if (this.accessPath == p) {
            ReferencePrefix r;
            this.accessPath = r = (ReferencePrefix)q;
            if (r != null) {
                r.setReferenceSuffix(this);
            }
            return true;
        }
        if (this.anonymousClass == p) {
            ClassDeclaration r;
            this.anonymousClass = r = (ClassDeclaration)q;
            if (r != null) {
                r.setParent(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public ReferencePrefix getReferencePrefix() {
        return this.accessPath;
    }

    public void setReferencePrefix(ReferencePrefix x) {
        this.accessPath = x;
    }

    @Override
    public ReferenceSuffix getReferenceSuffix() {
        return this.referenceParent;
    }

    @Override
    public void setReferenceSuffix(ReferenceSuffix path) {
        this.referenceParent = path;
    }

    @Override
    public ASTList<Expression> getArguments() {
        return this.children;
    }

    @Override
    public void setArguments(ASTList<Expression> list) {
        this.children = list;
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitNew(this);
    }
}

