/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.expression.literal;

import recoder.java.NonTerminalProgramElement;
import recoder.java.SourceVisitor;
import recoder.java.expression.Literal;
import recoder.java.reference.ReferencePrefix;
import recoder.java.reference.ReferenceSuffix;

public class StringLiteral
extends Literal
implements ReferencePrefix {
    private static final long serialVersionUID = 7368137274068211543L;
    protected ReferenceSuffix referenceParent;
    protected String value;

    public StringLiteral() {
        this.setValue("");
    }

    public StringLiteral(String value) {
        this.setValue(value);
    }

    protected StringLiteral(StringLiteral proto) {
        super(proto);
        this.value = proto.value;
    }

    @Override
    public StringLiteral deepClone() {
        return new StringLiteral(this);
    }

    @Override
    public NonTerminalProgramElement getASTParent() {
        if (this.expressionParent != null) {
            return this.expressionParent;
        }
        return this.referenceParent;
    }

    @Override
    public ReferenceSuffix getReferenceSuffix() {
        return this.referenceParent;
    }

    @Override
    public void setReferenceSuffix(ReferenceSuffix path) {
        this.referenceParent = path;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String str) {
        if (!str.startsWith("\"") || !str.endsWith("\"")) {
            throw new IllegalArgumentException("Bad string literal " + this.value);
        }
        this.value = str.intern();
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitStringLiteral(this);
    }

    @Override
    public Object getEquivalentJavaType() {
        return this.value;
    }
}

