/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.declaration;

import recoder.abstraction.Type;
import recoder.abstraction.Variable;
import recoder.java.Declaration;
import recoder.java.Expression;
import recoder.java.ExpressionContainer;
import recoder.java.Identifier;
import recoder.java.JavaNonTerminalProgramElement;
import recoder.java.NamedProgramElement;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.SourceElement;
import recoder.java.SourceVisitor;
import recoder.java.declaration.DeclarationSpecifier;
import recoder.java.declaration.VariableDeclaration;
import recoder.list.generic.ASTList;
import recoder.service.ProgramModelInfo;

public class VariableSpecification
extends JavaNonTerminalProgramElement
implements Declaration,
NamedProgramElement,
ExpressionContainer,
Variable {
    private static final long serialVersionUID = -2190909599303924076L;
    protected VariableDeclaration parent;
    protected Identifier name;
    protected Expression initializer;
    protected int dimensions;
    protected ProgramModelInfo service;

    public VariableSpecification() {
    }

    public VariableSpecification(Identifier name) {
        this.setIdentifier(name);
        this.makeParentRoleValid();
    }

    public VariableSpecification(Identifier name, Expression init) {
        this.setParent(this.parent);
        this.setIdentifier(name);
        this.setInitializer(init);
        this.makeParentRoleValid();
    }

    public VariableSpecification(Identifier name, int dimensions, Expression init) {
        this.setParent(this.parent);
        this.setIdentifier(name);
        this.setDimensions(dimensions);
        this.setInitializer(init);
        this.makeParentRoleValid();
    }

    protected VariableSpecification(VariableSpecification proto) {
        super(proto);
        if (proto.name != null) {
            this.name = proto.name.deepClone();
        }
        if (proto.initializer != null) {
            this.initializer = proto.initializer.deepClone();
        }
        this.dimensions = proto.dimensions;
        this.makeParentRoleValid();
    }

    private static void updateModel() {
        factory.getServiceConfiguration().getChangeHistory().updateModel();
    }

    @Override
    public VariableSpecification deepClone() {
        return new VariableSpecification(this);
    }

    @Override
    public void makeParentRoleValid() {
        if (this.name != null) {
            this.name.setParent(this);
        }
        if (this.initializer != null) {
            this.initializer.setExpressionContainer(this);
        }
    }

    @Override
    public NonTerminalProgramElement getASTParent() {
        return this.parent;
    }

    @Override
    public int getChildCount() {
        int result = 0;
        if (this.name != null) {
            ++result;
        }
        if (this.initializer != null) {
            ++result;
        }
        return result;
    }

    @Override
    public ProgramElement getChildAt(int index) {
        if (this.name != null) {
            if (index == 0) {
                return this.name;
            }
            --index;
        }
        if (this.initializer != null && index == 0) {
            return this.initializer;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        if (this.name == child) {
            return 0;
        }
        if (this.initializer == child) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        if (p == null) {
            throw new NullPointerException();
        }
        if (this.name == p) {
            Identifier r;
            this.name = r = (Identifier)q;
            if (r != null) {
                r.setParent(this);
            }
            return true;
        }
        if (this.initializer == p) {
            Expression r;
            this.initializer = r = (Expression)q;
            if (r != null) {
                r.setExpressionContainer(this);
            }
            return true;
        }
        return false;
    }

    public VariableDeclaration getParent() {
        return this.parent;
    }

    public void setParent(VariableDeclaration parent) {
        this.parent = parent;
    }

    @Override
    public int getExpressionCount() {
        return this.initializer != null ? 1 : 0;
    }

    @Override
    public Expression getExpressionAt(int index) {
        if (this.initializer != null && index == 0) {
            return this.initializer;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public final String getName() {
        return this.name == null ? null : this.name.getText();
    }

    @Override
    public Identifier getIdentifier() {
        return this.name;
    }

    @Override
    public void setIdentifier(Identifier id) {
        this.name = id;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(int dimensions) {
        if (dimensions < 0) {
            throw new IllegalArgumentException("Negative dimension?");
        }
        this.dimensions = dimensions;
    }

    public Expression getInitializer() {
        return this.initializer;
    }

    public void setInitializer(Expression expr) {
        this.initializer = expr;
    }

    @Override
    public ASTList<DeclarationSpecifier> getDeclarationSpecifiers() {
        return this.parent != null ? this.parent.getDeclarationSpecifiers() : null;
    }

    @Override
    public void setDeclarationSpecifiers(ASTList<DeclarationSpecifier> m) {
        if (this.parent != null) {
            this.parent.setDeclarationSpecifiers(m);
        }
    }

    public boolean isStrictFp() {
        return this.parent.isStrictFp();
    }

    @Override
    public boolean isFinal() {
        return this.parent.isFinal();
    }

    @Override
    public ProgramModelInfo getProgramModelInfo() {
        return this.service;
    }

    @Override
    public void setProgramModelInfo(ProgramModelInfo service) {
        this.service = service;
    }

    @Override
    public Type getType() {
        if (this.service == null) {
            VariableSpecification.updateModel();
        }
        return this.service.getType(this);
    }

    @Override
    public String getFullName() {
        return this.getName();
    }

    @Override
    public SourceElement getFirstElement() {
        return this.name;
    }

    @Override
    public SourceElement getLastElement() {
        if (this.initializer != null) {
            return this.initializer.getLastElement();
        }
        return this.name;
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitVariableSpecification(this);
    }
}

