/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.declaration;

import recoder.ModelException;
import recoder.abstraction.ClassType;
import recoder.abstraction.TypeParameter;
import recoder.convenience.Naming;
import recoder.java.Identifier;
import recoder.java.ProgramElement;
import recoder.java.SourceElement;
import recoder.java.SourceVisitor;
import recoder.java.declaration.TypeArgumentDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.declaration.VariableSpecification;
import recoder.java.reference.ReferencePrefix;
import recoder.java.reference.TypeReference;
import recoder.java.reference.TypeReferenceContainer;
import recoder.list.generic.ASTList;

public class TypeParameterDeclaration
extends TypeDeclaration
implements TypeReferenceContainer,
TypeParameter {
    private static final long serialVersionUID = -6480521507901415027L;
    protected ASTList<TypeReference> bound;

    public TypeParameterDeclaration() {
    }

    public TypeParameterDeclaration(Identifier name, ASTList<TypeReference> bound) {
        super(name);
        this.bound = bound;
        this.makeParentRoleValid();
    }

    protected TypeParameterDeclaration(TypeParameterDeclaration proto) {
        super(proto);
        if (proto.bound != null) {
            this.bound = proto.bound.deepClone();
        }
        this.makeParentRoleValid();
    }

    @Override
    public int getTypeReferenceCount() {
        return this.bound == null ? 0 : this.bound.size();
    }

    @Override
    public TypeReference getTypeReferenceAt(int index) {
        if (index == 0 && this.bound != null) {
            return (TypeReference)this.bound.get(index);
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    @Override
    public int getChildCount() {
        return (this.name != null ? 1 : 0) + (this.bound != null ? this.bound.size() : 0);
    }

    @Override
    public ProgramElement getChildAt(int index) {
        if (this.name != null) {
            if (index == 0) {
                return this.name;
            }
            --index;
        }
        if (this.bound != null) {
            return (ProgramElement)this.bound.get(index);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        if (child == this.name) {
            return 0;
        }
        int idx = this.bound.indexOf(child);
        if (idx != -1) {
            return idx << 4 | 1;
        }
        return -1;
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        if (p == null) {
            throw new NullPointerException();
        }
        if (p == this.name) {
            this.name = (Identifier)q;
            if (this.name != null) {
                this.name.setParent(this);
            }
            return true;
        }
        if (this.bound != null) {
            int idx = this.bound.indexOf(p);
            if (idx != -1) {
                if (q == null) {
                    this.bound.remove(idx);
                } else {
                    TypeReference tr = (TypeReference)q;
                    this.bound.set(idx, tr);
                    tr.setParent(this);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitTypeParameter(this);
    }

    @Override
    public TypeParameterDeclaration deepClone() {
        return new TypeParameterDeclaration(this);
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.bound != null) {
            for (TypeReference tr : this.bound) {
                tr.setParent(this);
            }
        }
    }

    @Override
    public void validate() throws ModelException {
        if (this.members != null && this.members.size() != 0) {
            throw new ModelException("No members allowed in TypeParameter");
        }
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isOrdinaryInterface() {
        return false;
    }

    @Override
    public boolean isAnnotationType() {
        return false;
    }

    @Override
    public boolean isEnumType() {
        return false;
    }

    @Override
    public boolean isOrdinaryClass() {
        return false;
    }

    @Override
    public ASTList<TypeParameterDeclaration> getTypeParameters() {
        return null;
    }

    public ASTList<TypeReference> getBounds() {
        return this.bound;
    }

    @Override
    public String getParameterName() {
        return this.getName();
    }

    @Override
    public int getBoundCount() {
        return this.bound == null ? 0 : this.bound.size();
    }

    @Override
    public String getBoundName(int boundidx) {
        return Naming.toPathName((ReferencePrefix)this.bound.get(boundidx));
    }

    public ASTList<TypeArgumentDeclaration> getBoundTypeArguments(int boundidx) {
        return ((TypeReference)this.bound.get(boundidx)).getTypeArguments();
    }

    public boolean equals(Object o) {
        return TypeParameter.EqualsImplementor.equals(this, o);
    }

    public void setBound(ASTList<TypeReference> bound) {
        this.bound = bound;
    }

    @Override
    public SourceElement getFirstElement() {
        return this.name;
    }

    @Override
    public SourceElement getLastElement() {
        if (this.bound != null) {
            return (SourceElement)this.bound.get(this.bound.size() - 1);
        }
        return this.name;
    }

    @Override
    public ClassType getTypeInScope(String tname) {
        return null;
    }

    @Override
    public void addTypeToScope(ClassType type, String tname) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addVariableToScope(VariableSpecification var) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeTypeFromScope(String tname) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeVariableFromScope(String tname) {
        throw new UnsupportedOperationException();
    }
}

