/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.declaration;

import recoder.abstraction.TypeArgument;
import recoder.convenience.Naming;
import recoder.java.JavaNonTerminalProgramElement;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.Reference;
import recoder.java.SourceElement;
import recoder.java.SourceVisitor;
import recoder.java.reference.MethodReference;
import recoder.java.reference.TypeReference;
import recoder.java.reference.TypeReferenceContainer;
import recoder.java.reference.UncollatedReferenceQualifier;
import recoder.list.generic.ASTList;

public class TypeArgumentDeclaration
extends JavaNonTerminalProgramElement
implements TypeReferenceContainer,
TypeArgument {
    private static final long serialVersionUID = -8369885569636132718L;
    protected TypeReference typeReference;
    protected TypeArgument.WildcardMode wildcardMode;
    protected Reference parent;

    public TypeArgumentDeclaration() {
        this(null, TypeArgument.WildcardMode.Any);
    }

    protected TypeArgumentDeclaration(TypeArgumentDeclaration proto) {
        super(proto);
        this.wildcardMode = proto.wildcardMode;
        if (proto.typeReference != null) {
            this.typeReference = proto.typeReference.deepClone();
        }
        this.makeParentRoleValid();
    }

    public TypeArgumentDeclaration(TypeReference tr) {
        this(tr, TypeArgument.WildcardMode.None);
    }

    public TypeArgumentDeclaration(TypeReference tr, TypeArgument.WildcardMode wm) {
        this.typeReference = tr;
        this.wildcardMode = wm;
        this.makeParentRoleValid();
    }

    @Override
    public int getTypeReferenceCount() {
        return this.typeReference == null ? 0 : 1;
    }

    @Override
    public TypeReference getTypeReferenceAt(int index) {
        if (index == 0 && this.typeReference != null) {
            return this.typeReference;
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    @Override
    public int getChildCount() {
        return this.getTypeReferenceCount();
    }

    @Override
    public ProgramElement getChildAt(int index) {
        return this.getTypeReferenceAt(index);
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        if (child == this.typeReference) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        if (p == null) {
            throw new NullPointerException();
        }
        if (p == this.typeReference) {
            this.typeReference = (TypeReference)q;
            if (this.typeReference != null) {
                this.typeReference.setParent(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public NonTerminalProgramElement getASTParent() {
        return (NonTerminalProgramElement)((Object)this.parent);
    }

    public Reference getParent() {
        return this.parent;
    }

    public void setParent(Reference tr) {
        this.parent = tr;
        if (!(tr instanceof TypeReference || tr instanceof UncollatedReferenceQualifier || tr instanceof MethodReference)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitTypeArgument(this);
    }

    @Override
    public TypeArgumentDeclaration deepClone() {
        return new TypeArgumentDeclaration(this);
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.typeReference != null) {
            this.typeReference.setParent(this);
        }
    }

    @Override
    public TypeArgument.WildcardMode getWildcardMode() {
        return this.wildcardMode;
    }

    public void setWildcardMode(TypeArgument.WildcardMode wm) {
        this.wildcardMode = wm;
    }

    @Override
    public String getTypeName() {
        return Naming.toPathName(this.typeReference);
    }

    public ASTList<TypeArgumentDeclaration> getTypeArguments() {
        if (this.wildcardMode == TypeArgument.WildcardMode.Any) {
            return null;
        }
        return this.typeReference.getTypeArguments();
    }

    public TypeReference getTypeReference() {
        return this.typeReference;
    }

    public void setTypeReference(TypeReference tr) {
        this.typeReference = tr;
    }

    @Override
    public SourceElement getFirstElement() {
        if (this.wildcardMode != TypeArgument.WildcardMode.None) {
            return this;
        }
        return this.typeReference == null ? this : this.typeReference.getFirstElement();
    }
}

