/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.declaration;

import java.util.ArrayList;
import java.util.List;
import recoder.java.Identifier;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ParameterContainer;
import recoder.java.ProgramElement;
import recoder.java.SourceVisitor;
import recoder.java.declaration.DeclarationSpecifier;
import recoder.java.declaration.VariableDeclaration;
import recoder.java.declaration.VariableSpecification;
import recoder.java.reference.TypeReference;
import recoder.list.generic.ASTList;

public class ParameterDeclaration
extends VariableDeclaration {
    private static final long serialVersionUID = -7820198330917949601L;
    protected ParameterContainer parent;
    protected VariableSpecification varSpec;
    protected boolean varArgParameter;

    public ParameterDeclaration() {
    }

    public ParameterDeclaration(TypeReference typeRef, Identifier name) {
        this.setTypeReference(typeRef);
        this.setVariableSpecification(this.getFactory().createVariableSpecification(name));
        this.makeParentRoleValid();
    }

    public ParameterDeclaration(ASTList<DeclarationSpecifier> mods, TypeReference typeRef, Identifier name) {
        this.setDeclarationSpecifiers(mods);
        this.setTypeReference(typeRef);
        this.setVariableSpecification(this.getFactory().createVariableSpecification(name));
        this.makeParentRoleValid();
    }

    protected ParameterDeclaration(ParameterDeclaration proto) {
        super(proto);
        this.varSpec = proto.varSpec.deepClone();
        this.makeParentRoleValid();
    }

    @Override
    public ParameterDeclaration deepClone() {
        return new ParameterDeclaration(this);
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.varSpec != null) {
            this.varSpec.setParent(this);
        }
    }

    public VariableSpecification getVariableSpecification() {
        return this.varSpec;
    }

    public void setVariableSpecification(VariableSpecification vs) {
        this.varSpec = vs;
    }

    public List<VariableSpecification> getVariables() {
        ArrayList<VariableSpecification> res = new ArrayList<VariableSpecification>(1);
        res.add(this.varSpec);
        return res;
    }

    @Override
    public NonTerminalProgramElement getASTParent() {
        return this.parent;
    }

    @Override
    public int getChildCount() {
        int result = 0;
        if (this.declarationSpecifiers != null) {
            result += this.declarationSpecifiers.size();
        }
        if (this.typeReference != null) {
            ++result;
        }
        if (this.varSpec != null) {
            ++result;
        }
        return result;
    }

    @Override
    public ProgramElement getChildAt(int index) {
        if (this.declarationSpecifiers != null) {
            int len = this.declarationSpecifiers.size();
            if (len > index) {
                return (ProgramElement)this.declarationSpecifiers.get(index);
            }
            index -= len;
        }
        if (this.typeReference != null) {
            if (index == 0) {
                return this.typeReference;
            }
            --index;
        }
        if (this.varSpec != null && index == 0) {
            return this.varSpec;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        int index;
        if (this.declarationSpecifiers != null && (index = this.declarationSpecifiers.indexOf(child)) >= 0) {
            return index << 4 | 0;
        }
        if (this.typeReference == child) {
            return 1;
        }
        if (this.varSpec == child) {
            return 2;
        }
        return -1;
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        if (p == null) {
            throw new NullPointerException();
        }
        int count = this.declarationSpecifiers == null ? 0 : this.declarationSpecifiers.size();
        for (int i = 0; i < count; ++i) {
            if (this.declarationSpecifiers.get(i) != p) continue;
            if (q == null) {
                this.declarationSpecifiers.remove(i);
            } else {
                DeclarationSpecifier r = (DeclarationSpecifier)q;
                this.declarationSpecifiers.set(i, r);
                r.setParent(this);
            }
            return true;
        }
        if (this.typeReference == p) {
            TypeReference r;
            this.typeReference = r = (TypeReference)q;
            if (r != null) {
                r.setParent(this);
            }
            return true;
        }
        if (this.varSpec == p) {
            VariableSpecification r;
            this.varSpec = r = (VariableSpecification)q;
            if (r != null) {
                r.setParent(this);
            }
            return true;
        }
        return false;
    }

    public ParameterContainer getParameterContainer() {
        return this.parent;
    }

    public void setParameterContainer(ParameterContainer c) {
        this.parent = c;
    }

    @Override
    public boolean isPrivate() {
        return false;
    }

    @Override
    public boolean isProtected() {
        return false;
    }

    @Override
    public boolean isPublic() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitParameterDeclaration(this);
    }

    public boolean isVarArg() {
        return this.varArgParameter;
    }

    public void setVarArg(boolean varArg) {
        this.varArgParameter = varArg;
    }
}

