/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.declaration;

import java.util.ArrayList;
import java.util.List;
import recoder.java.Expression;
import recoder.java.Identifier;
import recoder.java.LoopInitializer;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.SourceVisitor;
import recoder.java.StatementContainer;
import recoder.java.declaration.DeclarationSpecifier;
import recoder.java.declaration.VariableDeclaration;
import recoder.java.declaration.VariableSpecification;
import recoder.java.reference.TypeReference;
import recoder.list.generic.ASTArrayList;
import recoder.list.generic.ASTList;

public class LocalVariableDeclaration
extends VariableDeclaration
implements LoopInitializer {
    private static final long serialVersionUID = -504401927803552291L;
    protected StatementContainer parent;
    protected ASTList<VariableSpecification> varSpecs;

    public LocalVariableDeclaration() {
    }

    public LocalVariableDeclaration(TypeReference typeRef, Identifier name) {
        this.setTypeReference(typeRef);
        ASTArrayList<boolean> list = new ASTArrayList<boolean>(true);
        list.add((boolean)this.getFactory().createVariableSpecification(name));
        this.setVariableSpecifications(list);
        this.makeParentRoleValid();
    }

    public LocalVariableDeclaration(ASTList<DeclarationSpecifier> mods, TypeReference typeRef, ASTList<VariableSpecification> vars) {
        this.setDeclarationSpecifiers(mods);
        this.setTypeReference(typeRef);
        this.setVariableSpecifications(vars);
        this.makeParentRoleValid();
    }

    public LocalVariableDeclaration(ASTList<DeclarationSpecifier> mods, TypeReference typeRef, Identifier name, Expression init) {
        this.setDeclarationSpecifiers(mods);
        this.setTypeReference(typeRef);
        ASTArrayList<boolean> list = new ASTArrayList<boolean>(true);
        list.add((boolean)this.getFactory().createVariableSpecification(name, init));
        this.setVariableSpecifications(list);
        this.makeParentRoleValid();
    }

    protected LocalVariableDeclaration(LocalVariableDeclaration proto) {
        super(proto);
        if (proto.varSpecs != null) {
            this.varSpecs = proto.varSpecs.deepClone();
        }
        this.makeParentRoleValid();
    }

    @Override
    public LocalVariableDeclaration deepClone() {
        return new LocalVariableDeclaration(this);
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.varSpecs != null) {
            for (int i = this.varSpecs.size() - 1; i >= 0; --i) {
                ((VariableSpecification)this.varSpecs.get(i)).setParent(this);
            }
        }
    }

    public ASTList<VariableSpecification> getVariableSpecifications() {
        return this.varSpecs;
    }

    public void setVariableSpecifications(ASTList<VariableSpecification> l) {
        this.varSpecs = l;
    }

    public List<VariableSpecification> getVariables() {
        return new ArrayList<VariableSpecification>(this.varSpecs);
    }

    @Override
    public int getChildCount() {
        int result = 0;
        if (this.declarationSpecifiers != null) {
            result += this.declarationSpecifiers.size();
        }
        if (this.typeReference != null) {
            ++result;
        }
        if (this.varSpecs != null) {
            result += this.varSpecs.size();
        }
        return result;
    }

    @Override
    public ProgramElement getChildAt(int index) {
        if (this.declarationSpecifiers != null) {
            int len = this.declarationSpecifiers.size();
            if (len > index) {
                return (ProgramElement)this.declarationSpecifiers.get(index);
            }
            index -= len;
        }
        if (this.typeReference != null) {
            if (index == 0) {
                return this.typeReference;
            }
            --index;
        }
        if (this.varSpecs != null) {
            return (ProgramElement)this.varSpecs.get(index);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        int index;
        if (this.declarationSpecifiers != null && (index = this.declarationSpecifiers.indexOf(child)) >= 0) {
            return index << 4 | 0;
        }
        if (this.typeReference == child) {
            return 1;
        }
        if (this.varSpecs != null && (index = this.varSpecs.indexOf(child)) >= 0) {
            return index << 4 | 2;
        }
        return -1;
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        int i;
        if (p == null) {
            throw new NullPointerException();
        }
        int count = this.declarationSpecifiers == null ? 0 : this.declarationSpecifiers.size();
        for (i = 0; i < count; ++i) {
            if (this.declarationSpecifiers.get(i) != p) continue;
            if (q == null) {
                this.declarationSpecifiers.remove(i);
            } else {
                DeclarationSpecifier r = (DeclarationSpecifier)q;
                this.declarationSpecifiers.set(i, r);
                r.setParent(this);
            }
            return true;
        }
        if (this.typeReference == p) {
            TypeReference r;
            this.typeReference = r = (TypeReference)q;
            if (r != null) {
                r.setParent(this);
            }
            return true;
        }
        count = this.varSpecs == null ? 0 : this.varSpecs.size();
        for (i = 0; i < count; ++i) {
            if (this.varSpecs.get(i) != p) continue;
            if (q == null) {
                this.varSpecs.remove(i);
            } else {
                VariableSpecification r = (VariableSpecification)q;
                this.varSpecs.set(i, r);
                r.setParent(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public NonTerminalProgramElement getASTParent() {
        return this.parent;
    }

    @Override
    public StatementContainer getStatementContainer() {
        return this.parent;
    }

    @Override
    public void setStatementContainer(StatementContainer c) {
        this.parent = c;
    }

    @Override
    public boolean isPrivate() {
        return false;
    }

    @Override
    public boolean isProtected() {
        return false;
    }

    @Override
    public boolean isPublic() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitLocalVariableDeclaration(this);
    }
}

