/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.declaration;

import java.util.ArrayList;
import java.util.List;
import recoder.java.Declaration;
import recoder.java.JavaNonTerminalProgramElement;
import recoder.java.declaration.AnnotationUseSpecification;
import recoder.java.declaration.DeclarationSpecifier;
import recoder.java.declaration.Modifier;
import recoder.java.declaration.modifier.Abstract;
import recoder.java.declaration.modifier.Final;
import recoder.java.declaration.modifier.Native;
import recoder.java.declaration.modifier.Private;
import recoder.java.declaration.modifier.Protected;
import recoder.java.declaration.modifier.Public;
import recoder.java.declaration.modifier.Static;
import recoder.java.declaration.modifier.StrictFp;
import recoder.java.declaration.modifier.Synchronized;
import recoder.java.declaration.modifier.Transient;
import recoder.java.declaration.modifier.VisibilityModifier;
import recoder.java.declaration.modifier.Volatile;
import recoder.list.generic.ASTList;

public abstract class JavaDeclaration
extends JavaNonTerminalProgramElement
implements Declaration {
    protected ASTList<DeclarationSpecifier> declarationSpecifiers;

    public JavaDeclaration() {
    }

    public JavaDeclaration(ASTList<DeclarationSpecifier> mods) {
        this.setDeclarationSpecifiers(mods);
    }

    protected JavaDeclaration(JavaDeclaration proto) {
        super(proto);
        if (proto.declarationSpecifiers != null) {
            this.declarationSpecifiers = proto.declarationSpecifiers.deepClone();
        }
    }

    public List<Modifier> getModifiers() {
        if (this.declarationSpecifiers == null) {
            return new ArrayList<Modifier>(0);
        }
        ArrayList<Modifier> mml = new ArrayList<Modifier>();
        for (DeclarationSpecifier ds : this.declarationSpecifiers) {
            if (!(ds instanceof Modifier)) continue;
            mml.add((Modifier)ds);
        }
        return mml;
    }

    public List<AnnotationUseSpecification> getAnnotations() {
        if (this.declarationSpecifiers == null) {
            return new ArrayList<AnnotationUseSpecification>(0);
        }
        ArrayList<AnnotationUseSpecification> result = new ArrayList<AnnotationUseSpecification>(this.declarationSpecifiers.size());
        int s = this.declarationSpecifiers.size();
        for (DeclarationSpecifier ds : this.declarationSpecifiers) {
            if (!(ds instanceof AnnotationUseSpecification)) continue;
            result.add((AnnotationUseSpecification)ds);
        }
        return result;
    }

    @Override
    public ASTList<DeclarationSpecifier> getDeclarationSpecifiers() {
        return this.declarationSpecifiers;
    }

    @Override
    public void setDeclarationSpecifiers(ASTList<DeclarationSpecifier> m) {
        this.declarationSpecifiers = m;
    }

    public VisibilityModifier getVisibilityModifier() {
        if (this.declarationSpecifiers == null) {
            return null;
        }
        for (int i = this.declarationSpecifiers.size() - 1; i >= 0; --i) {
            DeclarationSpecifier m = (DeclarationSpecifier)this.declarationSpecifiers.get(i);
            if (!(m instanceof VisibilityModifier)) continue;
            return (VisibilityModifier)m;
        }
        return null;
    }

    final boolean containsModifier(Class type) {
        int s = this.declarationSpecifiers == null ? 0 : this.declarationSpecifiers.size();
        for (int i = 0; i < s; ++i) {
            if (!type.isInstance(this.declarationSpecifiers.get(i))) continue;
            return true;
        }
        return false;
    }

    protected boolean isAbstract() {
        return this.containsModifier(Abstract.class);
    }

    protected boolean isPrivate() {
        return this.containsModifier(Private.class);
    }

    protected boolean isProtected() {
        return this.containsModifier(Protected.class);
    }

    protected boolean isPublic() {
        return this.containsModifier(Public.class);
    }

    protected boolean isStatic() {
        return this.containsModifier(Static.class);
    }

    protected boolean isTransient() {
        return this.containsModifier(Transient.class);
    }

    protected boolean isVolatile() {
        return this.containsModifier(Volatile.class);
    }

    protected boolean isStrictFp() {
        return this.containsModifier(StrictFp.class);
    }

    protected boolean isFinal() {
        return this.containsModifier(Final.class);
    }

    protected boolean isNative() {
        return this.containsModifier(Native.class);
    }

    protected boolean isSynchronized() {
        return this.containsModifier(Synchronized.class);
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.declarationSpecifiers != null) {
            for (int i = this.declarationSpecifiers.size() - 1; i >= 0; --i) {
                ((DeclarationSpecifier)this.declarationSpecifiers.get(i)).setParent(this);
            }
        }
    }
}

