/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.declaration;

import java.util.ArrayList;
import java.util.List;
import recoder.ModelException;
import recoder.java.Identifier;
import recoder.java.ProgramElement;
import recoder.java.SourceVisitor;
import recoder.java.declaration.DeclarationSpecifier;
import recoder.java.declaration.EnumConstantDeclaration;
import recoder.java.declaration.Implements;
import recoder.java.declaration.MemberDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.declaration.TypeParameterDeclaration;
import recoder.java.declaration.modifier.Abstract;
import recoder.java.declaration.modifier.Final;
import recoder.list.generic.ASTList;
import recoder.service.IllegalModifierException;

public class EnumDeclaration
extends TypeDeclaration {
    private static final long serialVersionUID = -6436741776435910109L;
    protected Implements implementing;

    public EnumDeclaration() {
    }

    public EnumDeclaration(ASTList<DeclarationSpecifier> declSpecs, Identifier name, Implements implementing, ASTList<MemberDeclaration> members) {
        super(declSpecs, name);
        this.setMembers(members);
        this.implementing = implementing;
        this.makeParentRoleValid();
    }

    public EnumDeclaration(EnumDeclaration proto) {
        super(proto);
        this.members = proto.members.deepClone();
        this.implementing = proto.implementing.deepClone();
        this.makeParentRoleValid();
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isOrdinaryInterface() {
        return false;
    }

    @Override
    public boolean isAnnotationType() {
        return false;
    }

    @Override
    public boolean isEnumType() {
        return true;
    }

    @Override
    public boolean isOrdinaryClass() {
        return false;
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.implementing != null) {
            this.implementing.setParent(this);
        }
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        int idx = this.declarationSpecifiers.indexOf(child);
        if (idx != -1) {
            return idx << 4 | 0;
        }
        if (child == this.name) {
            return 1;
        }
        if (child == this.implementing) {
            return 2;
        }
        idx = this.members.indexOf(child);
        if (idx != -1) {
            return idx << 4 | 3;
        }
        return -1;
    }

    @Override
    public int getChildCount() {
        int res = 0;
        if (this.declarationSpecifiers != null) {
            res += this.declarationSpecifiers.size();
        }
        if (this.name != null) {
            ++res;
        }
        if (this.implementing != null) {
            ++res;
        }
        if (this.members != null) {
            res += this.members.size();
        }
        return res;
    }

    @Override
    public ProgramElement getChildAt(int index) {
        if (this.declarationSpecifiers != null) {
            if (index < this.declarationSpecifiers.size()) {
                return (ProgramElement)this.declarationSpecifiers.get(index);
            }
            index -= this.declarationSpecifiers.size();
        }
        if (this.name != null) {
            if (index == 0) {
                return this.name;
            }
            --index;
        }
        if (this.implementing != null) {
            if (index == 0) {
                return this.implementing;
            }
            --index;
        }
        return (ProgramElement)this.members.get(index);
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        int idx;
        if (p == null) {
            throw new NullPointerException();
        }
        if (this.name == p) {
            this.name = (Identifier)q;
            if (this.name != null) {
                this.name.setParent(this);
            }
            return true;
        }
        if (this.implementing == p) {
            this.implementing = (Implements)q;
            if (this.implementing != null) {
                this.implementing.setParent(this);
            }
            return true;
        }
        if (this.declarationSpecifiers != null && (idx = this.declarationSpecifiers.indexOf(p)) != -1) {
            if (q != null) {
                DeclarationSpecifier ds = (DeclarationSpecifier)q;
                this.declarationSpecifiers.set(idx, ds);
                ds.setParent(this);
            } else {
                this.declarationSpecifiers.remove(idx);
            }
            return true;
        }
        if (this.members != null && (idx = this.members.indexOf(p)) != -1) {
            if (q != null) {
                MemberDeclaration md = (MemberDeclaration)q;
                this.members.set(idx, md);
                md.setMemberParent(this);
            } else {
                this.members.remove(idx);
            }
            return true;
        }
        return false;
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitEnumDeclaration(this);
    }

    @Override
    public EnumDeclaration deepClone() {
        return new EnumDeclaration(this);
    }

    public Implements getImplementedTypes() {
        return this.implementing;
    }

    public void setImplementedTypes(Implements implementing) {
        this.implementing = implementing;
    }

    @Override
    public boolean isFinal() {
        boolean res = true;
        for (MemberDeclaration m : this.members) {
            if (!(m instanceof EnumConstantDeclaration) || ((EnumConstantDeclaration)m).getEnumConstantSpecification().getConstructorReference().getClassDeclaration() == null) continue;
            res = false;
            break;
        }
        return res;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return this.getASTParent() instanceof TypeDeclaration || super.isStatic();
    }

    @Override
    public void validate() throws ModelException {
        if (this.containsModifier(Abstract.class)) {
            throw new IllegalModifierException("Illegal abstract modifier in EnumDeclaration " + this.getFullName());
        }
        if (this.containsModifier(Final.class)) {
            throw new IllegalModifierException("Illegal final modifier in EnumDeclaration " + this.getFullName());
        }
    }

    @Override
    public ASTList<TypeParameterDeclaration> getTypeParameters() {
        return null;
    }

    public List<EnumConstantDeclaration> getConstants() {
        if (this.members == null) {
            return new ArrayList<EnumConstantDeclaration>(0);
        }
        ArrayList<EnumConstantDeclaration> result = new ArrayList<EnumConstantDeclaration>();
        for (MemberDeclaration m : this.members) {
            if (!(m instanceof EnumConstantDeclaration)) continue;
            result.add((EnumConstantDeclaration)m);
        }
        return result;
    }

    public List<MemberDeclaration> getNonConstantMembers() {
        if (this.members == null) {
            return new ArrayList<MemberDeclaration>(0);
        }
        ArrayList<MemberDeclaration> result = new ArrayList<MemberDeclaration>();
        for (MemberDeclaration m : this.members) {
            if (m instanceof EnumConstantDeclaration) continue;
            result.add(m);
        }
        return result;
    }
}

