/*
 * Decompiled with CFR 0.152.
 */
package recoder.convenience;

import recoder.convenience.ASTIteratorListener;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;

public class ASTIterator {
    public static final int ENTER_NONE = 0;
    public static final int ENTER_SOME = 1;
    public static final int ENTER_ALL = 2;
    ASTIteratorListener listener = null;

    public ASTIterator() {
    }

    public ASTIterator(ASTIteratorListener l) {
        this.setListener(l);
    }

    public void setListener(ASTIteratorListener l) {
        this.listener = l;
    }

    public void iterate(ProgramElement pe) {
        if (this.listener != null) {
            this.recurse(pe);
        } else {
            this.simpleRecurse(pe);
        }
    }

    protected void recurse(ProgramElement pe) {
        if (pe != null) {
            this.listener.enteringNode(this, pe);
            if (pe instanceof NonTerminalProgramElement) {
                NonTerminalProgramElement ntpe = (NonTerminalProgramElement)pe;
                switch (this.listener.enterChildren(this, ntpe)) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        int childCount = ntpe.getChildCount();
                        for (int i = 0; i < childCount; ++i) {
                            ProgramElement child = ntpe.getChildAt(i);
                            if (!this.listener.enterChildNode(this, ntpe, child)) continue;
                            this.recurse(child);
                            this.listener.returnedFromChildNode(this, ntpe, child);
                        }
                        break;
                    }
                    case 2: {
                        int childCount = ntpe.getChildCount();
                        for (int i = 0; i < childCount; ++i) {
                            ProgramElement child = ntpe.getChildAt(i);
                            this.recurse(child);
                        }
                        break;
                    }
                }
            }
            this.listener.leavingNode(this, pe);
        }
    }

    protected void simpleRecurse(ProgramElement pe) {
        if (pe instanceof NonTerminalProgramElement) {
            NonTerminalProgramElement ntpe = (NonTerminalProgramElement)pe;
            int childCount = ntpe.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                ProgramElement child = ntpe.getChildAt(i);
                this.simpleRecurse(child);
            }
        }
    }
}

