/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.support.mode;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionGuard;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.action.MultiDockActionSource;
import bibliothek.gui.dock.support.mode.AffectedSet;
import bibliothek.gui.dock.support.mode.AffectingRunnable;
import bibliothek.gui.dock.support.mode.HistoryRewriter;
import bibliothek.gui.dock.support.mode.Mode;
import bibliothek.gui.dock.support.mode.ModeForwardingActionSource;
import bibliothek.gui.dock.support.mode.ModeManagerListener;
import bibliothek.gui.dock.support.mode.ModeSetting;
import bibliothek.gui.dock.support.mode.ModeSettingFactory;
import bibliothek.gui.dock.support.mode.ModeSettings;
import bibliothek.gui.dock.support.mode.ModeSettingsConverter;
import bibliothek.gui.dock.support.mode.UndoableModeSettings;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ModeManager<H, M extends Mode<H>> {
    private List<ModeHandle> modes = new ArrayList<ModeHandle>();
    private Map<Path, ModeSettingFactory<H>> factories = new HashMap<Path, ModeSettingFactory<H>>();
    private Map<Dockable, DockableHandle> dockables = new HashMap<Dockable, DockableHandle>();
    private Map<String, DockableHandle> entries = new HashMap<String, DockableHandle>();
    private List<ModeManagerListener<? super H, ? super M>> listeners = new ArrayList<ModeManagerListener<? super H, ? super M>>();
    private int onTransaction = 0;
    private int onContinuous = 0;
    private DockController controller;
    private ChangeSet affected;
    private int affectedCount = 0;
    private HistoryRewriter<H, M> historyRewriter;
    private ActionGuard guard = new ActionGuard(){

        public boolean react(Dockable dockable) {
            return ModeManager.this.getHandle(dockable) != null;
        }

        public DockActionSource getSource(Dockable dockable) {
            DockableHandle handle = ModeManager.this.getHandle(dockable);
            if (handle == null) {
                return null;
            }
            return handle.source;
        }
    };
    private ActionGuard stationGuard = new ActionGuard(){

        public boolean react(Dockable dockable) {
            DockStation station = dockable.asDockStation();
            return station != null && ModeManager.this.getHandle(dockable) == null;
        }

        public DockActionSource getSource(Dockable dockable) {
            return new ModeForwardingActionSource(dockable.asDockStation(), ModeManager.this);
        }
    };

    public ModeManager(DockController controller) {
        controller.addActionGuard(this.stationGuard);
        controller.addActionGuard(this.guard);
        this.controller = controller;
    }

    public void destroy() {
        if (this.controller != null) {
            this.controller.removeActionGuard(this.stationGuard);
            this.controller.removeActionGuard(this.guard);
            this.controller = null;
        }
    }

    public DockController getController() {
        return this.controller;
    }

    public void addModeManagerListener(ModeManagerListener<? super H, ? super M> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listeners.add(listener);
    }

    public void removeModeManagerListener(ModeManagerListener<? super H, ? super M> listener) {
        this.listeners.remove(listener);
    }

    public void putMode(M mode) {
        if (mode == null) {
            throw new IllegalArgumentException("mode must not be null");
        }
        for (ModeHandle handle : this.modes) {
            if (!handle.mode.getUniqueIdentifier().equals((Object)mode.getUniqueIdentifier())) continue;
            this.fireRemoved(handle.mode);
            handle.mode = mode;
            this.fireAdded(mode);
            return;
        }
        this.modes.add(new ModeHandle(this, mode));
        this.fireAdded(mode);
    }

    public void putFactory(ModeSettingFactory<H> factory) {
        this.factories.put(factory.getModeId(), factory);
    }

    public Collection<ModeSettingFactory<H>> getFactories() {
        return Collections.unmodifiableCollection(this.factories.values());
    }

    public void removeMode(M mode) {
        if (mode == null) {
            throw new IllegalArgumentException("mode must not be null");
        }
        for (ModeHandle handle : this.modes) {
            if (!handle.mode.getUniqueIdentifier().equals((Object)mode.getUniqueIdentifier())) continue;
            handle.mode = null;
            this.fireRemoved(handle.mode);
            this.modes.remove(handle);
            return;
        }
    }

    public M getMode(Path path) {
        ModeHandle handle = this.getAccess(path);
        return handle == null ? null : (M)handle.mode;
    }

    private ModeHandle getAccess(Path path) {
        for (ModeHandle mode : this.modes) {
            if (!mode.mode.getUniqueIdentifier().equals((Object)path)) continue;
            return mode;
        }
        return null;
    }

    public void setHistoryRewriter(HistoryRewriter<H, M> historyRewriter) {
        this.historyRewriter = historyRewriter;
    }

    public HistoryRewriter<H, M> getHistoryRewriter() {
        return this.historyRewriter;
    }

    protected ModeManagerListener<? super H, ? super M>[] listeners() {
        return this.listeners.toArray(new ModeManagerListener[this.listeners.size()]);
    }

    protected void fireAdded(Dockable dockable) {
        for (ModeManagerListener<H, M> listener : this.listeners()) {
            listener.dockableAdded(this, dockable);
        }
    }

    protected void fireRemoved(Dockable dockable) {
        for (ModeManagerListener<H, M> listener : this.listeners()) {
            listener.dockableRemoved(this, dockable);
        }
    }

    protected void fireModeChanged(Dockable dockable, M oldMode, M newMode) {
        for (ModeManagerListener<H, M> listener : this.listeners()) {
            listener.modeChanged(this, dockable, oldMode, newMode);
        }
    }

    protected void fireAdded(M mode) {
        for (ModeManagerListener<H, M> listener : this.listeners()) {
            listener.modeAdded(this, mode);
        }
    }

    protected void fireRemoved(M mode) {
        for (ModeManagerListener<H, M> listener : this.listeners()) {
            listener.modeRemoved(this, mode);
        }
    }

    public void add(String key, Dockable dockable) {
        if (key == null) {
            throw new NullPointerException("key must not be null");
        }
        if (dockable == null) {
            throw new NullPointerException("dockable must not be null");
        }
        DockableHandle entry = this.entries.get(key);
        if (entry != null && entry.dockable != null) {
            throw new IllegalArgumentException("There is already a dockable registered with the key: " + key);
        }
        if (this.dockables.containsKey(dockable)) {
            throw new IllegalArgumentException("The dockable is already known to this manager (but it does have a different name)");
        }
        if (entry == null) {
            entry = new DockableHandle(dockable, key);
            this.entries.put(entry.id, entry);
        } else {
            entry.dockable = dockable;
        }
        this.dockables.put(dockable, entry);
        entry.putMode(this.access(this.getCurrentMode(dockable)));
        this.fireAdded(dockable);
        this.rebuild(dockable);
    }

    public void put(String key, Dockable dockable) {
        if (key == null) {
            throw new NullPointerException("key must not be null");
        }
        if (dockable == null) {
            throw new NullPointerException("dockable must not be null");
        }
        DockableHandle entry = this.entries.get(key);
        if (entry != null) {
            if (entry.dockable != null) {
                this.dockables.remove(entry.dockable);
                this.fireRemoved(entry.dockable);
            }
            entry.dockable = dockable;
            this.dockables.put(dockable, entry);
        } else {
            entry = new DockableHandle(dockable, key);
            this.dockables.put(dockable, entry);
            this.entries.put(entry.id, entry);
            entry.putMode(this.access(this.getCurrentMode(dockable)));
        }
        this.fireAdded(dockable);
        this.rebuild(dockable);
    }

    public String getKey(Dockable dockable) {
        DockableHandle handle = this.getHandle(dockable);
        if (handle == null) {
            return null;
        }
        return handle.id;
    }

    public boolean isRegistered(Dockable dockable) {
        return this.getKey(dockable) != null;
    }

    public Set<Dockable> listDockables() {
        return Collections.unmodifiableSet(this.dockables.keySet());
    }

    public void runTransaction(AffectingRunnable runnable) {
        this.runTransaction(runnable, false);
    }

    public void runTransaction(final AffectingRunnable run, boolean continuous) {
        if (run == null) {
            return;
        }
        try {
            this.openAffected();
            this.runTransaction(new Runnable(){

                @Override
                public void run() {
                    run.run(ModeManager.this.affected);
                }
            }, continuous);
        }
        finally {
            this.closeAffected();
        }
    }

    public void runTransaction(Runnable run) {
        this.runTransaction(run, false);
    }

    public void runTransaction(Runnable run, boolean continuous) {
        try {
            this.controller.getRegister().setStalled(true);
            ++this.onTransaction;
            if (continuous) {
                ++this.onContinuous;
            }
            run.run();
        }
        finally {
            this.controller.getRegister().setStalled(false);
            --this.onTransaction;
            if (continuous) {
                --this.onContinuous;
            }
        }
    }

    public boolean apply(Dockable dockable, Path mode, boolean force) {
        M resolved = this.getMode(mode);
        if (resolved != null) {
            this.apply(dockable, resolved, force);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(Dockable dockable, M mode, boolean force) {
        try {
            this.openAffected();
            this.apply(dockable, mode, (AffectedSet)this.affected, force);
        }
        finally {
            this.closeAffected();
        }
    }

    public boolean apply(Dockable dockable, Path mode, AffectedSet set, boolean force) {
        M resolved = this.getMode(mode);
        if (resolved != null) {
            this.apply(dockable, resolved, set, force);
            return true;
        }
        return false;
    }

    public void apply(Dockable dockable, M mode, AffectedSet set, boolean force) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable is null");
        }
        if (mode == null) {
            throw new IllegalArgumentException("mode is null");
        }
        if (set == null) {
            throw new IllegalArgumentException("set is null");
        }
        DockableHandle entry = this.dockables.get(dockable);
        if (entry == null) {
            throw new IllegalArgumentException("dockable not registered");
        }
        M dockableMode = this.getCurrentMode(dockable);
        if (!force && dockableMode == mode) {
            return;
        }
        Object history = entry.properties.get(mode.getUniqueIdentifier());
        this.apply(dockable, mode, history, set);
    }

    public H getHistory(Dockable dockable, Path modeId) {
        DockableHandle entry = this.dockables.get(dockable);
        if (entry == null) {
            return null;
        }
        return entry.properties.get(modeId);
    }

    public boolean apply(Dockable dockable, Path mode, H history, AffectedSet set) {
        M resolved = this.getMode(mode);
        if (resolved != null) {
            this.apply(dockable, resolved, history, set);
            return true;
        }
        return false;
    }

    public void apply(final Dockable dockable, M mode, final H history, AffectedSet set) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable is null");
        }
        if (mode == null) {
            throw new IllegalArgumentException("mode is null");
        }
        if (set == null) {
            throw new IllegalArgumentException("set is null");
        }
        M dockableMode = this.getCurrentMode(dockable);
        if (dockableMode != null) {
            this.store(dockable);
        }
        set.add(dockable);
        this.runTransaction(new Runnable(){
            final /* synthetic */ Mode val$mode;
            final /* synthetic */ AffectedSet val$set;
            {
                this.val$mode = mode;
                this.val$set = affectedSet;
            }

            @Override
            public void run() {
                Object rewritten = history;
                if (ModeManager.this.historyRewriter != null) {
                    rewritten = ModeManager.this.historyRewriter.rewrite(dockable, this.val$mode, history);
                }
                this.val$mode.apply(dockable, rewritten, this.val$set);
            }
        });
    }

    protected void setProperties(M mode, Dockable dockable, H property) {
        DockableHandle entry = this.dockables.get(dockable);
        if (entry != null) {
            if (property == null) {
                entry.properties.remove(mode.getUniqueIdentifier());
            } else {
                entry.properties.put(mode.getUniqueIdentifier(), property);
            }
        }
    }

    protected H getProperties(M mode, Dockable dockable) {
        DockableHandle entry = this.dockables.get(dockable);
        if (entry == null) {
            return null;
        }
        return entry.properties.get(mode.getUniqueIdentifier());
    }

    public boolean isOnTransaction() {
        return this.onTransaction > 0;
    }

    public boolean isOnContinuous() {
        return this.onContinuous > 0;
    }

    public void refresh() {
        for (Dockable dockable : this.dockables.keySet()) {
            this.refresh(dockable, false);
        }
    }

    public void refresh(Dockable dockable, boolean recursive) {
        DockStation station;
        DockableHandle handle = this.getHandle(dockable);
        if (handle != null) {
            handle.putMode(this.access(this.getCurrentMode(dockable)));
        }
        if (recursive && (station = dockable.asDockStation()) != null) {
            int n = station.getDockableCount();
            for (int i = 0; i < n; ++i) {
                this.refresh(station.getDockable(i), recursive);
            }
        }
    }

    public void remove(Dockable dockable) {
        DockableHandle entry = this.dockables.remove(dockable);
        if (entry != null) {
            if (!entry.empty) {
                this.entries.remove(entry.id);
            }
            this.fireRemoved(dockable);
        }
    }

    public void reduceToEmpty(Dockable dockable) {
        DockableHandle entry = this.dockables.get(dockable);
        if (entry != null) {
            entry.dockable = null;
            this.fireRemoved(dockable);
        }
    }

    protected abstract void applyDuringRead(String var1, Path var2, Path var3, Dockable var4);

    protected boolean createEntryDuringRead(String key) {
        return false;
    }

    public void addEmpty(String key) {
        if (key == null) {
            throw new NullPointerException("name must not be null");
        }
        DockableHandle entry = this.entries.get(key);
        if (entry == null) {
            entry = new DockableHandle(null, key);
            this.entries.put(key, entry);
        }
        entry.empty = true;
    }

    public void removeEmpty(String name) {
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        DockableHandle entry = this.entries.get(name);
        if (entry != null) {
            entry.empty = false;
            if (entry.dockable == null) {
                this.entries.remove(name);
            }
        }
    }

    public boolean isEmpty(String key) {
        DockableHandle entry = this.entries.get(key);
        return entry != null && entry.empty;
    }

    public Dockable getDoubleClickTarget(Dockable target) {
        if (target == null) {
            return null;
        }
        if (this.dockables.get(target) != null) {
            return target;
        }
        DockStation station = target.asDockStation();
        if (station == null) {
            return null;
        }
        return this.getDoubleClickTarget(station.getFrontDockable());
    }

    protected M getDefaultMode(Dockable dockable) {
        if (this.modes.isEmpty()) {
            throw new IllegalStateException("no modes available");
        }
        for (ModeHandle mode : this.modes) {
            if (!mode.mode.isDefaultMode(dockable)) continue;
            return mode.mode;
        }
        throw new IllegalStateException("no mode is the default mode for '" + dockable.getTitleText() + "'");
    }

    public M getCurrentMode(Dockable dockable) {
        for (ModeHandle mode : this.modes) {
            if (!mode.mode.isCurrentMode(dockable)) continue;
            return mode.mode;
        }
        return null;
    }

    public M getPreviousMode(Dockable dockable) {
        DockableHandle handle = this.getHandle(dockable);
        if (handle == null) {
            return null;
        }
        ModeHandle mode = handle.previousMode();
        if (mode == null) {
            return null;
        }
        return mode.mode;
    }

    public List<M> getModeHistory(Dockable dockable) {
        DockableHandle handle = this.getHandle(dockable);
        if (handle == null) {
            return Collections.emptyList();
        }
        M lastMode = this.getCurrentMode(dockable);
        ArrayList result = new ArrayList();
        for (Path path : handle.history) {
            M mode = this.getMode(path);
            this.addMode(mode, result);
            if (mode != lastMode) continue;
            lastMode = null;
        }
        this.addMode(lastMode, result);
        return result;
    }

    private void addMode(M mode, List<M> result) {
        if (mode != null) {
            result.add(mode);
        }
    }

    public void addToModeHistory(Dockable dockable, M mode, H history) {
        DockableHandle handle = this.getHandle(dockable);
        if (handle == null) {
            throw new IllegalArgumentException("unknown dockable");
        }
        handle.addToHistory(mode.getUniqueIdentifier(), history);
    }

    public List<H> getPropertyHistory(Dockable dockable) {
        DockableHandle handle = this.getHandle(dockable);
        if (handle == null) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList();
        for (Path path : handle.history) {
            Object history = handle.properties.get(path);
            if (history == null) continue;
            result.add(history);
        }
        return result;
    }

    public void store(Dockable dockable) {
        if (this.isOnContinuous()) {
            return;
        }
        DockUtilities.visit((Dockable)dockable, (DockUtilities.DockVisitor)new DockUtilities.DockVisitor(){

            public void handleDockable(Dockable check) {
                Object mode = ModeManager.this.getCurrentMode(check);
                if (mode != null) {
                    ModeManager.this.store(mode, check);
                }
            }
        });
    }

    protected void store(M mode, Dockable dockable) {
        if (this.isOnContinuous()) {
            return;
        }
        DockableHandle handle = this.getHandle(dockable);
        if (handle != null) {
            handle.properties.put(mode.getUniqueIdentifier(), mode.current(dockable));
        }
    }

    private ModeHandle access(M mode) {
        if (mode == null) {
            return null;
        }
        for (ModeHandle access : this.modes) {
            if (access.mode != mode) continue;
            return access;
        }
        throw new IllegalArgumentException("unknown mode: " + String.valueOf(mode));
    }

    public Iterable<M> modes() {
        return new Iterable<M>(){

            @Override
            public Iterator<M> iterator() {
                final Iterator<ModeHandle> handles = ModeManager.this.modes.iterator();
                return new Iterator<M>(){

                    @Override
                    public boolean hasNext() {
                        return handles.hasNext();
                    }

                    @Override
                    public M next() {
                        return ((ModeHandle)handles.next()).mode;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("cannot remove modes this way");
                    }
                };
            }
        };
    }

    protected void rebuildAll() {
        for (DockableHandle handle : this.dockables.values()) {
            handle.updateActionSource();
        }
    }

    protected void rebuild(Dockable dockable) {
        DockableHandle entry = this.dockables.get(dockable);
        if (entry != null) {
            entry.updateActionSource();
        }
    }

    public abstract DockActionSource getSharedActions(DockStation var1);

    private DockableHandle getHandle(Dockable dockable) {
        return this.dockables.get(dockable);
    }

    public <B> ModeSettings<H, B> createSettings(ModeSettingsConverter<H, B> converter) {
        ModeSettings<H, B> settings = this.createModeSettings(converter);
        for (ModeSettingFactory<H> factory : this.factories.values()) {
            settings.addFactory(factory);
        }
        for (ModeHandle mode : this.modes) {
            ModeSettingFactory factory;
            if (mode.mode == null || (factory = mode.mode.getSettingFactory()) == null) continue;
            settings.addFactory(factory);
        }
        return settings;
    }

    public <B> ModeSettings<H, B> createModeSettings(ModeSettingsConverter<H, B> converter) {
        return new ModeSettings<H, B>(converter);
    }

    public void writeSettings(ModeSettings<H, ?> setting) {
        for (DockableHandle dockableHandle : this.entries.values()) {
            setting.add(dockableHandle.id, dockableHandle.getCurrent(), dockableHandle.properties, dockableHandle.history);
        }
        for (ModeHandle modeHandle : this.modes) {
            if (modeHandle.mode == null) continue;
            setting.add((Mode<H>)modeHandle.mode);
        }
    }

    public void readSettings(ModeSettings<H, ?> settings) {
        this.readSettings(settings, null);
    }

    public Runnable readSettings(ModeSettings<H, ?> settings, UndoableModeSettings pending) {
        final ArrayList<String> temporary = new ArrayList<String>();
        int n = settings.size();
        for (int i = 0; i < n; ++i) {
            M oldMode;
            String key = settings.getId(i);
            DockableHandle entry = this.entries.get(key);
            if (entry == null) {
                if (this.createEntryDuringRead(key)) {
                    this.addEmpty(key);
                    entry = this.entries.get(key);
                } else if (pending != null && pending.createTemporaryDuringRead(key)) {
                    this.addEmpty(key);
                    entry = this.entries.get(key);
                    temporary.add(key);
                }
            }
            if (entry == null) continue;
            Path current = settings.getCurrent(i);
            Path old = null;
            if (entry.dockable != null && (oldMode = this.getCurrentMode(entry.dockable)) != null) {
                old = oldMode.getUniqueIdentifier();
            }
            if (current == null) {
                current = old;
            }
            entry.history.clear();
            for (Path next : settings.getHistory(i)) {
                entry.history.add(next);
            }
            entry.properties = settings.getProperties(i);
            if ((old != null || current == null) && (old == null || old.equals((Object)current))) continue;
            this.applyDuringRead(key, old, current, entry.dockable);
        }
        for (ModeHandle handle : this.modes) {
            ModeSetting<H> setting;
            if (handle.mode == null || (setting = settings.getSettings(handle.mode.getUniqueIdentifier())) == null) continue;
            handle.mode.readSetting(setting);
        }
        if (pending == null) {
            return null;
        }
        return new Runnable(){

            @Override
            public void run() {
                for (String key : temporary) {
                    ModeManager.this.removeEmpty(key);
                }
            }
        };
    }

    public void addAffected(Iterable<Dockable> dockables) {
        this.openAffected();
        for (Dockable element : dockables) {
            this.affected.add(element);
        }
        this.closeAffected();
    }

    private void openAffected() {
        if (this.affectedCount == 0) {
            this.affected = new ChangeSet();
        }
        ++this.affectedCount;
    }

    private void closeAffected() {
        --this.affectedCount;
        if (this.affectedCount == 0) {
            ChangeSet old = this.affected;
            this.affected = null;
            old.finish();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        for (DockableHandle handle : this.entries.values()) {
            builder.append("\n\t");
            builder.append(handle.id);
            for (Map.Entry entry : handle.properties.entrySet()) {
                builder.append("\n\t\t");
                builder.append(entry.getKey());
                builder.append(" -> ");
                builder.append(entry.getValue());
            }
        }
        builder.append("\n]");
        return builder.toString();
    }

    private static class ModeHandle {
        private M mode;
        final /* synthetic */ ModeManager this$0;

        public ModeHandle(M mode) {
            this.this$0 = var1_1;
            this.mode = mode;
        }
    }

    private class DockableHandle {
        public Dockable dockable;
        public String id;
        public MultiDockActionSource source;
        public Map<Path, H> properties;
        private List<Path> history;
        private boolean empty = false;

        public DockableHandle(Dockable dockable, String id) {
            this.dockable = dockable;
            this.id = id;
            this.source = new MultiDockActionSource(new LocationHint(LocationHint.ACTION_GUARD, LocationHint.RIGHT), new DockActionSource[0]);
            this.properties = new HashMap();
            this.history = new LinkedList<Path>();
        }

        public void updateActionSource() {
            if (this.dockable != null) {
                this.source.removeAll();
                Object mode = ModeManager.this.getCurrentMode(this.dockable);
                if (mode == null) {
                    mode = ModeManager.this.getDefaultMode(this.dockable);
                }
                for (ModeHandle access : ModeManager.this.modes) {
                    DockActionSource next = access.mode.getActionsFor(this.dockable, mode);
                    if (next == null) continue;
                    this.source.add(next);
                }
            }
        }

        public void putMode(ModeHandle mode) {
            if (mode != null) {
                ModeHandle oldMode = this.peekMode();
                if (oldMode != mode) {
                    Path id = mode.mode.getUniqueIdentifier();
                    this.addToHistory(id, mode.mode.current(this.dockable));
                    ModeManager.this.rebuild(this.dockable);
                    ModeManager.this.fireModeChanged(this.dockable, oldMode == null ? null : (Object)oldMode.mode, mode.mode);
                } else {
                    ModeManager.this.rebuild(this.dockable);
                }
            }
        }

        public void addToHistory(Path id, H data) {
            this.history.remove(id);
            this.history.add(id);
            this.properties.put(id, data);
        }

        public ModeHandle previousMode() {
            if (this.history.size() < 2) {
                return ModeManager.this.access(ModeManager.this.getDefaultMode(this.dockable));
            }
            return ModeManager.this.getAccess(this.history.get(this.history.size() - 2));
        }

        public ModeHandle peekMode() {
            if (this.history.isEmpty()) {
                return null;
            }
            return ModeManager.this.getAccess(this.history.get(this.history.size() - 1));
        }

        public Path getCurrent() {
            if (this.dockable == null) {
                return null;
            }
            Object mode = ModeManager.this.getCurrentMode(this.dockable);
            if (mode == null) {
                return null;
            }
            return mode.getUniqueIdentifier();
        }
    }

    private class ChangeSet
    implements AffectedSet {
        private Set<Dockable> set = new HashSet<Dockable>();

        @Override
        public void add(Dockable dockable) {
            if (dockable != null) {
                this.set.add(dockable);
                DockStation station = dockable.asDockStation();
                if (station != null) {
                    int n = station.getDockableCount();
                    for (int i = 0; i < n; ++i) {
                        this.add(station.getDockable(i));
                    }
                }
            }
        }

        public void finish() {
            for (Dockable dockable : this.set) {
                ModeManager.this.refresh(dockable, false);
            }
        }
    }
}

