/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.theme;

import bibliothek.extension.gui.dock.theme.BubbleTheme;
import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.extension.gui.dock.theme.FlatTheme;
import bibliothek.extension.gui.dock.theme.SmoothTheme;
import bibliothek.gui.DockTheme;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.theme.CBasicTheme;
import bibliothek.gui.dock.common.theme.CBubbleTheme;
import bibliothek.gui.dock.common.theme.CDockThemeFactory;
import bibliothek.gui.dock.common.theme.CEclipseTheme;
import bibliothek.gui.dock.common.theme.CFlatTheme;
import bibliothek.gui.dock.common.theme.CSmoothTheme;
import bibliothek.gui.dock.common.theme.DockThemeModifier;
import bibliothek.gui.dock.common.theme.ThemeMapListener;
import bibliothek.gui.dock.support.util.ApplicationResource;
import bibliothek.gui.dock.themes.BasicTheme;
import bibliothek.gui.dock.themes.ThemeFactory;
import bibliothek.gui.dock.themes.ThemePropertyFactory;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ThemeMap {
    public static final String KEY_BASIC_THEME = "basic";
    public static final String KEY_BUBBLE_THEME = "bubble";
    public static final String KEY_ECLIPSE_THEME = "eclipse";
    public static final String KEY_FLAT_THEME = "flat";
    public static final String KEY_SMOOTH_THEME = "smooth";
    private DockThemeModifier modifier;
    private List<ThemeMapListener> listeners = new ArrayList<ThemeMapListener>();
    private List<Entry> factories = new ArrayList<Entry>();
    private Entry selected;

    public ThemeMap() {
    }

    public ThemeMap(final CControl control) {
        this.init(control);
        this.addThemeMapListener(new ThemeMapListener(){

            @Override
            public void changed(ThemeMap map, int index, String key, ThemeFactory oldFactory, ThemeFactory newFactory) {
            }

            @Override
            public void selectionChanged(ThemeMap map, String oldKey, String newKey) {
                ThemeFactory factory = null;
                if (newKey != null) {
                    factory = ThemeMap.this.getFactory(newKey);
                }
                CBasicTheme theme = factory == null ? new CBasicTheme(control) : factory.create(control.getController());
                if (ThemeMap.this.modifier != null) {
                    theme = ThemeMap.this.modifier.modify(theme);
                }
                control.intern().getController().setTheme((DockTheme)theme);
            }
        });
        try {
            control.getResources().put("dock.ui.ThemeMap", new ApplicationResource(){

                @Override
                public void read(DataInputStream in) throws IOException {
                    Version.read((DataInputStream)in).checkCurrent();
                    if (in.readBoolean()) {
                        ThemeMap.this.select(in.readUTF());
                    } else {
                        ThemeMap.this.select(-1);
                    }
                }

                @Override
                public void readXML(XElement element) {
                    String key = null;
                    XElement xkey = element.getElement("key");
                    if (xkey != null) {
                        key = xkey.getString();
                    }
                    ThemeMap.this.select(key);
                }

                @Override
                public void write(DataOutputStream out) throws IOException {
                    Version.write((DataOutputStream)out, (Version)Version.VERSION_1_0_6);
                    String key = ThemeMap.this.getSelectedKey();
                    if (key == null) {
                        out.writeBoolean(false);
                    } else {
                        out.writeBoolean(true);
                        out.writeUTF(key);
                    }
                }

                @Override
                public void writeXML(XElement element) {
                    String key = ThemeMap.this.getSelectedKey();
                    if (key != null) {
                        element.addElement("key").setString(key);
                    }
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.getSelectedKey() == null) {
            this.select(KEY_BASIC_THEME);
        }
    }

    private void init(CControl control) {
        CDockThemeFactory<FlatTheme> flat = new CDockThemeFactory<FlatTheme>(new ThemePropertyFactory(FlatTheme.class), control){

            @Override
            public DockTheme create(CControl control) {
                return new CFlatTheme(control);
            }
        };
        CDockThemeFactory<BubbleTheme> bubble = new CDockThemeFactory<BubbleTheme>(new ThemePropertyFactory(BubbleTheme.class), control){

            @Override
            public DockTheme create(CControl control) {
                return new CBubbleTheme(control);
            }
        };
        CDockThemeFactory<EclipseTheme> eclipse = new CDockThemeFactory<EclipseTheme>(new ThemePropertyFactory(EclipseTheme.class), control){

            @Override
            public DockTheme create(CControl control) {
                return new CEclipseTheme(control);
            }
        };
        CDockThemeFactory<SmoothTheme> smooth = new CDockThemeFactory<SmoothTheme>(new ThemePropertyFactory(SmoothTheme.class), control){

            @Override
            public DockTheme create(CControl control) {
                return new CSmoothTheme(control);
            }
        };
        CDockThemeFactory<BasicTheme> basic = new CDockThemeFactory<BasicTheme>(new ThemePropertyFactory(BasicTheme.class), control){

            @Override
            public DockTheme create(CControl control) {
                return new CBasicTheme(control);
            }
        };
        this.add(KEY_BASIC_THEME, basic);
        this.add(KEY_SMOOTH_THEME, smooth);
        this.add(KEY_FLAT_THEME, flat);
        this.add(KEY_BUBBLE_THEME, bubble);
        this.add(KEY_ECLIPSE_THEME, eclipse);
    }

    public void addThemeMapListener(ThemeMapListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listeners.add(listener);
    }

    public void removeThemeMapListener(ThemeMapListener listener) {
        this.listeners.remove(listener);
    }

    protected ThemeMapListener[] listeners() {
        return this.listeners.toArray(new ThemeMapListener[this.listeners.size()]);
    }

    public void setModifier(DockThemeModifier modifier) {
        if (this.modifier != modifier) {
            this.modifier = modifier;
            String key = this.getSelectedKey();
            this.select(key, true);
        }
    }

    public DockThemeModifier getModifier() {
        return this.modifier;
    }

    public void select(String key) {
        this.select(key, false);
    }

    public void select(String key, boolean force) {
        if (key == null) {
            this.select(-1, force);
        } else {
            this.select(this.indexOf(key), force);
        }
    }

    public void select(ThemeFactory factory) {
        int index = this.indexOf(factory);
        if (index < 0) {
            throw new IllegalArgumentException("factory not known " + String.valueOf(factory));
        }
        this.select(index);
    }

    public void select(int index) {
        this.select(index, false);
    }

    public void select(int index, boolean force) {
        Entry entry = null;
        if (index >= 0) {
            entry = this.factories.get(index);
        }
        if (entry != this.selected || force) {
            String oldKey = this.selected == null ? null : this.selected.key;
            String newKey = entry == null ? null : entry.key;
            this.selected = entry;
            for (ThemeMapListener listener : this.listeners()) {
                listener.selectionChanged(this, oldKey, newKey);
            }
        }
    }

    public String getSelectedKey() {
        return this.selected == null ? null : this.selected.key;
    }

    public ThemeFactory getSelectedFactory() {
        return this.selected == null ? null : this.selected.factory;
    }

    public int size() {
        return this.factories.size();
    }

    public void put(String key, ThemeFactory factory) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        int index = this.indexOf(key);
        if (index < 0) {
            this.add(key, factory);
        } else {
            Entry entry = this.factories.get(index);
            ThemeFactory old = entry.factory;
            entry.factory = factory;
            for (ThemeMapListener listener : this.listeners()) {
                listener.changed(this, index, key, old, factory);
            }
        }
    }

    public void add(String key, ThemeFactory factory) {
        this.insert(this.size(), key, factory);
    }

    public void insert(int index, String key, ThemeFactory factory) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        if (index < 0 || index > this.factories.size()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int remove = this.indexOf(key);
        if (remove >= 0) {
            this.remove(remove);
            if (index > remove) {
                --index;
            }
        }
        Entry entry = new Entry();
        entry.key = key;
        entry.factory = factory;
        this.factories.add(index, entry);
        for (ThemeMapListener listener : this.listeners()) {
            listener.changed(this, index, key, null, factory);
        }
    }

    public void remove(int index) {
        Entry entry = this.factories.remove(index);
        for (ThemeMapListener listener : this.listeners()) {
            listener.changed(this, index, entry.key, entry.factory, null);
        }
    }

    public boolean remove(String key) {
        int index = this.indexOf(key);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    public int indexOf(ThemeFactory factory) {
        int index = 0;
        for (Entry entry : this.factories) {
            if (entry.factory == factory) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int indexOf(String key) {
        int index = 0;
        for (Entry entry : this.factories) {
            if (entry.key.equals(key)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public String getKey(int index) {
        return this.factories.get((int)index).key;
    }

    public ThemeFactory getFactory(int index) {
        return this.factories.get((int)index).factory;
    }

    public ThemeFactory getFactory(String key) {
        Entry entry = this.getEntry(key);
        if (entry == null) {
            return null;
        }
        return entry.factory;
    }

    private Entry getEntry(String key) {
        for (Entry entry : this.factories) {
            if (!entry.key.equals(key)) continue;
            return entry;
        }
        return null;
    }

    private static class Entry {
        public String key;
        public ThemeFactory factory;

        private Entry() {
        }
    }
}

