/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.SingleCDockableFactory;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.CommonSingleDockableLayout;
import bibliothek.gui.dock.common.intern.DelayedWorkingAreaSetter;
import bibliothek.gui.dock.common.perspective.CPerspective;
import bibliothek.gui.dock.common.perspective.CommonElementPerspective;
import bibliothek.gui.dock.common.perspective.SingleCDockablePerspective;
import bibliothek.gui.dock.layout.LocationEstimationMap;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.util.Filter;
import bibliothek.util.Version;
import bibliothek.util.filter.PresetFilter;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CommonSingleDockableFactory
implements DockFactory<CommonDockable, CommonElementPerspective, CommonSingleDockableLayout> {
    public static final String BACKUP_FACTORY_ID = "ccontrol backup factory id";
    private List<Entry> factories = new ArrayList<Entry>();
    private Map<String, Entry> singleIdFactories = new HashMap<String, Entry>();
    private CControl control;
    private CPerspective perspective;

    public CommonSingleDockableFactory(CControl control) {
        this.control = control;
    }

    public CommonSingleDockableFactory(CControl control, CPerspective perspective) {
        this.control = control;
        this.perspective = perspective;
    }

    public void add(String id, SingleCDockableFactory factory) {
        Entry old = this.singleIdFactories.remove(id);
        if (old != null) {
            this.factories.remove(old);
        }
        Entry entry = new Entry((Filter<String>)new PresetFilter((Object[])new String[]{id}), factory);
        this.factories.add(entry);
        this.singleIdFactories.put(id, entry);
    }

    public void add(Filter<String> ids, SingleCDockableFactory factory) {
        this.factories.add(new Entry(ids, factory));
    }

    public void remove(String id) {
        Entry entry = this.singleIdFactories.remove(id);
        if (entry != null) {
            this.factories.remove(entry);
        }
    }

    public void remove(SingleCDockableFactory factory) {
        Entry next;
        Iterator<Entry> entries = this.factories.iterator();
        while (entries.hasNext()) {
            next = entries.next();
            if (next.factory != factory) continue;
            entries.remove();
        }
        entries = this.singleIdFactories.values().iterator();
        while (entries.hasNext()) {
            next = entries.next();
            if (next.factory != factory) continue;
            entries.remove();
        }
    }

    public SingleCDockableFactory getFactory(String id) {
        Entry entry = this.singleIdFactories.get(id);
        if (entry != null) {
            return entry.factory;
        }
        for (Entry factory : this.factories) {
            if (!factory.filter.includes((Object)id)) continue;
            return factory.factory;
        }
        return null;
    }

    public String getID() {
        return BACKUP_FACTORY_ID;
    }

    public String[] listFactories() {
        Set<String> keys = this.singleIdFactories.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    public Set<String> getFactoryIds() {
        return Collections.unmodifiableSet(this.singleIdFactories.keySet());
    }

    public void estimateLocations(CommonSingleDockableLayout layout, LocationEstimationMap children) {
    }

    public CommonSingleDockableLayout getLayout(CommonDockable element, Map<Dockable, Integer> children) {
        CDockable dockable = element.getDockable();
        if (dockable instanceof SingleCDockable) {
            SingleCDockable single = (SingleCDockable)dockable;
            CommonSingleDockableLayout layout = new CommonSingleDockableLayout();
            layout.setId(single.getUniqueId());
            layout.setArea(single.getWorkingArea() == null ? null : single.getWorkingArea().getUniqueId());
            return layout;
        }
        throw new IllegalArgumentException("A CommonSingleDockableFactory works only with Dockables of type SingleCDockable, but this is not a single dockable: " + String.valueOf(element));
    }

    public CommonDockable layout(CommonSingleDockableLayout layout, Map<Integer, Dockable> children, PlaceholderStrategy placeholders) {
        return this.layout(layout, placeholders);
    }

    public CommonDockable layout(CommonSingleDockableLayout layout, PlaceholderStrategy placeholders) {
        SingleCDockableFactory backup = this.getFactory(layout.getId());
        if (backup == null) {
            return null;
        }
        SingleCDockable dockable = backup.createBackup(layout.getId());
        if (dockable == null) {
            return null;
        }
        String factoryId = dockable.intern().getFactoryID();
        if (!factoryId.equals(this.getID())) {
            throw new IllegalArgumentException("Wrong type of dockable for unique id '" + layout.getId() + "': The backup factory created a dockable which expects a factory with type-id '" + factoryId + "',  but the call was done from a factory with type-id '" + this.getID() + "'");
        }
        this.control.addDockable(dockable);
        if (layout.isAreaSet()) {
            if (layout.getArea() != null) {
                CStation<?> station = this.control.getStation(layout.getArea());
                if (station == null) {
                    DelayedWorkingAreaSetter setter = new DelayedWorkingAreaSetter(layout.getArea(), dockable, this.control);
                    setter.install();
                } else {
                    dockable.setWorkingArea(station);
                }
            } else {
                dockable.setWorkingArea(null);
            }
        }
        return dockable.intern();
    }

    public CommonElementPerspective layoutPerspective(CommonSingleDockableLayout layout, Map<Integer, PerspectiveDockable> children) {
        SingleCDockablePerspective dockable = new SingleCDockablePerspective(layout.getId());
        if (layout.isAreaSet() && layout.getArea() != null) {
            dockable.setWorkingArea(this.perspective.getStation(layout.getArea()));
        }
        return dockable.intern();
    }

    public void layoutPerspective(CommonElementPerspective perspective, CommonSingleDockableLayout layout, Map<Integer, PerspectiveDockable> children) {
    }

    public CommonSingleDockableLayout getPerspectiveLayout(CommonElementPerspective element, Map<PerspectiveDockable, Integer> children) {
        SingleCDockablePerspective dockable = (SingleCDockablePerspective)element.getElement();
        CommonSingleDockableLayout layout = new CommonSingleDockableLayout();
        layout.setId(dockable.getUniqueId());
        layout.setArea(dockable.getWorkingArea() == null ? null : dockable.getWorkingArea().getUniqueId());
        return layout;
    }

    public CommonSingleDockableLayout read(DataInputStream in, PlaceholderStrategy placeholders) throws IOException {
        Version version = Version.read((DataInputStream)in);
        CommonSingleDockableLayout layout = new CommonSingleDockableLayout();
        if (version.equals((Object)Version.VERSION_1_0_4)) {
            layout.setId(in.readUTF());
        } else if (version.equals((Object)Version.VERSION_1_1_0)) {
            layout.setId(in.readUTF());
            layout.setArea(in.readUTF());
        } else if (version.equals((Object)Version.VERSION_1_1_0a)) {
            layout.setId(in.readUTF());
            if (in.readBoolean()) {
                layout.setArea(in.readUTF());
            } else {
                layout.setArea(null);
            }
        } else {
            throw new IOException("Data from the future - unknown version: " + String.valueOf(version));
        }
        return layout;
    }

    public CommonSingleDockableLayout read(XElement element, PlaceholderStrategy placeholders) {
        CommonSingleDockableLayout layout = new CommonSingleDockableLayout();
        layout.setId(element.getElement("id").getString());
        XElement xarea = element.getElement("area");
        if (xarea != null) {
            String area = xarea.getString();
            if ("".equals(area)) {
                layout.setArea(null);
            } else {
                layout.setArea(area);
            }
        }
        return layout;
    }

    public void setLayout(CommonDockable element, CommonSingleDockableLayout layout, Map<Integer, Dockable> children, PlaceholderStrategy placeholders) {
    }

    public void setLayout(CommonDockable element, CommonSingleDockableLayout layout, PlaceholderStrategy placeholders) {
    }

    public void write(CommonSingleDockableLayout layout, DataOutputStream out) throws IOException {
        Version.write((DataOutputStream)out, (Version)Version.VERSION_1_1_0a);
        out.writeUTF(layout.getId());
        String area = layout.getArea();
        if (area == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(area);
        }
    }

    public void write(CommonSingleDockableLayout layout, XElement element) {
        element.addElement("id").setString(layout.getId());
        XElement xarea = element.addElement("area");
        if (layout.getArea() != null) {
            xarea.setString(layout.getArea());
        }
    }

    private static class Entry {
        public final Filter<String> filter;
        public final SingleCDockableFactory factory;

        public Entry(Filter<String> filter, SingleCDockableFactory factory) {
            if (filter == null) {
                throw new IllegalArgumentException("filter must not be null");
            }
            if (factory == null) {
                throw new IllegalArgumentException("factory must not be null");
            }
            this.filter = filter;
            this.factory = factory;
        }
    }
}

