/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common;

import bibliothek.gui.dock.common.event.FontMapListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.util.font.ConstantFontModifier;
import bibliothek.gui.dock.util.font.FontModifier;
import bibliothek.gui.dock.util.font.GenericFontModifier;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FontMap {
    public static final String FONT_KEY_TITLE = "dock.title";
    public static final String FONT_KEY_TITLE_FOCUSED = "dock.title.focused";
    public static final String FONT_KEY_MINIMIZED_BUTTON = "dock.minimized";
    public static final String FONT_KEY_MINIMIZED_BUTTON_FOCUSED = "dock.minimized.focused";
    public static final String FONT_KEY_TAB = "dock.tab";
    public static final String FONT_KEY_TAB_SELECTED = "dock.tab.selected";
    public static final String FONT_KEY_TAB_FOCUSED = "dock.tab.focused";
    private Map<String, FontModifier> fonts = new HashMap<String, FontModifier>();
    private List<FontMapListener> listeners = new ArrayList<FontMapListener>();
    private CDockable dockable;

    public FontMap(CDockable dockable) {
        if (dockable == null) {
            throw new IllegalArgumentException("Dockable must not be null");
        }
        this.dockable = dockable;
    }

    public CDockable getDockable() {
        return this.dockable;
    }

    public void addListener(FontMapListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.listeners.add(listener);
    }

    public void removeListener(FontMapListener listener) {
        this.listeners.remove(listener);
    }

    public FontModifier getFont(String key) {
        return this.fonts.get(key);
    }

    public void setFont(String key, Font font) {
        if (font == null) {
            this.setFont(key, (FontModifier)null);
        } else {
            this.setFont(key, (FontModifier)new ConstantFontModifier(font));
        }
    }

    public void setFont(String key, String ... modifications) {
        if (modifications.length == 0) {
            this.setFont(key, (FontModifier)null);
        } else {
            GenericFontModifier modifier = new GenericFontModifier();
            for (String modification : modifications) {
                String[] entry = this.split(modification);
                String entryKey = entry[0];
                String entryValue = entry[1];
                boolean italic = "i".equals(entryKey);
                boolean bold = "b".equals(entryKey);
                boolean size = "s".equals(entryKey);
                if (italic || bold) {
                    GenericFontModifier.Modify modify;
                    if ("+".equals(entryValue)) {
                        modify = GenericFontModifier.Modify.ON;
                    } else if ("-".equals(entryValue)) {
                        modify = GenericFontModifier.Modify.OFF;
                    } else if ("!".equals(entryValue)) {
                        modify = GenericFontModifier.Modify.REVERSE;
                    } else {
                        throw new IllegalArgumentException("illegal value, must be one of '+', '-' or '!': " + modification);
                    }
                    if (italic) {
                        modifier.setItalic(modify);
                        continue;
                    }
                    modifier.setBold(modify);
                    continue;
                }
                if (size) {
                    String number;
                    if (entryValue.startsWith("+")) {
                        modifier.setSizeDelta(true);
                        number = entryValue.substring(1).trim();
                    } else if (entryValue.startsWith("-")) {
                        modifier.setSizeDelta(true);
                        number = entryValue.substring(1).trim();
                    } else {
                        modifier.setSizeDelta(false);
                        number = entryValue;
                    }
                    int parsed = Integer.parseInt(number);
                    if (entryValue.startsWith("-")) {
                        parsed = -parsed;
                    }
                    modifier.setSize(parsed);
                    continue;
                }
                throw new IllegalArgumentException("unknown key: " + modification);
            }
            this.setFont(key, (FontModifier)modifier);
        }
    }

    private String[] split(String modification) {
        int index = modification.indexOf(61);
        if (index < 0) {
            throw new IllegalArgumentException("not in the form 'key'='value': " + modification);
        }
        String key = modification.substring(0, index);
        String value = modification.substring(index + 1);
        key = key.trim();
        value = value.trim();
        if (key.length() == 0) {
            throw new IllegalArgumentException("missing key in: " + modification);
        }
        if (value.length() == 0) {
            throw new IllegalArgumentException("missing value in: " + modification);
        }
        return new String[]{key, value};
    }

    public void removeFont(String key) {
        this.setFont(key, (FontModifier)null);
    }

    public void setFont(String key, FontModifier font) {
        FontModifier old = font == null ? this.fonts.remove(key) : this.fonts.put(key, font);
        if (old == null && font != null || old != null && !old.equals((Object)font)) {
            for (FontMapListener listener : this.listeners.toArray(new FontMapListener[this.listeners.size()])) {
                listener.fontChanged(this, key, font);
            }
        }
    }
}

