/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb1.maven2;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JPackage;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Driver;
import com.sun.tools.xjc.ErrorReceiver;
import com.sun.tools.xjc.GrammarLoader;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.grammar.AnnotatedGrammar;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.jvnet.jaxb1.maven2.XJC1MojoClassLoader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractXJC1Mojo
extends AbstractMojo {
    protected List schemaFiles = new ArrayList();
    protected List bindingFiles = new ArrayList();

    protected void executeImp() throws MojoExecutionException {
        try {
            this.setupLogging();
            Options xjcOpts = this.setupOptions();
            if (this.isVerbose()) {
                this.logSettings();
            }
            this.updateMavenPaths();
            if (!this.isForceRegenerate() && this.isUpdToDate()) {
                this.getLog().info((CharSequence)"Skipped XJC execution.  Generated sources were up-to-date.");
                return;
            }
            if (this.isRemoveOldOutput()) {
                if (this.getGenerateDirectory().exists()) {
                    try {
                        FileUtils.deleteDirectory((File)this.getGenerateDirectory());
                        this.getLog().info((CharSequence)("Removed old generateDirectory '" + this.getGenerateDirectory() + "'."));
                    }
                    catch (IOException ex) {
                        this.getLog().warn((CharSequence)("Failed to remove old generateDirectory '" + this.getGenerateDirectory() + "' due to: " + ex));
                    }
                } else if (this.isVerbose()) {
                    this.getLog().info((CharSequence)("Skipped removal of old generateDirectory '" + this.getGenerateDirectory() + "' since it didn't exist."));
                }
            }
            if (this.isWriteCode() && this.getGenerateDirectory() != null && !this.getGenerateDirectory().exists()) {
                this.getGenerateDirectory().mkdirs();
            }
            ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getProjectDepsClassLoader(oldCL));
            try {
                this.runXJC(xjcOpts);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
            this.getLog().info((CharSequence)("Succesfully generated output to: " + xjcOpts.targetDir));
        }
        catch (RuntimeException ex) {
            this.getLog().info((CharSequence)"Mojo options will be logged due to an unexpected error...");
            this.logSettings();
            throw ex;
        }
        catch (MojoExecutionException ex) {
            throw ex;
        }
    }

    protected Options setupOptions() throws MojoExecutionException {
        Options xjcOpts = new Options();
        xjcOpts.verbose = this.isVerbose();
        xjcOpts.debugMode = this.isDebug();
        if (!AbstractXJC1Mojo.isDefined(this.getSchemaLanguage(), 1)) {
            this.setSchemaLanguage("AUTODETECT");
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)"The <schemaLanguage> setting was not defined, assuming 'AUTODETECT'.");
            }
        } else if (!"AUTODETECT".equalsIgnoreCase(this.getSchemaLanguage())) {
            if ("XMLSCHEMA".equalsIgnoreCase(this.getSchemaLanguage())) {
                xjcOpts.setSchemaLanguage(1);
            } else if ("DTD".equalsIgnoreCase(this.getSchemaLanguage())) {
                xjcOpts.setSchemaLanguage(0);
            } else if ("RELAXNG".equalsIgnoreCase(this.getSchemaLanguage())) {
                xjcOpts.setSchemaLanguage(2);
            } else if ("WSDL".equalsIgnoreCase(this.getSchemaLanguage())) {
                xjcOpts.setSchemaLanguage(3);
            } else {
                this.logSettings();
                throw new MojoExecutionException("Unknown <schemaLanguage> '" + this.getSchemaLanguage() + "'!");
            }
        }
        List files = this.gatherFiles(this.getSchemaDirectory(), this.getSchemaIncludes(), this.getSchemasExcludes());
        Iterator it = files.iterator();
        while (it.hasNext()) {
            xjcOpts.addGrammar(AbstractXJC1Mojo.getInputSource((File)it.next()));
        }
        this.schemaFiles.addAll(files);
        if (this.schemaFiles.size() == 0) {
            this.logSettings();
            throw new MojoExecutionException("No schemas found inside the <schemaDirectory> '" + this.getSchemaDirectory() + "'!");
        }
        if (!AbstractXJC1Mojo.isDefined(this.getBindingDirectory(), 1)) {
            this.setBindingDirectory(this.getSchemaDirectory());
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("The <bindingDirectory> setting was not defined, assuming the same as <schemaDirectory>: " + this.getSchemaDirectory()));
            }
        }
        files = this.gatherFiles(this.getBindingDirectory(), this.getBindingIncludes(), this.getBindingExcludes());
        it = files.iterator();
        while (it.hasNext()) {
            xjcOpts.addBindFile(AbstractXJC1Mojo.getInputSource((File)it.next()));
        }
        this.bindingFiles.addAll(files);
        if (AbstractXJC1Mojo.isDefined(this.getCatalog(), 1)) {
            try {
                xjcOpts.addCatalog(this.getCatalog());
            }
            catch (IOException ex) {
                this.logSettings();
                throw new MojoExecutionException("Error while setting the <catalog> to '" + this.getCatalog() + "'!", (Exception)ex);
            }
        }
        xjcOpts.defaultPackage = this.getGeneratePackage();
        xjcOpts.targetDir = this.getGenerateDirectory();
        if (AbstractXJC1Mojo.isDefined(this.getRuntimePackage(), 1)) {
            xjcOpts.generateRuntime = false;
            xjcOpts.runtimePackage = this.getRuntimePackage();
        }
        xjcOpts.traceUnmarshaller = this.isTraceUnmarshaller();
        xjcOpts.generateMarshallingCode = this.isGenerateMarshallingCode();
        xjcOpts.generateUnmarshallingCode = this.isGenerateUnmarshallingCode();
        xjcOpts.generateValidationCode = this.isGenerateValidationCode();
        xjcOpts.strictCheck = this.isStrict();
        xjcOpts.readOnly = this.isReadOnly();
        if (this.isExtension()) {
            xjcOpts.compatibilityMode = 2;
        }
        this.setupCmdLineArgs(xjcOpts);
        return xjcOpts;
    }

    protected void setupCmdLineArgs(Options xjcOpts) throws MojoExecutionException {
        if (AbstractXJC1Mojo.isDefined(this.getArgs(), 1)) {
            try {
                xjcOpts.parseArguments(this.getArgs().toArray(new String[this.getArgs().size()]));
            }
            catch (BadCommandLineException ex) {
                throw new MojoExecutionException("Error while setting CmdLine <args> options '" + this.getArgs() + "'!", (Exception)((Object)ex));
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Error while setting CmdLine <args> options '" + this.getArgs() + "'!", (Exception)ex);
            }
        }
    }

    protected void setupLogging() {
        Log log = this.getLog();
        if (log.isDebugEnabled()) {
            this.setDebug(true);
        }
        if (this.isDebug()) {
            this.setVerbose(true);
            System.setProperty("com.sun.tools.xjc.Options.findServices", "true");
        }
    }

    protected void logSettings() {
        StringBuffer sb = new StringBuffer();
        sb.append("Plugin's mojo parameters: ");
        this.logUserSettings(sb);
        sb.append("\nCalculated options: ");
        this.logCalcSettings(sb);
        this.getLog().info((CharSequence)sb);
    }

    protected void logUserSettings(StringBuffer sb) {
        sb.append("\n\tschemaLanguage: " + this.getSchemaLanguage());
        sb.append("\n\tschemaDirectory: " + this.getSchemaDirectory());
        sb.append("\n\tincludeSchemas: " + AbstractXJC1Mojo.recursiveToString(this.getSchemaIncludes()));
        sb.append("\n\texcludeSchemas: " + AbstractXJC1Mojo.recursiveToString(this.getSchemasExcludes()));
        sb.append("\n\tbindingDirectory: " + this.getBindingDirectory());
        sb.append("\n\tincludeBindings: " + AbstractXJC1Mojo.recursiveToString(this.getBindingIncludes()));
        sb.append("\n\texcludeBindings: " + AbstractXJC1Mojo.recursiveToString(this.getBindingExcludes()));
        sb.append("\n\tdisableDefaultExcludes: " + this.isDisableDefaultExcludes());
        sb.append("\n\tcatalog: " + this.getCatalog());
        sb.append("\n\truntimePackage: " + this.getRuntimePackage());
        sb.append("\n\tgeneratePackage: " + this.getGeneratePackage());
        sb.append("\n\tgenerateDirectory: " + this.getGenerateDirectory());
        sb.append("\n\taddToTestSources: " + this.isAddToTestSources());
        sb.append("\n\tforceRegenerate: " + this.isForceRegenerate());
        sb.append("\n\totherDepends: " + AbstractXJC1Mojo.recursiveToString(this.getOtherDepends()));
        sb.append("\n\tremoveOldOutput: " + this.isRemoveOldOutput());
        sb.append("\n\ttraceUnmarshaller: " + this.isTraceUnmarshaller());
        sb.append("\n\twriteCode: " + this.isWriteCode());
        sb.append("\n\tgenerateValidationCode: " + this.isGenerateValidationCode());
        sb.append("\n\tgenerateMarshallingCode: " + this.isGenerateMarshallingCode());
        sb.append("\n\tgenerateUnmarshallingCode: " + this.isGenerateUnmarshallingCode());
        sb.append("\n\treadOnly: " + this.isReadOnly());
        sb.append("\n\textension: " + this.isExtension());
        sb.append("\n\tstrict: " + this.isStrict());
        sb.append("\n\tverbose: " + this.isVerbose());
        sb.append("\n\tdebug: " + this.isDebug());
        sb.append("\n\txjcArgs: " + AbstractXJC1Mojo.recursiveToString(this.getArgs()));
    }

    protected void logCalcSettings(StringBuffer sb) {
        sb.append("\n\tSchema File(s): " + AbstractXJC1Mojo.recursiveToString(this.schemaFiles));
        sb.append("\n\tBinding File(s): " + AbstractXJC1Mojo.recursiveToString(this.bindingFiles));
        sb.append("\n\tClassPath: " + AbstractXJC1Mojo.recursiveToString(this.getClasspathElements()));
    }

    protected boolean isUpdToDate() throws MojoExecutionException {
        ArrayList dependsFiles = new ArrayList();
        ArrayList producesFiles = new ArrayList();
        this.gatherDependsFiles(dependsFiles);
        if (this.isVerbose() && !this.isDebug()) {
            this.getLog().info((CharSequence)("Checking up-to-date depends: " + AbstractXJC1Mojo.recursiveToString(dependsFiles)));
        }
        this.gatherProducesFiles(producesFiles);
        if (this.isVerbose() && !this.isDebug()) {
            this.getLog().info((CharSequence)("Checking up-to-date produces: " + AbstractXJC1Mojo.recursiveToString(producesFiles)));
        }
        long inputTimeStamp = this.findLastModified(dependsFiles, true);
        long destTimeStamp = this.findLastModified(producesFiles, false);
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Depends timeStamp: " + inputTimeStamp + ", produces timestamp: " + destTimeStamp));
        }
        return inputTimeStamp < destTimeStamp;
    }

    protected void gatherDependsFiles(List inputFiles) {
        inputFiles.addAll(this.schemaFiles);
        inputFiles.addAll(this.bindingFiles);
        if (this.getCatalog() != null) {
            inputFiles.add(this.getCatalog());
        }
        if (this.getProject() != null) {
            inputFiles.add(this.getProject().getFile());
        }
        if (this.getOtherDepends() != null) {
            inputFiles.addAll(Arrays.asList(this.getOtherDepends()));
        }
    }

    protected void gatherProducesFiles(List destFiles) throws MojoExecutionException {
        if (this.getGenerateDirectory().exists()) {
            if (!this.getGenerateDirectory().isDirectory()) {
                this.getLog().warn((CharSequence)("The <generateDirectory>='" + this.getGenerateDirectory() + "' is not a directory!  Probably XJC will fail..."));
            } else {
                destFiles.addAll(this.gatherFiles(this.getGenerateDirectory(), new String[]{"**/*.java", "**/bgm.ser", "**/jaxb.properties"}, null));
            }
        }
    }

    private ClassLoader getProjectDepsClassLoader(ClassLoader parent) {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (this.getClasspathElements() != null) {
            Iterator it = this.getClasspathElements().iterator();
            while (it.hasNext()) {
                String pathElem = (String)it.next();
                try {
                    urls.add(new File(pathElem).toURL());
                }
                catch (MalformedURLException e) {
                    this.getLog().warn((CharSequence)("Internal classpath element '" + pathElem + "' is was skiped due to: " + AbstractXJC1Mojo.getAllExMsgs(e, true)));
                }
            }
        }
        XJC1MojoClassLoader cl = new XJC1MojoClassLoader(urls.toArray(new URL[urls.size()]), parent);
        return cl;
    }

    protected void runXJC(Options xjcOpts) throws MojoExecutionException {
        AnnotatedGrammar grammar;
        JaxbErrorReceiver4Mvn errorReceiver = new JaxbErrorReceiver4Mvn();
        try {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)"Parsing input schema(s)...");
            }
            errorReceiver.stage = "parsing";
            grammar = GrammarLoader.load((Options)xjcOpts, (ErrorReceiver)errorReceiver);
            if (grammar == null) {
                throw new MojoExecutionException("Unable to parse input schema(s).  Error messages should have been provided.");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read input schema file(s): " + e.getMessage(), (Exception)e);
        }
        catch (SAXException e) {
            throw new MojoExecutionException("SAX failed to parse input schema(s)", (Exception)e);
        }
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)"Compiling input schema(s)...");
        }
        errorReceiver.stage = "compiling";
        if (Driver.generateCode((AnnotatedGrammar)grammar, (Options)xjcOpts, (ErrorReceiver)errorReceiver) == null) {
            throw new MojoExecutionException("Failed to compile input schema(s)!  Error messages should have been provided.");
        }
        if (this.isWriteCode()) {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Writing output to: " + xjcOpts.targetDir));
            }
            try {
                grammar.codeModel.build((CodeWriter)new JaxbCodeWriter4Mvn(Driver.createCodeWriter((File)xjcOpts.targetDir, (boolean)xjcOpts.readOnly)));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to write files: " + e.getMessage(), (Exception)e);
            }
        } else {
            this.getLog().info((CharSequence)"Code will not be written.");
        }
    }

    protected void updateMavenPaths() {
        if (this.getProject() != null) {
            if (this.isAddToTestSources()) {
                this.getProject().addTestCompileSourceRoot(this.getGenerateDirectory().getPath());
            } else {
                this.getProject().addCompileSourceRoot(this.getGenerateDirectory().getPath());
            }
        }
        Resource jaxbRes = new Resource();
        jaxbRes.setDirectory(this.getGenerateDirectory().getPath());
        jaxbRes.addInclude("**/jaxb.properties");
        jaxbRes.addInclude("**/bgm.ser");
        if (this.getProject() != null) {
            if (this.isAddToTestSources()) {
                this.getProject().addTestResource(jaxbRes);
            } else {
                this.getProject().addResource(jaxbRes);
            }
        }
    }

    protected long findLastModified(List files, boolean oldest) {
        long timeStamp = oldest ? Long.MIN_VALUE : Long.MAX_VALUE;
        Iterator it = files.iterator();
        while (it.hasNext()) {
            long fileModifTime;
            Object no = it.next();
            if (no == null) continue;
            if (no instanceof String) {
                String sdep = (String)no;
                try {
                    URL url = new URL(sdep);
                    URLConnection uCon = url.openConnection();
                    uCon.setUseCaches(false);
                    fileModifTime = uCon.getLastModified();
                }
                catch (MalformedURLException e) {
                    fileModifTime = new File(sdep).lastModified();
                }
                catch (IOException ex) {
                    fileModifTime = oldest ? Long.MIN_VALUE : Long.MAX_VALUE;
                    this.getLog().warn((CharSequence)("Skipping URL '" + no + "' from up-to-date check due to error while opening connection: " + AbstractXJC1Mojo.getAllExMsgs(ex, true)));
                }
            } else {
                fileModifTime = ((File)no).lastModified();
            }
            if (this.isDebug()) {
                this.getLog().info((CharSequence)(String.valueOf(oldest ? "Depends " : "Produces ") + no + ": " + new Date(fileModifTime)));
            }
            if (!(fileModifTime > timeStamp ^ !oldest)) continue;
            timeStamp = fileModifTime;
        }
        if (timeStamp == Long.MIN_VALUE) {
            return Long.MAX_VALUE;
        }
        if (timeStamp == Long.MAX_VALUE) {
            return Long.MIN_VALUE;
        }
        return timeStamp;
    }

    protected static InputSource getInputSource(File f) {
        try {
            return new InputSource(f.toURL().toExternalForm());
        }
        catch (MalformedURLException e) {
            return new InputSource(f.getPath());
        }
    }

    protected List gatherFiles(File baseDir, String[] includesPattern, String[] excludesPattern) throws MojoExecutionException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(baseDir.getAbsoluteFile());
        scanner.setIncludes(includesPattern);
        scanner.setExcludes(this.getExcludes(excludesPattern));
        scanner.scan();
        ArrayList<File> files = new ArrayList<File>();
        String[] incFiles = scanner.getIncludedFiles();
        int i = 0;
        while (i < incFiles.length) {
            String name = incFiles[i];
            try {
                File file = new File(baseDir, name);
                files.add(file.getCanonicalFile());
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Unable to canonize the file [" + name + "]");
            }
            ++i;
        }
        return files;
    }

    protected String[] getExcludes(String[] origExcludes) {
        if (origExcludes == null) {
            return null;
        }
        List newExc = this.getExcludes(Arrays.asList(origExcludes));
        return newExc.toArray(new String[newExc.size()]);
    }

    protected List getExcludes(List origExcludes) {
        if (origExcludes == null || this.isDisableDefaultExcludes()) {
            return origExcludes;
        }
        origExcludes.addAll(Arrays.asList(FileUtils.getDefaultExcludes()));
        return origExcludes;
    }

    protected static boolean isDefined(Object setting, int minimumLength) {
        boolean defined;
        boolean bl = defined = setting != null;
        defined = setting instanceof Object[] ? defined && ((Object[])setting).length >= minimumLength : (setting instanceof Collection ? defined && ((Collection)setting).size() >= minimumLength : defined && setting.toString().trim().length() >= minimumLength);
        return defined;
    }

    protected static String recursiveToString(Object setting) {
        if (setting == null) {
            return "null";
        }
        if (setting instanceof Collection) {
            Collection collection = (Collection)setting;
            setting = collection.toArray();
        }
        if (setting instanceof Object[]) {
            Object[] settingArray = setting;
            if (settingArray.length == 0) {
                return "[]";
            }
            StringBuffer result = new StringBuffer();
            result.append('[');
            result.append(AbstractXJC1Mojo.recursiveToString(settingArray[0]));
            int index = 1;
            while (index < settingArray.length) {
                result.append(", ");
                result.append(AbstractXJC1Mojo.recursiveToString(settingArray[index]));
                ++index;
            }
            result.append(']');
            return result.toString();
        }
        return setting.toString();
    }

    public static String getAllExMsgs(Throwable ex, boolean includeExName) {
        Exception embeded;
        StringBuffer sb = new StringBuffer(includeExName ? ex.toString() : ex.getLocalizedMessage());
        Throwable cause = ex.getCause();
        Exception exception = embeded = ex instanceof SAXParseException ? ((SAXParseException)ex).getException() : null;
        if (cause == embeded && cause != null || cause != null) {
            AbstractXJC1Mojo.getAllCauseExMsgs(cause, includeExName, sb);
        } else if (embeded != null) {
            AbstractXJC1Mojo.getAllCauseExMsgs(embeded, includeExName, sb);
        }
        return sb.toString();
    }

    private static void getAllCauseExMsgs(Throwable ex, boolean includeExName, StringBuffer sb) {
        do {
            sb.append("\nCaused by: " + (includeExName ? ex.toString() : ex.getLocalizedMessage()));
        } while ((ex = ex.getCause()) != null);
    }

    public static String getAllExStackTraces(Throwable ex) {
        throw new Error("Unresolved compilation problem: \n\tThe method append(String) is undefined for the type PrintWriter\n");
    }

    protected abstract void setSchemaLanguage(String var1);

    protected abstract String getSchemaLanguage();

    protected abstract void setSchemaDirectory(File var1);

    protected abstract File getSchemaDirectory();

    protected abstract void setSchemaIncludes(String[] var1);

    protected abstract String[] getSchemaIncludes();

    protected abstract void setSchemasExcludes(String[] var1);

    protected abstract String[] getSchemasExcludes();

    protected abstract void setBindingDirectory(File var1);

    protected abstract File getBindingDirectory();

    protected abstract void setBindingIncludes(String[] var1);

    protected abstract String[] getBindingIncludes();

    protected abstract void setBindingExcludes(String[] var1);

    protected abstract String[] getBindingExcludes();

    protected abstract void setDisableDefaultExcludes(boolean var1);

    protected abstract boolean isDisableDefaultExcludes();

    protected abstract void setCatalog(File var1);

    protected abstract File getCatalog();

    protected abstract void setGeneratePackage(String var1);

    protected abstract String getGeneratePackage();

    protected abstract void setGenerateDirectory(File var1);

    protected abstract File getGenerateDirectory();

    protected abstract void setAddToTestSources(boolean var1);

    protected abstract boolean isAddToTestSources();

    protected abstract void setReadOnly(boolean var1);

    protected abstract boolean isReadOnly();

    protected abstract void setExtension(boolean var1);

    protected abstract boolean isExtension();

    protected abstract void setStrict(boolean var1);

    protected abstract boolean isStrict();

    protected abstract void setWriteCode(boolean var1);

    protected abstract boolean isWriteCode();

    protected abstract void setTraceUnmarshaller(boolean var1);

    protected abstract boolean isTraceUnmarshaller();

    protected abstract void setGenerateValidationCode(boolean var1);

    protected abstract boolean isGenerateValidationCode();

    protected abstract void setGenerateMarshallingCode(boolean var1);

    protected abstract boolean isGenerateMarshallingCode();

    protected abstract void setGenerateUnmarshallingCode(boolean var1);

    protected abstract boolean isGenerateUnmarshallingCode();

    protected abstract void setRuntimePackage(String var1);

    protected abstract String getRuntimePackage();

    protected abstract void setVerbose(boolean var1);

    protected abstract boolean isVerbose();

    protected abstract void setDebug(boolean var1);

    protected abstract boolean isDebug();

    protected abstract void setArgs(List var1);

    protected abstract List getArgs();

    protected abstract void setForceRegenerate(boolean var1);

    protected abstract boolean isForceRegenerate();

    protected abstract void setRemoveOldOutput(boolean var1);

    protected abstract boolean isRemoveOldOutput();

    protected abstract void setOtherDepends(String[] var1);

    protected abstract String[] getOtherDepends();

    protected abstract List getClasspathElements();

    protected abstract MavenProject getProject();

    protected class JaxbErrorReceiver4Mvn
    extends ErrorReceiver {
        public String stage = "processing";

        protected JaxbErrorReceiver4Mvn() {
        }

        public void warning(SAXParseException e) {
            AbstractXJC1Mojo.this.getLog().warn((CharSequence)this.makeMessage(e, true));
        }

        public void error(SAXParseException e) {
            AbstractXJC1Mojo.this.getLog().error((CharSequence)this.makeMessage(e, true));
        }

        public void fatalError(SAXParseException e) {
            AbstractXJC1Mojo.this.getLog().error((CharSequence)this.makeMessage(e, true));
        }

        public void info(SAXParseException e) {
            if (AbstractXJC1Mojo.this.isVerbose()) {
                AbstractXJC1Mojo.this.getLog().info((CharSequence)this.makeMessage(e, false));
            }
        }

        private String makeMessage(SAXParseException ex, boolean printExName) {
            int row = ex.getLineNumber();
            int col = ex.getColumnNumber();
            String sys = ex.getSystemId();
            String pub = ex.getPublicId();
            String exString = AbstractXJC1Mojo.this.isDebug() ? AbstractXJC1Mojo.getAllExStackTraces(ex) : AbstractXJC1Mojo.getAllExMsgs(ex, printExName);
            return "XJC while " + this.stage + " schema(s)" + (sys != null ? " " + sys : "") + (pub != null ? " " + pub : "") + (row > 0 ? "[" + row + (col > 0 ? "," + col : "") + "]" : "") + ": " + exString;
        }
    }

    private class JaxbCodeWriter4Mvn
    implements CodeWriter {
        private final CodeWriter output;

        public JaxbCodeWriter4Mvn(CodeWriter output) {
            this.output = output;
        }

        public OutputStream open(JPackage pkg, String fileName) throws IOException {
            if (AbstractXJC1Mojo.this.isVerbose()) {
                if (pkg.isUnnamed()) {
                    AbstractXJC1Mojo.this.getLog().info((CharSequence)("XJC writing: " + fileName));
                } else {
                    AbstractXJC1Mojo.this.getLog().info((CharSequence)("XJC writing: " + pkg.name().replace('.', File.separatorChar) + File.separatorChar + fileName));
                }
            }
            return this.output.open(pkg, fileName);
        }

        public void close() throws IOException {
            this.output.close();
        }
    }
}

