/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.plugin.removexmlannotation;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JPackage;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.CElementInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.ElementOutline;
import com.sun.tools.xjc.outline.EnumConstantOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.jvnet.jaxb.plugin.AbstractPlugin;
import org.jvnet.jaxb.plugin.AnnotationTarget;
import org.xml.sax.ErrorHandler;

public class RemoveXmlAnnotationPlugin
extends AbstractPlugin {
    private boolean removeObjectFactory = false;
    private static final String OPTION_NAME = "XremoveXmlAnnotation";
    private static final String OPTION_NAME_REMOVE_OBJECT_FACTORY = "-XremoveXmlAnnotation:removeObjectFactory";

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return "Remove all jakarta.xml.bind / javax.xml.bind annotation on classes generated";
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) {
        for (CElementInfo elementInfo : outline.getModel().getAllElements()) {
            ElementOutline elementOutline = outline.getElement(elementInfo);
            if (elementOutline == null) continue;
            this.processElementOutline(elementOutline, options, errorHandler);
        }
        for (ClassOutline classOutline : outline.getClasses()) {
            this.processClassOutline(classOutline, options, errorHandler);
        }
        for (EnumOutline enumOutline : outline.getEnums()) {
            this.processEnumOutline(enumOutline, options, errorHandler);
        }
        if (this.removeObjectFactory) {
            outline.getCodeModel().packages().forEachRemaining(new Consumer<JPackage>(){

                @Override
                public void accept(JPackage jPackage) {
                    JDefinedClass jDefinedClass;
                    if (jPackage.hasClasses() && (jDefinedClass = jPackage._getClass("ObjectFactory")) != null) {
                        jPackage.remove((JClass)jDefinedClass);
                    }
                }
            });
        }
        return true;
    }

    protected void processElementOutline(ElementOutline elementOutline, Options options, ErrorHandler errorHandler) {
        try {
            JAnnotatable annotatable = AnnotationTarget.ELEMENT.getAnnotatable(elementOutline.parent(), elementOutline);
            this.removeXmlAnnotation(errorHandler, annotatable);
        }
        catch (IllegalArgumentException iaex) {
            this.logger.error((Object)"Error removing the annotation.", (Throwable)iaex);
        }
    }

    protected void processEnumOutline(EnumOutline enumOutline, Options options, ErrorHandler errorHandler) {
        try {
            JAnnotatable annotatable = AnnotationTarget.ENUM.getAnnotatable(enumOutline.parent(), enumOutline);
            this.removeXmlAnnotation(errorHandler, annotatable);
        }
        catch (IllegalArgumentException iaex) {
            this.logger.error((Object)"Error applying the annotation.", (Throwable)iaex);
        }
        for (EnumConstantOutline enumConstantOutline : enumOutline.constants) {
            this.processEnumConstantOutline(enumOutline, enumConstantOutline, options, errorHandler);
        }
    }

    protected void processClassOutline(ClassOutline classOutline, Options options, ErrorHandler errorHandler) {
        try {
            JAnnotatable annotatable = AnnotationTarget.CLASS.getAnnotatable(classOutline.parent(), classOutline);
            this.removeXmlAnnotation(errorHandler, annotatable);
        }
        catch (IllegalArgumentException iaex) {
            this.logger.error((Object)"Error applying the annotation.", (Throwable)iaex);
        }
        for (FieldOutline fieldOutline : classOutline.getDeclaredFields()) {
            this.processFieldOutline(classOutline, fieldOutline, options, errorHandler);
        }
    }

    protected void processFieldOutline(ClassOutline classOutline, FieldOutline fieldOutline, Options options, ErrorHandler errorHandler) {
        try {
            JAnnotatable annotatable = AnnotationTarget.PROPERTY_FIELD.getAnnotatable(fieldOutline.parent().parent(), fieldOutline);
            this.removeXmlAnnotation(errorHandler, annotatable);
        }
        catch (IllegalArgumentException iaex) {
            this.logger.error((Object)"Error removing the annotation.", (Throwable)iaex);
        }
    }

    protected void processEnumConstantOutline(EnumOutline enumOutline, EnumConstantOutline enumConstantOutline, Options options, ErrorHandler errorHandler) {
        try {
            JAnnotatable annotatable = AnnotationTarget.ENUM_CONSTANT.getAnnotatable(enumOutline.parent(), enumConstantOutline);
            this.removeXmlAnnotation(errorHandler, annotatable);
        }
        catch (IllegalArgumentException iaex) {
            this.logger.error((Object)"Error removing the annotation.", (Throwable)iaex);
        }
    }

    private void removeXmlAnnotation(ErrorHandler errorHandler, JAnnotatable annotatable) {
        ArrayList<JAnnotationUse> annotationsToRemove = new ArrayList<JAnnotationUse>();
        for (JAnnotationUse annotation : annotatable.annotations()) {
            String packageName = annotation.getAnnotationClass()._package().name();
            if (packageName == null) continue;
            if (packageName.startsWith("jakarta.xml.bind")) {
                annotationsToRemove.add(annotation);
                continue;
            }
            if (!packageName.startsWith("javax.xml.bind")) continue;
            annotationsToRemove.add(annotation);
        }
        for (JAnnotationUse annotation : annotationsToRemove) {
            annotatable.removeAnnotation(annotation);
        }
    }

    public int parseArgument(Options opt, String[] args, int i) {
        String arg = args[i].trim();
        if (arg.startsWith(OPTION_NAME_REMOVE_OBJECT_FACTORY)) {
            this.removeObjectFactory = true;
            return 1;
        }
        return 0;
    }
}

