/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jax_ws_commons.jaxws;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jvnet.jax_ws_commons.jaxws.AbstractWsGenMojo;

@Mojo(name="wsgen-test", defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES, requiresDependencyResolution=ResolutionScope.TEST)
public class TestWsGenMojo
extends AbstractWsGenMojo {
    @Parameter(defaultValue="${project.build.testOutputDirectory}")
    private File destDir;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/test-wsgen")
    private File sourceDestDir;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/test-wsdl")
    private File resourceDestDir;
    @Parameter(property="maven.test.skip")
    private boolean skip;

    @Override
    protected File getDestDir() {
        return this.destDir;
    }

    @Override
    protected File getSourceDestDir() {
        return this.sourceDestDir;
    }

    @Override
    protected void addSourceRoot(String sourceDir) {
        if (!this.project.getTestCompileSourceRoots().contains(sourceDir)) {
            this.getLog().debug((CharSequence)("adding test src root: " + sourceDir));
            this.project.addTestCompileSourceRoot(sourceDir);
        } else {
            this.getLog().debug((CharSequence)("existing test src root: " + sourceDir));
        }
    }

    @Override
    protected File getResourceDestDir() {
        return this.resourceDestDir;
    }

    @Override
    protected File getDefaultSrcOut() {
        return new File(this.project.getBuild().getDirectory(), "generated-sources/test-wsgen");
    }

    @Override
    protected File getClassesDir() {
        return new File(this.project.getBuild().getTestOutputDirectory());
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping tests, nothing to do.");
        } else {
            super.execute();
        }
    }
}

