/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jax_ws_commons.jaxws;

import com.sun.tools.ws.Invoker;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.jvnet.jax_ws_commons.jaxws.AbstractJaxwsMojo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class WsImportMojo
extends AbstractJaxwsMojo {
    private static final String STALE_FILE_PREFIX = ".";
    private String packageName;
    private File catalog;
    private String httpproxy;
    private File wsdlDirectory;
    protected List wsdlFiles;
    private List wsdlUrls;
    protected File bindingDirectory;
    protected List bindingFiles;
    private String wsdlLocation;
    private String target;
    private Boolean xadditionalHeaders;
    private boolean xdebug;
    private boolean xnocompile;
    private boolean xnoAddressingDataBinding;
    protected File xauthFile;
    private List<String> xjcArgs;
    private List<String> args;
    private File staleFile;
    private Settings settings;

    WsImportMojo() {
    }

    protected abstract File getSourceDestDir();

    protected abstract void addSourceRoot(String var1);

    public void execute() throws MojoExecutionException {
        ClassLoader parent = ((Object)((Object)this)).getClass().getClassLoader();
        String originalSystemClasspath = this.initClassLoader(parent);
        try {
            File[] wsdls = this.getWSDLFiles();
            if (wsdls.length == 0 && (this.wsdlUrls == null || this.wsdlUrls.size() == 0)) {
                this.getLog().info((CharSequence)"No WSDLs are found to process, Specify atleast one of the following parameters: wsdlFiles, wsdlDirectory or wsdlUrls.");
                return;
            }
            this.getSourceDestDir().mkdirs();
            this.getDestDir().mkdirs();
            this.processWsdlViaUrls();
            this.processLocalWsdlFiles(wsdls);
            if (this.xnocompile) {
                this.addSourceRoot(this.getSourceDestDir().getAbsolutePath());
            }
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(parent);
            System.setProperty("java.class.path", originalSystemClasspath);
        }
    }

    private void processLocalWsdlFiles(File[] wsdls) throws MojoExecutionException, IOException {
        for (File wsdl : wsdls) {
            String relativePath = null;
            if (!wsdl.isAbsolute()) {
                relativePath = wsdl.getPath().replace(File.separatorChar, '/');
                wsdl = new File(this.wsdlDirectory, wsdl.getPath());
            }
            if (!this.isOutputStale(wsdl.getAbsolutePath())) continue;
            this.getLog().info((CharSequence)("Processing: " + wsdl.getAbsolutePath()));
            ArrayList<String> args = this.getWsImportArgs(relativePath);
            args.add(wsdl.getAbsolutePath());
            this.getLog().info((CharSequence)("jaxws:wsimport args: " + args));
            this.wsImport(args);
            this.touchStaleFile(wsdl.getAbsolutePath());
        }
    }

    private void processWsdlViaUrls() throws MojoExecutionException, IOException {
        for (int i = 0; this.wsdlUrls != null && i < this.wsdlUrls.size(); ++i) {
            String wsdlUrl = this.wsdlUrls.get(i).toString();
            if (!this.isOutputStale(wsdlUrl)) continue;
            this.getLog().info((CharSequence)("Processing: " + wsdlUrl));
            ArrayList<String> args = this.getWsImportArgs(null);
            args.add(wsdlUrl);
            this.getLog().info((CharSequence)("jaxws:wsimport args: " + args));
            this.wsImport(args);
            this.touchStaleFile(wsdlUrl);
        }
    }

    private void wsImport(ArrayList<String> args) throws MojoExecutionException {
        try {
            ClassLoader cl = Invoker.createClassLoader((ClassLoader)Thread.currentThread().getContextClassLoader());
            Class<?> c = cl.loadClass("com.sun.tools.ws.wscompile.WsimportTool");
            Object tool = c.getConstructor(OutputStream.class).newInstance(System.out);
            String[] ar = args.toArray(new String[args.size()]);
            Boolean result = (Boolean)c.getMethod("run", ar.getClass()).invoke(tool, new Object[]{ar});
            if (!result.booleanValue()) {
                throw new MojoExecutionException("Error executing: wsimport " + args);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error executing: wsimport " + args, e);
        }
    }

    private ArrayList<String> getWsImportArgs(String relativePath) throws MojoExecutionException {
        File[] bindings;
        String proxyString;
        ArrayList<String> args = new ArrayList<String>();
        args.add("-s");
        args.add(this.getSourceDestDir().getAbsolutePath());
        args.add("-d");
        args.add(this.getDestDir().getAbsolutePath());
        if (this.verbose) {
            args.add("-verbose");
        }
        if (this.httpproxy != null) {
            args.add("-httpproxy:" + this.httpproxy);
        } else if (this.settings != null && (proxyString = WsImportMojo.getActiveHttpProxy(this.settings)) != null) {
            args.add("-httpproxy:" + proxyString);
        }
        if (this.packageName != null) {
            args.add("-p");
            args.add(this.packageName);
        }
        if (this.catalog != null) {
            args.add("-catalog");
            args.add(this.catalog.getAbsolutePath());
        }
        if (this.wsdlLocation != null) {
            if (relativePath != null) {
                args.add("-wsdllocation");
                args.add(this.wsdlLocation.replaceAll("\\*", relativePath));
            } else if (!this.wsdlLocation.contains("*")) {
                args.add("-wsdllocation");
                args.add(this.wsdlLocation);
            }
        }
        if (this.target != null) {
            args.add("-target");
            args.add(this.target);
        }
        if (this.extension) {
            args.add("-extension");
        }
        if (this.xdebug) {
            args.add("-Xdebug");
        }
        if (this.xnocompile) {
            args.add("-Xnocompile");
        }
        if (this.xnoAddressingDataBinding) {
            args.add("-Xno-addressing-databinding");
        }
        if (this.xadditionalHeaders.booleanValue()) {
            args.add("-XadditionalHeaders");
        }
        if (this.xauthFile != null) {
            args.add("-Xauthfile");
            args.add(this.xauthFile.getAbsolutePath());
        }
        if (this.args != null) {
            for (String arg : this.args) {
                args.add(arg);
            }
        }
        if (this.xjcArgs != null) {
            for (String xjcArg : this.xjcArgs) {
                if (xjcArg.startsWith("-")) {
                    args.add("-B" + xjcArg);
                    continue;
                }
                args.add(xjcArg);
            }
        }
        if ((bindings = this.getBindingFiles()).length > 0 && this.wsdlLocation != null && this.wsdlLocation.contains("*")) {
            throw new MojoExecutionException("External binding file(s) can not be bound to more WSDL files (" + this.wsdlLocation + ")\n" + "Please use either inline binding(s) or multiple execution tags.");
        }
        for (File binding : bindings) {
            args.add("-b");
            args.add(binding.getAbsolutePath());
        }
        this.getLog().debug((CharSequence)("jaxws:wsimport args: " + args));
        return args;
    }

    public final File[] getBindingFiles() {
        File[] bindings;
        if (this.bindingFiles != null) {
            bindings = new File[this.bindingFiles.size()];
            for (int i = 0; i < this.bindingFiles.size(); ++i) {
                String schemaName = (String)this.bindingFiles.get(i);
                File file = new File(schemaName);
                if (!file.isAbsolute()) {
                    file = new File(this.bindingDirectory, schemaName);
                }
                bindings[i] = file;
            }
        } else {
            this.getLog().debug((CharSequence)("The binding Directory is " + this.bindingDirectory));
            bindings = this.bindingDirectory.listFiles(new XMLFile());
            if (bindings == null) {
                bindings = new File[]{};
            }
        }
        return bindings;
    }

    public final File[] getWSDLFiles() {
        File[] files;
        if (this.wsdlFiles != null) {
            files = new File[this.wsdlFiles.size()];
            for (int i = 0; i < this.wsdlFiles.size(); ++i) {
                String wsdlFileName = (String)this.wsdlFiles.get(i);
                File wsdl = new File(wsdlFileName);
                this.getLog().debug((CharSequence)("The wsdl File is " + wsdlFileName));
                files[i] = wsdl;
            }
        } else {
            this.getLog().debug((CharSequence)("The wsdl Directory is " + this.wsdlDirectory));
            files = this.wsdlDirectory.listFiles(new WSDLFile());
            if (files == null) {
                files = new File[]{};
            }
        }
        return files;
    }

    private boolean isOutputStale(String resource) {
        boolean stale;
        File[] sourceBindings = this.getBindingFiles();
        File stFile = new File(this.staleFile, STALE_FILE_PREFIX + this.getHash(resource));
        boolean bl = stale = !stFile.exists();
        if (!stale) {
            this.getLog().debug((CharSequence)"Stale flag file exists, comparing to wsdls and bindings.");
            long staleMod = stFile.lastModified();
            try {
                URL sourceWsdl = new URL(resource);
                if (sourceWsdl.openConnection().getLastModified() > staleMod) {
                    this.getLog().debug((CharSequence)(resource + " is newer than the stale flag file."));
                    stale = true;
                }
            }
            catch (MalformedURLException mue) {
                File sourceWsdl = new File(resource);
                if (sourceWsdl.lastModified() > staleMod) {
                    this.getLog().debug((CharSequence)(resource + " is newer than the stale flag file."));
                    stale = true;
                }
            }
            catch (IOException ioe) {
                this.getLog().error((Throwable)ioe);
            }
            for (File sourceBinding : sourceBindings) {
                if (sourceBinding.lastModified() <= staleMod) continue;
                this.getLog().debug((CharSequence)(sourceBinding.getName() + " is newer than the stale flag file."));
                stale = true;
            }
        }
        return stale;
    }

    private void touchStaleFile(String resource) throws IOException {
        File stFile = new File(this.staleFile, STALE_FILE_PREFIX + this.getHash(resource));
        if (!stFile.exists()) {
            stFile.getParentFile().mkdirs();
            stFile.createNewFile();
            this.getLog().debug((CharSequence)("Stale flag file created.[" + stFile.getAbsolutePath() + "]"));
        } else {
            stFile.setLastModified(System.currentTimeMillis());
        }
    }

    private String getHash(String s) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            Formatter formatter = new Formatter();
            for (byte b : md.digest(s.getBytes("UTF-8"))) {
                formatter.format("%02x", b);
            }
            return formatter.toString();
        }
        catch (UnsupportedEncodingException ex) {
            this.getLog().debug((CharSequence)ex.getMessage(), (Throwable)ex);
        }
        catch (NoSuchAlgorithmException ex) {
            this.getLog().debug((CharSequence)ex.getMessage(), (Throwable)ex);
        }
        this.getLog().warn((CharSequence)("Could not compute hash for " + s + ". Using fallback method."));
        return s.substring(s.lastIndexOf(47)).replaceAll(STALE_FILE_PREFIX, "-");
    }

    static String getActiveHttpProxy(Settings s) {
        String retVal = null;
        for (Proxy p : s.getProxies()) {
            if (!p.isActive() || !"http".equals(p.getProtocol())) continue;
            StringBuilder sb = new StringBuilder();
            String user = p.getUsername();
            String pwd = p.getPassword();
            if (user != null) {
                sb.append(user);
                if (pwd != null) {
                    sb.append(":");
                    sb.append(pwd);
                }
                sb.append("@");
            }
            sb.append(p.getHost());
            sb.append(":");
            sb.append(p.getPort());
            retVal = sb.toString().trim();
            break;
        }
        return retVal;
    }

    private final class WSDLFile
    implements FileFilter {
        private WSDLFile() {
        }

        public boolean accept(File file) {
            return file.getName().endsWith(".wsdl");
        }
    }

    private final class XMLFile
    implements FileFilter {
        private XMLFile() {
        }

        public boolean accept(File file) {
            return file.getName().endsWith(".xml");
        }
    }
}

