/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.junit5.discovery;

import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.commons.util.ReflectionUtils;
import org.junit.gen5.engine.EngineDiscoveryRequest;
import org.junit.gen5.engine.TestDescriptor;
import org.junit.gen5.engine.discovery.ClassSelector;
import org.junit.gen5.engine.discovery.ClasspathSelector;
import org.junit.gen5.engine.discovery.MethodSelector;
import org.junit.gen5.engine.discovery.PackageSelector;
import org.junit.gen5.engine.discovery.UniqueIdSelector;
import org.junit.gen5.engine.junit5.descriptor.ClassTestDescriptor;
import org.junit.gen5.engine.junit5.descriptor.JUnit5TestDescriptor;
import org.junit.gen5.engine.junit5.descriptor.MethodTestDescriptor;
import org.junit.gen5.engine.junit5.descriptor.NestedClassTestDescriptor;
import org.junit.gen5.engine.junit5.discovery.IsNestedTestClass;
import org.junit.gen5.engine.junit5.discovery.IsScannableTestClass;
import org.junit.gen5.engine.junit5.discovery.IsTestMethod;
import org.junit.gen5.engine.junit5.discovery.JUnit5EngineDescriptor;
import org.junit.gen5.engine.junit5.discovery.JUnit5Testable;
import org.junit.gen5.engine.support.descriptor.AbstractTestDescriptor;

@API(value=API.Usage.Internal)
public class DiscoverySelectorResolver {
    private final JUnit5EngineDescriptor engineDescriptor;
    private final IsNestedTestClass isNestedTestClass = new IsNestedTestClass();
    private final IsTestMethod isTestMethod = new IsTestMethod();
    private final IsScannableTestClass isScannableTestClass = new IsScannableTestClass();

    public DiscoverySelectorResolver(JUnit5EngineDescriptor engineDescriptor) {
        this.engineDescriptor = engineDescriptor;
    }

    public void resolveSelectors(EngineDiscoveryRequest request) {
        request.getSelectorsByType(ClasspathSelector.class).forEach(selector -> {
            File rootDirectory = selector.getClasspathRoot();
            ReflectionUtils.findAllClassesInClasspathRoot((File)rootDirectory, (Predicate)this.isScannableTestClass).stream().forEach(this::resolveTestClass);
        });
        request.getSelectorsByType(PackageSelector.class).forEach(selector -> {
            String packageName = selector.getPackageName();
            ReflectionUtils.findAllClassesInPackage((String)packageName, (Predicate)this.isScannableTestClass).stream().forEach(this::resolveTestClass);
        });
        request.getSelectorsByType(ClassSelector.class).forEach(selector -> this.resolveTestClass(selector.getTestClass()));
        request.getSelectorsByType(MethodSelector.class).forEach(selector -> this.resolveTestMethod(selector.getTestClass(), selector.getTestMethod()));
        request.getSelectorsByType(UniqueIdSelector.class).forEach(selector -> this.resolveUniqueId(selector.getUniqueId()));
    }

    private void resolveTestClass(Class<?> testClass) {
        JUnit5Testable testable = JUnit5Testable.fromClass(testClass, this.engineDescriptor.getUniqueId());
        this.resolveTestable(testable);
    }

    private void resolveTestMethod(Class<?> testClass, Method testMethod) {
        JUnit5Testable testable = JUnit5Testable.fromMethod(testMethod, testClass, this.engineDescriptor.getUniqueId());
        this.resolveTestable(testable);
    }

    private void resolveUniqueId(String uniqueId) {
        JUnit5Testable testable = JUnit5Testable.fromUniqueId(uniqueId, this.engineDescriptor.getUniqueId());
        this.resolveTestable(testable);
    }

    private void resolveTestable(JUnit5Testable testable, final boolean withChildren) {
        testable.accept(new JUnit5Testable.Visitor(){

            @Override
            public void visitClass(String uniqueId, Class<?> testClass) {
                DiscoverySelectorResolver.this.resolveClassTestable(testClass, uniqueId, (AbstractTestDescriptor)DiscoverySelectorResolver.this.engineDescriptor, withChildren);
            }

            @Override
            public void visitMethod(String uniqueId, Method method, Class<?> container) {
                DiscoverySelectorResolver.this.resolveMethodTestable(method, container, uniqueId);
            }

            @Override
            public void visitNestedClass(String uniqueId, Class<?> testClass, Class<?> containerClass) {
                DiscoverySelectorResolver.this.resolveNestedClassTestable(uniqueId, testClass, containerClass, withChildren);
            }
        });
    }

    private void resolveTestable(JUnit5Testable testable) {
        this.resolveTestable(testable, true);
    }

    private void resolveMethodTestable(Method method, Class<?> testClass, String uniqueId) {
        JUnit5Testable parentTestable = JUnit5Testable.fromClass(testClass, this.engineDescriptor.getUniqueId());
        TestDescriptor newParentDescriptor = this.resolveAndReturnParentTestable(parentTestable);
        MethodTestDescriptor descriptor = this.getOrCreateMethodDescriptor(testClass, method, uniqueId);
        newParentDescriptor.addChild((TestDescriptor)descriptor);
    }

    private void resolveClassTestable(Class<?> testClass, String uniqueId, AbstractTestDescriptor parentDescriptor, boolean withChildren) {
        JUnit5TestDescriptor descriptor = this.getOrCreateClassDescriptor(testClass, uniqueId);
        parentDescriptor.addChild((TestDescriptor)descriptor);
        if (withChildren) {
            this.resolveContainedNestedClasses(testClass);
            this.resolveContainedTestMethods(testClass, descriptor);
        }
    }

    private void resolveNestedClassTestable(String uniqueId, Class<?> testClass, Class<?> containerClass, boolean withChildren) {
        JUnit5Testable containerTestable = JUnit5Testable.fromClass(containerClass, this.engineDescriptor.getUniqueId());
        TestDescriptor parentDescriptor = this.resolveAndReturnParentTestable(containerTestable);
        NestedClassTestDescriptor descriptor = this.getOrCreateNestedClassDescriptor(testClass, uniqueId);
        parentDescriptor.addChild((TestDescriptor)descriptor);
        if (withChildren) {
            this.resolveContainedNestedClasses(testClass);
            this.resolveContainedTestMethods(testClass, descriptor);
        }
    }

    private TestDescriptor resolveAndReturnParentTestable(JUnit5Testable containerTestable) {
        this.resolveTestable(containerTestable, false);
        return this.descriptorByUniqueId(containerTestable.getUniqueId()).orElseThrow(() -> {
            String errorMessage = String.format("Testable with unique id %s could not be resolved. Programming error!", containerTestable.getUniqueId());
            return new RuntimeException(errorMessage);
        });
    }

    private void resolveContainedTestMethods(Class<?> testClass, AbstractTestDescriptor parentDescriptor) {
        List testMethodCandidates = ReflectionUtils.findMethods(testClass, (Predicate)this.isTestMethod, (ReflectionUtils.MethodSortOrder)ReflectionUtils.MethodSortOrder.HierarchyDown);
        for (Method method : testMethodCandidates) {
            JUnit5Testable methodTestable = JUnit5Testable.fromMethod(method, testClass, this.engineDescriptor.getUniqueId());
            MethodTestDescriptor methodDescriptor = this.getOrCreateMethodDescriptor(testClass, method, methodTestable.getUniqueId());
            parentDescriptor.addChild((TestDescriptor)methodDescriptor);
        }
    }

    private void resolveContainedNestedClasses(Class<?> clazz) {
        List nestedClasses = ReflectionUtils.findNestedClasses(clazz, (Predicate)this.isNestedTestClass);
        for (Class nestedClass : nestedClasses) {
            JUnit5Testable nestedClassTestable = JUnit5Testable.fromClass(nestedClass, this.engineDescriptor.getUniqueId());
            this.resolveTestable(nestedClassTestable);
        }
    }

    private MethodTestDescriptor getOrCreateMethodDescriptor(Class<?> testClass, Method method, String uniqueId) {
        return (MethodTestDescriptor)this.descriptorByUniqueId(uniqueId).orElseGet(() -> new MethodTestDescriptor(uniqueId, testClass, method));
    }

    private NestedClassTestDescriptor getOrCreateNestedClassDescriptor(Class<?> clazz, String uniqueId) {
        return (NestedClassTestDescriptor)this.descriptorByUniqueId(uniqueId).orElseGet(() -> new NestedClassTestDescriptor(uniqueId, clazz));
    }

    private JUnit5TestDescriptor getOrCreateClassDescriptor(Class<?> clazz, String uniqueId) {
        return (JUnit5TestDescriptor)this.descriptorByUniqueId(uniqueId).orElseGet(() -> new ClassTestDescriptor(uniqueId, clazz));
    }

    private Optional<TestDescriptor> descriptorByUniqueId(String uniqueId) {
        return this.engineDescriptor.findByUniqueId(uniqueId);
    }
}

