/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.launcher.main;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.gen5.engine.DiscoveryFilter;
import org.junit.gen5.engine.DiscoverySelector;
import org.junit.gen5.launcher.EngineIdFilter;
import org.junit.gen5.launcher.PostDiscoveryFilter;
import org.junit.gen5.launcher.TestDiscoveryRequest;

final class DiscoveryRequest
implements TestDiscoveryRequest {
    private final List<DiscoverySelector> selectors = new LinkedList<DiscoverySelector>();
    private final List<EngineIdFilter> engineIdFilters = new LinkedList<EngineIdFilter>();
    private final List<DiscoveryFilter<?>> discoveryFilters = new LinkedList();
    private final List<PostDiscoveryFilter> postDiscoveryFilters = new LinkedList<PostDiscoveryFilter>();

    DiscoveryRequest() {
    }

    @Override
    public void addSelector(DiscoverySelector selector) {
        this.selectors.add(selector);
    }

    @Override
    public void addSelectors(Collection<DiscoverySelector> selectors) {
        selectors.forEach(this::addSelector);
    }

    @Override
    public void addEngineIdFilter(EngineIdFilter engineIdFilter) {
        this.engineIdFilters.add(engineIdFilter);
    }

    @Override
    public void addEngineIdFilters(Collection<EngineIdFilter> engineIdFilters) {
        this.engineIdFilters.addAll(engineIdFilters);
    }

    @Override
    public void addFilter(DiscoveryFilter<?> discoveryFilter) {
        this.discoveryFilters.add(discoveryFilter);
    }

    @Override
    public void addFilters(Collection<DiscoveryFilter<?>> discoveryFilters) {
        this.discoveryFilters.addAll(discoveryFilters);
    }

    @Override
    public void addPostFilter(PostDiscoveryFilter postDiscoveryFilter) {
        this.postDiscoveryFilters.add(postDiscoveryFilter);
    }

    @Override
    public void addPostFilters(Collection<PostDiscoveryFilter> postDiscoveryFilters) {
        this.postDiscoveryFilters.addAll(postDiscoveryFilters);
    }

    public List<DiscoverySelector> getSelectors() {
        return Collections.unmodifiableList(this.selectors);
    }

    public <T extends DiscoverySelector> List<T> getSelectorsByType(Class<T> selectorType) {
        return this.selectors.stream().filter(selectorType::isInstance).map(selectorType::cast).collect(Collectors.toList());
    }

    @Override
    public List<EngineIdFilter> getEngineIdFilters() {
        return Collections.unmodifiableList(this.engineIdFilters);
    }

    public <T extends DiscoveryFilter<?>> List<T> getDiscoveryFiltersByType(Class<T> filterType) {
        return this.discoveryFilters.stream().filter(filterType::isInstance).map(filterType::cast).collect(Collectors.toList());
    }

    @Override
    public List<PostDiscoveryFilter> getPostDiscoveryFilters() {
        return Collections.unmodifiableList(this.postDiscoveryFilters);
    }
}

