/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.launcher.main;

import java.util.HashSet;
import java.util.logging.Logger;
import org.junit.gen5.commons.JUnitException;
import org.junit.gen5.engine.EngineDiscoveryRequest;
import org.junit.gen5.engine.EngineExecutionListener;
import org.junit.gen5.engine.ExecutionRequest;
import org.junit.gen5.engine.FilterResult;
import org.junit.gen5.engine.TestDescriptor;
import org.junit.gen5.engine.TestEngine;
import org.junit.gen5.launcher.Launcher;
import org.junit.gen5.launcher.TestDiscoveryRequest;
import org.junit.gen5.launcher.TestExecutionListener;
import org.junit.gen5.launcher.TestPlan;
import org.junit.gen5.launcher.main.ExecutionListenerAdapter;
import org.junit.gen5.launcher.main.Root;
import org.junit.gen5.launcher.main.TestExecutionListenerRegistry;

class DefaultLauncher
implements Launcher {
    private static final Logger LOG = Logger.getLogger(DefaultLauncher.class.getName());
    private final TestExecutionListenerRegistry listenerRegistry = new TestExecutionListenerRegistry();
    private final Iterable<TestEngine> testEngines;

    DefaultLauncher(Iterable<TestEngine> testEngines) {
        this.testEngines = testEngines;
    }

    @Override
    public void registerTestExecutionListeners(TestExecutionListener ... listeners) {
        this.listenerRegistry.registerListener(listeners);
    }

    @Override
    public TestPlan discover(TestDiscoveryRequest discoveryRequest) {
        return TestPlan.from(this.discoverRoot(discoveryRequest, "discovery").getEngineDescriptors());
    }

    @Override
    public void execute(TestDiscoveryRequest discoveryRequest) {
        this.execute(this.discoverRoot(discoveryRequest, "execution"));
    }

    private Root discoverRoot(TestDiscoveryRequest discoveryRequest, String phase) {
        Root root = new Root();
        HashSet<String> uniqueEngineIds = new HashSet<String>();
        for (TestEngine testEngine : this.testEngines) {
            String engineId = testEngine.getId();
            if (discoveryRequest.getEngineIdFilters().stream().map(engineIdFilter -> engineIdFilter.filter(engineId)).anyMatch(FilterResult::excluded)) {
                LOG.fine(() -> String.format("Test discovery for engine '%s' was skipped due to a filter in phase '%s'.", engineId, phase));
                continue;
            }
            if (!uniqueEngineIds.add(engineId)) {
                throw new JUnitException(String.format("Failure in launcher: multiple engines with the same ID [%s].", engineId));
            }
            LOG.fine(() -> String.format("Discovering tests during launcher %s phase in engine '%s'.", phase, engineId));
            TestDescriptor engineRoot = testEngine.discover((EngineDiscoveryRequest)discoveryRequest);
            root.add(testEngine, engineRoot);
        }
        root.applyPostDiscoveryFilters(discoveryRequest);
        root.prune();
        return root;
    }

    private void execute(Root root) {
        TestPlan testPlan = TestPlan.from(root.getEngineDescriptors());
        TestExecutionListener testExecutionListener = this.listenerRegistry.getCompositeTestExecutionListener();
        testExecutionListener.testPlanExecutionStarted(testPlan);
        ExecutionListenerAdapter engineExecutionListener = new ExecutionListenerAdapter(testPlan, testExecutionListener);
        for (TestEngine testEngine : root.getTestEngines()) {
            TestDescriptor testDescriptor = root.getTestDescriptorFor(testEngine);
            testEngine.execute(new ExecutionRequest(testDescriptor, (EngineExecutionListener)engineExecutionListener));
        }
        testExecutionListener.testPlanExecutionFinished(testPlan);
    }
}

