/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.launcher;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.engine.TestDescriptor;
import org.junit.gen5.engine.TestSource;
import org.junit.gen5.engine.TestTag;
import org.junit.gen5.launcher.TestId;

@API(value=API.Usage.Experimental)
public final class TestIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final TestId uniqueId;
    private final String name;
    private final String displayName;
    private final TestSource source;
    private final Set<TestTag> tags;
    private final boolean test;
    private final boolean container;
    private final TestId parentId;

    public static TestIdentifier from(TestDescriptor testDescriptor) {
        TestId uniqueId = new TestId(testDescriptor.getUniqueId());
        String name = testDescriptor.getName();
        String displayName = testDescriptor.getDisplayName();
        Optional source = testDescriptor.getSource();
        Set tags = testDescriptor.getTags();
        boolean test = testDescriptor.isTest();
        boolean container = !test || !testDescriptor.getChildren().isEmpty();
        Optional<TestId> parentId = testDescriptor.getParent().map(TestDescriptor::getUniqueId).map(TestId::new);
        return new TestIdentifier(uniqueId, name, displayName, source, tags, test, container, parentId);
    }

    private TestIdentifier(TestId uniqueId, String name, String displayName, Optional<TestSource> source, Set<TestTag> tags, boolean test, boolean container, Optional<TestId> parentId) {
        this.uniqueId = uniqueId;
        this.name = name;
        this.displayName = displayName;
        this.source = source.orElse(null);
        this.tags = Collections.unmodifiableSet(new LinkedHashSet<TestTag>(tags));
        this.test = test;
        this.container = container;
        this.parentId = parentId.orElse(null);
    }

    public TestId getUniqueId() {
        return this.uniqueId;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isTest() {
        return this.test;
    }

    public boolean isContainer() {
        return this.container;
    }

    public Optional<TestSource> getSource() {
        return Optional.ofNullable(this.source);
    }

    public Set<TestTag> getTags() {
        return this.tags;
    }

    public Optional<TestId> getParentId() {
        return Optional.ofNullable(this.parentId);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TestIdentifier) {
            TestIdentifier that = (TestIdentifier)obj;
            return Objects.equals(this.uniqueId, that.uniqueId);
        }
        return false;
    }

    public int hashCode() {
        return this.uniqueId.hashCode();
    }

    public String toString() {
        return this.getDisplayName() + " [" + this.uniqueId + "]";
    }
}

