/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.spring;

import org.jtwig.spring.JtwigView;
import org.jtwig.spring.prefix.DefaultPrefixResolver;
import org.jtwig.spring.prefix.PrefixResolver;
import org.jtwig.web.servlet.JtwigRenderer;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.view.AbstractTemplateViewResolver;

public class JtwigViewResolver
extends AbstractTemplateViewResolver
implements ViewResolver,
InitializingBean {
    private JtwigRenderer renderer;
    private PrefixResolver prefixResolver = DefaultPrefixResolver.instance();

    public JtwigViewResolver() {
        this.setViewClass(JtwigView.class);
    }

    protected Class<?> requiredViewClass() {
        return JtwigView.class;
    }

    public void setRenderer(JtwigRenderer renderer) {
        this.renderer = renderer;
    }

    public void setPrefixResolver(PrefixResolver prefixResolver) {
        this.prefixResolver = prefixResolver;
    }

    protected JtwigView buildView(String viewName) throws Exception {
        JtwigView view = (JtwigView)super.buildView(viewName);
        view.setRenderer(this.renderer);
        return view;
    }

    public JtwigRenderer getRenderer() {
        return this.renderer;
    }

    protected String getPrefix() {
        return this.prefixResolver.resolve(super.getPrefix());
    }

    public void afterPropertiesSet() throws Exception {
        if (this.renderer == null) {
            this.renderer = JtwigRenderer.defaultRenderer();
        }
    }
}

