/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.util;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.PackageTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Logger;
import org.jsweet.transpiler.JSweetContext;
import org.jsweet.transpiler.SourcePosition;
import org.jsweet.transpiler.util.DirectedGraph;

public class Util {
    public static final String CONSTRUCTOR_METHOD_NAME = "<init>";
    private static final Logger logger = Logger.getLogger(Util.class);
    protected JSweetContext context;
    private static final String TYPE_PARAMETERS_REGEX = "\\<[a-zA-Z0-9., ]+\\>";
    private static long id = 121L;
    private static final Pattern REGEX_CHARS = Pattern.compile("([\\\\*+\\[\\](){}\\$.?\\^|])");
    private static final List<TypeKind> IS_ASSIGABLE_FORBBIDEN_TYPES = Arrays.asList(TypeKind.EXECUTABLE, TypeKind.PACKAGE, TypeKind.MODULE);
    private static Field typeField;
    private static Field tsymField;
    private static Map<Class<?>, Field> symFields;

    public Util(JSweetContext context) {
        this.context = context;
    }

    public boolean isSetType(TypeMirror type) {
        if (type == null) {
            return false;
        }
        type = this.context.types.erasure(type);
        TypeMirror setType = this.context.util.getTypeElementByName(this.context, Set.class.getName()).asType();
        return this.context.types.isAssignable(type, this.context.types.erasure(setType));
    }

    public boolean isCollectionType(TypeMirror type) {
        if (type == null) {
            return false;
        }
        type = this.context.types.erasure(type);
        TypeMirror setType = this.context.util.getTypeElementByName(this.context, Collection.class.getName()).asType();
        return this.context.types.isAssignable(type, this.context.types.erasure(setType));
    }

    public boolean isArrayType(TypeMirror type) {
        return type instanceof ArrayType;
    }

    public boolean isMapType(TypeMirror type) {
        if (type == null) {
            return false;
        }
        type = this.context.types.erasure(type);
        TypeMirror setType = this.context.util.getTypeElementByName(this.context, Map.class.getName()).asType();
        return this.context.types.isAssignable(type, this.context.types.erasure(setType));
    }

    public PackageElement getPackage(Element element) {
        Element packageElement = element;
        while ((packageElement = packageElement.getEnclosingElement()) != null && !(packageElement instanceof PackageElement)) {
        }
        return (PackageElement)packageElement;
    }

    public String stripTypeParameters(String typeName) {
        String previous = typeName;
        String current = previous.replaceAll(TYPE_PARAMETERS_REGEX, "");
        while (!current.equals(previous)) {
            previous = current;
            current = previous.replaceAll(TYPE_PARAMETERS_REGEX, "");
        }
        return current;
    }

    public Collection<VariableElement> getFieldElements(TypeElement typeElement) {
        return typeElement.getEnclosedElements().stream().filter(member -> member.getKind() == ElementKind.FIELD).filter(member -> !member.getModifiers().contains((Object)Modifier.STATIC)).map(field -> (VariableElement)field).collect(Collectors.toList());
    }

    private void collectTypeAndTypeArgmentsRecursively(TypeMirror type, Collection<TypeMirror> types) {
        types.add(type);
        if (type instanceof DeclaredType) {
            for (TypeMirror typeMirror : ((DeclaredType)type).getTypeArguments()) {
                this.collectTypeAndTypeArgmentsRecursively(typeMirror, types);
            }
        }
    }

    public Collection<TypeMirror> collectTypeAndTypeArgmentsRecursively(TypeMirror type) {
        ArrayList<TypeMirror> types = new ArrayList<TypeMirror>();
        this.collectTypeAndTypeArgmentsRecursively(type, types);
        return types;
    }

    public List<TypeParameterElement> getGenericTypeParameters(DeclaredType type) {
        return ((TypeElement)((DeclaredType)this.context.types.erasure(type)).asElement()).getTypeParameters();
    }

    public TypeMirror getCollectionItemType(TypeMirror collectionType) {
        DeclaredType collectionDeclaredType = (DeclaredType)collectionType;
        if (collectionDeclaredType.getTypeArguments().size() > 0) {
            TypeMirror collectionElementType = collectionDeclaredType.getTypeArguments().get(0);
            return collectionElementType;
        }
        return this.context.util.getType(Object.class);
    }

    public TypeMirror getUpperBound(TypeMirror type) {
        if (type instanceof TypeVariable && ((TypeVariable)type).getUpperBound() != null) {
            return ((TypeVariable)type).getUpperBound();
        }
        return type;
    }

    public List<? extends TypeMirror> getTypeArguments(TypeMirror type) {
        if (type instanceof DeclaredType) {
            return ((DeclaredType)type).getTypeArguments();
        }
        return null;
    }

    public String getQualifiedName(TypeMirror type) {
        Element e;
        if (type instanceof DeclaredType && (e = ((DeclaredType)type).asElement()) instanceof TypeElement) {
            return ((TypeElement)e).getQualifiedName().toString();
        }
        return type.toString();
    }

    public <T> Class<T> getTypeClass(TypeMirror type) {
        try {
            Class<?> clazz = Class.forName(this.getQualifiedName(type));
            return clazz;
        }
        catch (Exception e) {
            return null;
        }
    }

    public TypeMirror getType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return this.types().getPrimitiveType(TypeKind.valueOf(clazz.getName().toUpperCase()));
        }
        TypeElement typeElement = this.getTypeElementByName(this.context, clazz.getName());
        return typeElement == null ? null : typeElement.asType();
    }

    public TypeMirror getType(String fullyQualifiedName) {
        TypeMirror result = null;
        try {
            Class<?> clazz = Class.forName(fullyQualifiedName);
            result = this.getType(clazz);
            if (result != null) {
                return result;
            }
        }
        catch (Exception clazz) {
            // empty catch block
        }
        TypeElement typeElement = this.context.elements.getTypeElement(fullyQualifiedName);
        if (typeElement != null) {
            return typeElement.asType();
        }
        return null;
    }

    public boolean isSourceElement(Element element) {
        if (element == null || element instanceof PackageElement) {
            return false;
        }
        if (element instanceof TypeElement) {
            TypeElement clazz = (TypeElement)element;
            JavaFileObject sourceFile = this.javacInternals().getSourceFileObjectFromElement(clazz);
            if (sourceFile != null && (sourceFile.getClass().getName().equals("com.sun.tools.javac.file.RegularFileObject") || sourceFile.getClass().getName().equals("com.sun.tools.javac.file.PathFileObject$SimpleFileObject"))) {
                return true;
            }
        }
        return this.isSourceElement(element.getEnclosingElement());
    }

    public String getSourceFilePath(Element element) {
        TypeElement clazz;
        if (element == null || element instanceof PackageElement) {
            return null;
        }
        if (element instanceof TypeElement && this.isSourceElement(clazz = (TypeElement)element)) {
            return this.javacInternals().getSourceFileObjectFromElement(clazz).getName();
        }
        return this.getSourceFilePath(element.getEnclosingElement());
    }

    public boolean isInSameSourceFile(CompilationUnitTree compilationUnitTree, Element element) {
        if (compilationUnitTree == null || element == null) {
            return false;
        }
        assert (this.isSourceElement(element)) : "unsupported element type (from a class file and not a source file)";
        return this.getSourceFilePath(element).equals(compilationUnitTree.getSourceFile().getName());
    }

    public static <T> T firstOrDefault(Iterable<T> iterable) {
        return iterable.iterator().next();
    }

    public Tree lookupTree(JSweetContext context, final Element element) {
        TypeElement clazz;
        if (element == null || element instanceof PackageElement) {
            return null;
        }
        Element rootClass = Util.getRootClassElement(element);
        if (rootClass instanceof TypeElement && this.isSourceElement(clazz = (TypeElement)rootClass)) {
            final Tree[] result = new Tree[]{null};
            for (int i = 0; i < context.sourceFiles.length; ++i) {
                if (!new File(this.javacInternals().getSourceFileObjectFromElement(clazz).getName()).equals(context.sourceFiles[i].getJavaFile())) continue;
                CompilationUnitTree cu = context.compilationUnits.get(i);
                new TreePathScanner<Void, Trees>(){

                    @Override
                    public Void visitClass(ClassTree tree, Trees trees) {
                        if (trees.getElement(this.getCurrentPath()) == element) {
                            result[0] = tree;
                        } else {
                            super.visitClass(tree, trees);
                        }
                        return null;
                    }

                    @Override
                    public Void visitMethod(MethodTree tree, Trees trees) {
                        if (trees.getElement(this.getCurrentPath()) == element) {
                            result[0] = tree;
                        }
                        return null;
                    }

                    @Override
                    public Void visitVariable(VariableTree tree, Trees trees) {
                        if (trees.getElement(this.getCurrentPath()) == element) {
                            result[0] = tree;
                        } else {
                            super.visitVariable(tree, trees);
                        }
                        return null;
                    }
                }.scan(cu, this.trees());
                return result[0];
            }
        }
        return null;
    }

    private static Element getRootClassElement(Element element) {
        if (element == null) {
            return null;
        }
        if (element instanceof TypeElement && (element.getEnclosingElement() == null || element.getEnclosingElement() instanceof PackageElement)) {
            return element;
        }
        return Util.getRootClassElement(element.getEnclosingElement());
    }

    public void addFiles(String extension, File file, Collection<File> files) {
        Static.addFiles(extension, file, files);
    }

    public void addFiles(Predicate<File> filter, File file, Collection<File> files) {
        Static.addFiles(filter, file, files);
    }

    public String getFullMethodSignature(ExecutableElement method) {
        TypeElement enclosingType = this.getParentElement(method, TypeElement.class);
        return enclosingType.getQualifiedName() + "." + method.toString();
    }

    public boolean containsMethods(ClassTree classDeclaration, CompilationUnitTree compilationUnit) {
        for (Tree tree : classDeclaration.getMembers()) {
            if (tree instanceof MethodTree) {
                long classDeclarationPos;
                MethodTree method = (MethodTree)tree;
                long methodPos = this.sourcePositions().getStartPosition(compilationUnit, method);
                if (methodPos == (classDeclarationPos = this.sourcePositions().getStartPosition(compilationUnit, classDeclaration))) continue;
                return true;
            }
            if (!(tree instanceof VariableTree) || !((VariableTree)tree).getModifiers().getFlags().contains((Object)Modifier.STATIC)) continue;
            return true;
        }
        return false;
    }

    private static void putVar(Map<String, VariableElement> vars, VariableElement varSymbol) {
        vars.put(varSymbol.getSimpleName().toString(), varSymbol);
    }

    public void fillAllVariablesInScope(Map<String, VariableElement> vars, Stack<Tree> scanningStack, Tree from, Tree to, CompilationUnitTree compilationUnit) {
        if (from == to) {
            return;
        }
        int i = scanningStack.indexOf(from);
        if (i == -1 || i == 0) {
            return;
        }
        Tree parent = (Tree)scanningStack.get(i - 1);
        List<? extends StatementTree> statements = null;
        switch (parent.getKind()) {
            case BLOCK: {
                statements = ((BlockTree)parent).getStatements();
                break;
            }
            case CASE: {
                statements = ((CaseTree)parent).getStatements();
                break;
            }
            case CATCH: {
                Util.putVar(vars, (VariableElement)Util.getElement(((CatchTree)parent).getParameter()));
                break;
            }
            case FOR_LOOP: {
                if (((ForLoopTree)parent).getInitializer() == null) break;
                for (StatementTree statementTree : ((ForLoopTree)parent).getInitializer()) {
                    if (!(statementTree instanceof VariableTree)) continue;
                    Util.putVar(vars, (VariableElement)Util.getElement(statementTree));
                }
                break;
            }
            case ENHANCED_FOR_LOOP: {
                Util.putVar(vars, (VariableElement)Util.getElement(((EnhancedForLoopTree)parent).getVariable()));
                break;
            }
            case METHOD: {
                for (VariableTree variableTree : ((MethodTree)parent).getParameters()) {
                    Util.putVar(vars, (VariableElement)Util.getElement(variableTree));
                }
                break;
            }
        }
        if (statements != null) {
            for (StatementTree statementTree : statements) {
                if (statementTree == from) break;
                if (!(statementTree instanceof VariableTree)) continue;
                Util.putVar(vars, (VariableElement)Util.getElement(statementTree));
            }
        }
        this.fillAllVariablesInScope(vars, scanningStack, parent, to, compilationUnit);
    }

    public List<ClassTree> findTypeDeclarationsInCompilationUnits(List<CompilationUnitTree> compilationUnits) {
        LinkedList<ClassTree> symbols = new LinkedList<ClassTree>();
        for (CompilationUnitTree compilationUnit : compilationUnits) {
            for (Tree tree : compilationUnit.getTypeDecls()) {
                if (!(tree instanceof ClassTree)) continue;
                symbols.add((ClassTree)tree);
            }
        }
        return symbols;
    }

    public List<MethodTree> findMethodDeclarations(ClassTree typeDeclaration) {
        LinkedList<MethodTree> methods = new LinkedList<MethodTree>();
        for (Tree tree : typeDeclaration.getMembers()) {
            if (!(tree instanceof MethodTree)) continue;
            methods.add((MethodTree)tree);
        }
        return methods;
    }

    public MethodTree findFirstMethodDeclaration(ClassTree typeDeclaration, String methodName) {
        return this.findMethodDeclarations(typeDeclaration).stream().filter(methodDecl -> methodDecl.getName().toString().equals(methodName)).findFirst().orElse(null);
    }

    public void fillAllVariableAccesses(final Map<String, VariableElement> vars, final Tree tree, CompilationUnitTree compilationUnit) {
        new TreeScanner<Void, Trees>(){

            @Override
            public Void visitIdentifier(IdentifierTree identifierTree, Trees trees) {
                Object element = Util.getElement(identifierTree);
                if (element.getKind() == ElementKind.LOCAL_VARIABLE) {
                    Util.putVar(vars, (VariableElement)element);
                }
                return null;
            }

            @Override
            public Void visitLambdaExpression(LambdaExpressionTree lambdaTree, Trees trees) {
                if (lambdaTree == tree) {
                    super.visitLambdaExpression(lambdaTree, trees);
                }
                return null;
            }
        }.scan(tree, this.trees());
    }

    @Deprecated
    public ExecutableElement findMethodDeclarationInType(TypeElement typeSymbol, MethodInvocationTree invocation) {
        ExpressionTree method = invocation.getMethodSelect();
        String methName = method.toString().substring(method.toString().lastIndexOf(46) + 1);
        Object methodType = Util.getType(method);
        return this.findMethodDeclarationInType(typeSymbol, methName, (ExecutableType)methodType);
    }

    @Deprecated
    public ExecutableElement findMethodDeclarationInType(TypeElement typeSymbol, String methodName, ExecutableType methodType) {
        return this.findMethodDeclarationInType(typeSymbol, methodName, methodType, false);
    }

    @Deprecated
    public ExecutableElement findMethodDeclarationInType(TypeElement typeSymbol, String methodName, ExecutableType methodType, boolean overrides) {
        LinkedList<ExecutableElement> candidates = new LinkedList<ExecutableElement>();
        this.collectMatchingMethodDeclarationsInType(typeSymbol, methodName, methodType, overrides, candidates);
        ExecutableElement bestMatch = null;
        int lastScore = Integer.MIN_VALUE;
        for (ExecutableElement candidate : candidates) {
            int currentScore = Util.getCandidateMethodMatchScore(candidate, methodType);
            if (bestMatch != null && currentScore <= lastScore) continue;
            bestMatch = candidate;
            lastScore = currentScore;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("method declaration match for " + typeSymbol + "." + methodName + " - " + methodType + " : " + (String)(bestMatch == null ? "" : bestMatch.getEnclosingElement() + ".") + bestMatch + " score=" + lastScore));
        }
        return bestMatch;
    }

    public ExecutableElement findMethodDeclarationInType2(TypeElement typeSymbol, String methodName, ExecutableType methodType) {
        LinkedList<ExecutableElement> candidates = new LinkedList<ExecutableElement>();
        this.collectMatchingMethodDeclarationsInType(typeSymbol, methodName, methodType, false, candidates);
        for (ExecutableElement candidate : candidates) {
            if (!this.context.types.isSubsignature((ExecutableType)candidate.asType(), methodType)) continue;
            return candidate;
        }
        return null;
    }

    @Deprecated
    private static int getCandidateMethodMatchScore(ExecutableElement candidate, ExecutableType methodType) {
        boolean isAbstract;
        if (methodType == null || candidate.getParameters().size() != methodType.getParameterTypes().size()) {
            return -50;
        }
        int score = 0;
        boolean bl = isAbstract = candidate.getModifiers().contains((Object)Modifier.ABSTRACT) && !candidate.isDefault();
        if (isAbstract) {
            score -= 30;
        }
        for (int i = 0; i < candidate.getParameters().size(); ++i) {
            TypeMirror paramType;
            TypeMirror candidateParamType = candidate.getParameters().get(i).asType();
            if (candidateParamType.equals(paramType = methodType.getParameterTypes().get(i))) continue;
            --score;
        }
        return score;
    }

    public void collectMatchingMethodDeclarationsInType(TypeElement typeSymbol, String methodName, ExecutableType methodType, boolean overrides, List<ExecutableElement> collector) {
        if (typeSymbol == null) {
            return;
        }
        if (typeSymbol.getEnclosedElements() != null) {
            for (Element element : typeSymbol.getEnclosedElements()) {
                if (!(element instanceof ExecutableElement) || !methodName.equals(element.getSimpleName().toString()) && (((ExecutableElement)element).getKind() != ElementKind.CONSTRUCTOR || !"this".equals(methodName))) continue;
                ExecutableElement methodSymbol = (ExecutableElement)element;
                if (methodType == null) {
                    collector.add(methodSymbol);
                    continue;
                }
                if (!(overrides ? this.isInvocable((ExecutableType)methodSymbol.asType(), methodType) : this.isInvocable(methodType, (ExecutableType)methodSymbol.asType()))) continue;
                collector.add(methodSymbol);
            }
        }
        if (!(typeSymbol.getSuperclass() == null || overrides && Object.class.getName().equals(typeSymbol.getSuperclass().toString()))) {
            this.collectMatchingMethodDeclarationsInType((TypeElement)this.types().asElement(typeSymbol.getSuperclass()), methodName, methodType, overrides, collector);
        }
        if (typeSymbol.getInterfaces() != null) {
            for (TypeElement typeElement : this.getInterfaces(typeSymbol)) {
                this.collectMatchingMethodDeclarationsInType(typeElement, methodName, methodType, overrides, collector);
            }
        }
    }

    public void findMethodDeclarationsInType(TypeElement typeSymbol, Collection<String> methodNames, Set<String> ignoredTypeNames, List<ExecutableElement> result) {
        if (typeSymbol == null) {
            return;
        }
        if (ignoredTypeNames.contains(typeSymbol.getQualifiedName().toString())) {
            return;
        }
        if (typeSymbol.getEnclosedElements() != null) {
            for (Element element : typeSymbol.getEnclosedElements()) {
                if (!(element instanceof ExecutableElement) || !methodNames.contains(element.getSimpleName().toString())) continue;
                result.add((ExecutableElement)element);
            }
        }
        if (typeSymbol instanceof TypeElement && typeSymbol.getSuperclass() != null) {
            this.findMethodDeclarationsInType(this.getSuperclass(typeSymbol), methodNames, ignoredTypeNames, result);
        }
        if (result == null && typeSymbol instanceof TypeElement && typeSymbol.getInterfaces() != null) {
            for (TypeElement typeElement : this.getInterfaces(typeSymbol)) {
                this.findMethodDeclarationsInType(typeElement, methodNames, ignoredTypeNames, result);
            }
        }
    }

    public TypeElement getSuperclass(TypeElement element) {
        return (TypeElement)this.types().asElement(element.getSuperclass());
    }

    public List<TypeElement> getInterfaces(TypeElement element) {
        return element.getInterfaces().stream().map(interfaceType -> (TypeElement)this.types().asElement((TypeMirror)interfaceType)).collect(Collectors.toList());
    }

    public ExecutableElement findFirstMethodDeclarationInType(Element typeSymbol, String methodName) {
        if (typeSymbol == null) {
            return null;
        }
        if (typeSymbol.getEnclosedElements() != null) {
            for (Element element : typeSymbol.getEnclosedElements()) {
                if (!(element instanceof ExecutableElement) || !methodName.equals(element.getSimpleName().toString())) continue;
                return (ExecutableElement)element;
            }
        }
        return null;
    }

    public boolean isBoolean(TypeMirror type) {
        if (type == null) {
            return false;
        }
        switch (type.getKind()) {
            case BOOLEAN: {
                return true;
            }
        }
        return false;
    }

    public boolean isDeprecated(Element element) {
        return element.getAnnotation(Deprecated.class) != null;
    }

    public Element findFirstDeclarationInType(Element typeSymbol, String name) {
        if (typeSymbol == null) {
            return null;
        }
        if (typeSymbol.getEnclosedElements() != null) {
            for (Element element : typeSymbol.getEnclosedElements()) {
                if (!name.equals(element.getSimpleName().toString())) continue;
                return element;
            }
        }
        return null;
    }

    public Element findFirstDeclarationInClassAndSuperClasses(TypeElement typeSymbol, String name, ElementKind kind) {
        return this.findFirstDeclarationInClassAndSuperClasses(typeSymbol, name, kind, null);
    }

    public Element findFirstDeclarationInClassAndSuperClasses(TypeElement typeSymbol, String name, ElementKind kind, Integer methodArgsCount) {
        if (typeSymbol == null) {
            return null;
        }
        if (typeSymbol.getEnclosedElements() != null) {
            for (Element iterator : typeSymbol.getEnclosedElements()) {
                if (!name.equals(iterator.getSimpleName().toString()) || iterator.getKind() != kind || methodArgsCount != null && !methodArgsCount.equals(((ExecutableElement)iterator).getParameters().size())) continue;
                return iterator;
            }
        }
        if (typeSymbol instanceof TypeElement) {
            Element s = this.findFirstDeclarationInClassAndSuperClasses(this.getSuperclass(typeSymbol), name, kind, methodArgsCount);
            if (s == null && kind == ElementKind.METHOD) {
                TypeElement interfaceElement;
                Iterator<TypeElement> iterator = this.getInterfaces(typeSymbol).iterator();
                while (iterator.hasNext() && (s = this.findFirstDeclarationInClassAndSuperClasses(interfaceElement = iterator.next(), name, kind, methodArgsCount)) == null) {
                }
            }
            return s;
        }
        return null;
    }

    public boolean scanMemberDeclarationsInType(TypeElement typeSymbol, Set<String> ignoredTypeNames, Function<Element, Boolean> scanner) {
        if (typeSymbol == null) {
            return true;
        }
        if (ignoredTypeNames.contains(typeSymbol.getQualifiedName().toString())) {
            return true;
        }
        if (typeSymbol.getEnclosedElements() != null) {
            for (Element element : typeSymbol.getEnclosedElements()) {
                if (scanner.apply(element).booleanValue()) continue;
                return false;
            }
        }
        if (typeSymbol instanceof TypeElement && typeSymbol.getSuperclass() != null && !this.scanMemberDeclarationsInType(this.getSuperclass(typeSymbol), ignoredTypeNames, scanner)) {
            return false;
        }
        if (typeSymbol instanceof TypeElement && typeSymbol.getInterfaces() != null) {
            for (TypeElement typeElement : this.getInterfaces(typeSymbol)) {
                if (this.scanMemberDeclarationsInType(typeElement, ignoredTypeNames, scanner)) continue;
                return false;
            }
        }
        return true;
    }

    public VariableTree findParameter(MethodTree method, String name) {
        for (VariableTree variableTree : method.getParameters()) {
            if (!name.equals(variableTree.getName().toString())) continue;
            return variableTree;
        }
        return null;
    }

    public boolean isInvocable(ExecutableType from, ExecutableType target) {
        if (from.getParameterTypes().size() != target.getParameterTypes().size()) {
            return false;
        }
        for (int i = 0; i < from.getParameterTypes().size(); ++i) {
            if (this.types().isAssignable(this.types().erasure(from.getParameterTypes().get(i)), this.types().erasure(target.getParameterTypes().get(i)))) continue;
            return false;
        }
        return true;
    }

    public String getTypeInitalValue(String typeName) {
        if (typeName == null) {
            return "null";
        }
        switch (typeName) {
            case "void": {
                return null;
            }
            case "boolean": {
                return "false";
            }
            case "number": {
                return "0";
            }
        }
        return "null";
    }

    public void findDefaultMethodsInType(Set<JSweetContext.DefaultMethodEntry> defaultMethods, JSweetContext context, TypeElement typeElement) {
        if (context.getDefaultMethods(typeElement) != null) {
            defaultMethods.addAll(context.getDefaultMethods(typeElement));
        }
        for (TypeElement interfaceElement : this.getInterfaces(typeElement)) {
            this.findDefaultMethodsInType(defaultMethods, context, interfaceElement);
        }
    }

    public VariableElement findFieldDeclaration(TypeElement classSymbol, Name name) {
        if (classSymbol == null) {
            return null;
        }
        for (Element element : classSymbol.getEnclosedElements()) {
            VariableElement field;
            if (!(element instanceof VariableElement) || !(field = (VariableElement)element).getSimpleName().toString().equals(name.toString())) continue;
            return field;
        }
        if (classSymbol.getSuperclass() != null) {
            return this.findFieldDeclaration(this.getSuperclass(classSymbol), name);
        }
        return null;
    }

    public boolean isGlobalsClassName(String qualifiedName) {
        return qualifiedName != null && ("Globals".equals(qualifiedName) || qualifiedName.endsWith(".Globals"));
    }

    public boolean isVarargs(VariableTree varDecl) {
        VariableElement varElement = (VariableElement)Util.getElement(varDecl);
        return this.isVarargs(varElement);
    }

    public boolean isVarargs(VariableElement varElement) {
        Element varOwner = varElement.getEnclosingElement();
        if (!(varOwner instanceof ExecutableElement)) {
            return false;
        }
        ExecutableElement methodElement = (ExecutableElement)varOwner;
        return methodElement.isVarArgs() && methodElement.getParameters().size() > 0 && this.last(methodElement.getParameters()) == varElement;
    }

    public File toFile(JavaFileObject javaFileObject) {
        return new File(javaFileObject.getName());
    }

    public List<JavaFileObject> toJavaFileObjects(StandardJavaFileManager fileManager, Collection<File> sourceFiles) {
        Iterable<? extends JavaFileObject> javaFileObjectsIterable = fileManager.getJavaFileObjectsFromFiles(sourceFiles);
        return this.iterableToList(javaFileObjectsIterable);
    }

    public <T> List<T> iterableToList(Iterable<? extends T> iterable) {
        ArrayList result = new ArrayList();
        iterable.forEach(result::add);
        return result;
    }

    public JavaFileObject toJavaFileObject(StandardJavaFileManager fileManager, File sourceFile) throws IOException {
        List<JavaFileObject> javaFileObjects = this.toJavaFileObjects(fileManager, Arrays.asList(sourceFile));
        return javaFileObjects.isEmpty() ? null : javaFileObjects.get(0);
    }

    public String escapeRegex(String regex) {
        Matcher match = REGEX_CHARS.matcher(regex);
        return match.replaceAll("\\\\$1");
    }

    @SafeVarargs
    public final <T> List<T> list(T ... items) {
        ArrayList<T> list = new ArrayList<T>(items.length);
        for (T item : items) {
            list.add(item);
        }
        return list;
    }

    public boolean isAssignable(Types types, TypeElement to, TypeElement from) {
        if (to.equals(from)) {
            return true;
        }
        return types.isAssignable(from.asType(), to.asType());
    }

    public boolean containsAssignableType(List<? extends TypeMirror> list, TypeMirror type) {
        for (TypeMirror typeMirror : list) {
            if (this.types().isSameType(typeMirror, type)) {
                return true;
            }
            if (IS_ASSIGABLE_FORBBIDEN_TYPES.contains((Object)typeMirror.getKind()) || IS_ASSIGABLE_FORBBIDEN_TYPES.contains((Object)type.getKind()) || !this.types().isAssignable(typeMirror, type)) continue;
            return true;
        }
        return false;
    }

    public String getRelativePath(Element fromSymbol, Element toSymbol) {
        return this.getRelativePath("/" + this.getQualifiedName(fromSymbol).replace('.', '/'), "/" + this.getQualifiedName(toSymbol).replace('.', '/'));
    }

    public String getRelativePath(String fromPath, String toPath) {
        StringBuilder relativePath = null;
        if (!(fromPath = fromPath.replaceAll("\\\\", "/")).equals(toPath = toPath.replaceAll("\\\\", "/"))) {
            String[] toSegments;
            String[] fromSegments = fromPath.split("/");
            int length = fromSegments.length < (toSegments = toPath.split("/")).length ? fromSegments.length : toSegments.length;
            int lastCommonRoot = -1;
            int index = 0;
            while (index < length && fromSegments[index].equals(toSegments[index])) {
                lastCommonRoot = index++;
            }
            if (lastCommonRoot != -1) {
                relativePath = new StringBuilder();
                for (index = lastCommonRoot + 1; index < fromSegments.length; ++index) {
                    if (fromSegments[index].length() <= 0) continue;
                    relativePath.append("../");
                }
                for (index = lastCommonRoot + 1; index < toSegments.length - 1; ++index) {
                    relativePath.append(toSegments[index] + "/");
                }
                if (!fromPath.startsWith(toPath)) {
                    relativePath.append(toSegments[toSegments.length - 1]);
                } else if (relativePath.length() > 0) {
                    relativePath.deleteCharAt(relativePath.length() - 1);
                }
            }
        }
        return relativePath == null ? null : relativePath.toString();
    }

    public String removeExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return fileName;
        }
        return fileName.substring(0, index);
    }

    public boolean containsFile(File dir, File[] files) {
        for (File child : dir.listFiles()) {
            if (child.isDirectory()) {
                if (!this.containsFile(child, files)) continue;
                return true;
            }
            for (File file : files) {
                if (!child.getAbsolutePath().equals(file.getAbsolutePath())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isIntegral(TypeMirror type) {
        if (type == null) {
            return false;
        }
        switch (type.getKind()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return true;
            }
        }
        return false;
    }

    public boolean isNumber(TypeMirror type) {
        if (type == null) {
            return false;
        }
        switch (type.getKind()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case DOUBLE: 
            case FLOAT: {
                return true;
            }
        }
        return false;
    }

    public boolean isStringType(TypeMirror type) {
        return this.isType(type, String.class);
    }

    public boolean isVoidType(TypeMirror type) {
        return this.isType(type, Void.class) || type.getKind() == TypeKind.VOID;
    }

    public boolean isType(TypeMirror type, Class<?> potentielTypeClass) {
        return type != null && potentielTypeClass != null && this.types().isSameType(this.getType(potentielTypeClass), type);
    }

    public boolean isCoreType(TypeMirror type) {
        if (type == null) {
            return false;
        }
        if (this.isStringType(type)) {
            return true;
        }
        switch (type.getKind()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case DOUBLE: 
            case FLOAT: 
            case CHAR: {
                return true;
            }
        }
        return false;
    }

    public String toOperator(Tree.Kind kind) {
        switch (kind) {
            case MINUS: 
            case UNARY_MINUS: {
                return "-";
            }
            case PLUS: 
            case UNARY_PLUS: {
                return "+";
            }
            case MULTIPLY: {
                return "*";
            }
            case DIVIDE: {
                return "/";
            }
            case AND: {
                return "&";
            }
            case AND_ASSIGNMENT: {
                return "&=";
            }
            case OR_ASSIGNMENT: {
                return "|=";
            }
            case DIVIDE_ASSIGNMENT: {
                return "/=";
            }
            case REMAINDER_ASSIGNMENT: {
                return "%=";
            }
            case LEFT_SHIFT_ASSIGNMENT: {
                return "<<=";
            }
            case RIGHT_SHIFT_ASSIGNMENT: {
                return ">>=";
            }
            case MINUS_ASSIGNMENT: {
                return "-=";
            }
            case MULTIPLY_ASSIGNMENT: {
                return "*=";
            }
            case PLUS_ASSIGNMENT: {
                return "+=";
            }
            case XOR_ASSIGNMENT: {
                return "^=";
            }
            case LEFT_SHIFT: {
                return "<<";
            }
            case RIGHT_SHIFT: {
                return ">>";
            }
            case OR: {
                return "|";
            }
            case XOR: {
                return "^";
            }
            case ASSIGNMENT: {
                return "=";
            }
            case BITWISE_COMPLEMENT: {
                return "~";
            }
            case CONDITIONAL_AND: {
                return "&&";
            }
            case CONDITIONAL_OR: {
                return "||";
            }
            case EQUAL_TO: {
                return "==";
            }
            case GREATER_THAN: {
                return ">";
            }
            case GREATER_THAN_EQUAL: {
                return ">=";
            }
            case LESS_THAN: {
                return "<";
            }
            case LESS_THAN_EQUAL: {
                return "<=";
            }
            case LOGICAL_COMPLEMENT: {
                return "!";
            }
            case NOT_EQUAL_TO: {
                return "!=";
            }
            case POSTFIX_DECREMENT: 
            case PREFIX_DECREMENT: {
                return "--";
            }
            case POSTFIX_INCREMENT: 
            case PREFIX_INCREMENT: {
                return "++";
            }
            case REMAINDER: {
                return "%";
            }
            case UNSIGNED_RIGHT_SHIFT: {
                return ">>>";
            }
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                return ">>>=";
            }
        }
        return null;
    }

    public boolean isArithmeticOrLogicalOperator(Tree.Kind kind) {
        switch (kind) {
            case MINUS: 
            case PLUS: 
            case MULTIPLY: 
            case DIVIDE: 
            case AND: 
            case AND_ASSIGNMENT: 
            case OR_ASSIGNMENT: 
            case DIVIDE_ASSIGNMENT: 
            case REMAINDER_ASSIGNMENT: 
            case LEFT_SHIFT_ASSIGNMENT: 
            case RIGHT_SHIFT_ASSIGNMENT: 
            case MINUS_ASSIGNMENT: 
            case MULTIPLY_ASSIGNMENT: 
            case PLUS_ASSIGNMENT: 
            case XOR_ASSIGNMENT: 
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: 
            case OR: 
            case XOR: 
            case UNSIGNED_RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                return true;
            }
        }
        return false;
    }

    public boolean isArithmeticOperator(Tree.Kind kind) {
        switch (kind) {
            case MINUS: 
            case PLUS: 
            case MULTIPLY: 
            case DIVIDE: {
                return true;
            }
        }
        return false;
    }

    public boolean isComparisonOperator(Tree.Kind kind) {
        switch (kind) {
            case EQUAL_TO: 
            case GREATER_THAN: 
            case GREATER_THAN_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_EQUAL: 
            case NOT_EQUAL_TO: {
                return true;
            }
        }
        return false;
    }

    public boolean isParent(TypeElement type, TypeElement toFind) {
        if (!(type instanceof TypeElement)) {
            return false;
        }
        TypeElement clazz = type;
        if (clazz.equals(toFind)) {
            return true;
        }
        if (this.isParent(this.getSuperclass(clazz), toFind)) {
            return true;
        }
        for (TypeElement interfaceElement : this.getInterfaces(clazz)) {
            if (!this.isParent(interfaceElement, toFind)) continue;
            return true;
        }
        return false;
    }

    public boolean hasParent(TypeElement clazz, String ... qualifiedNamesToFind) {
        if (clazz == null) {
            return false;
        }
        if (ArrayUtils.contains((Object[])qualifiedNamesToFind, (Object)clazz.getQualifiedName().toString())) {
            return true;
        }
        if (this.hasParent(this.getSuperclass(clazz), qualifiedNamesToFind)) {
            return true;
        }
        for (TypeElement interfaceElement : this.getInterfaces(clazz)) {
            if (!this.hasParent(interfaceElement, qualifiedNamesToFind)) continue;
            return true;
        }
        return false;
    }

    public PackageElement getPackageByName(String qualifiedName) {
        Iterator<? extends PackageElement> matchingPackagesIterator = this.elements().getAllPackageElements(qualifiedName).iterator();
        return matchingPackagesIterator.hasNext() ? matchingPackagesIterator.next() : null;
    }

    public String getPackageFullNameForCompilationUnit(CompilationUnitTree compilationUnitTree) {
        PackageTree compilUnitPackage = compilationUnitTree.getPackage();
        if (compilUnitPackage == null) {
            return "";
        }
        return compilUnitPackage.getPackageName().toString();
    }

    public TypeElement getTypeElementByName(JSweetContext context, String qualifiedName) {
        return this.elements().getTypeElement(qualifiedName);
    }

    public boolean hasVarargs(ExecutableElement methodSymbol) {
        return methodSymbol != null && methodSymbol.getParameters().size() > 0 && methodSymbol.isVarArgs();
    }

    public boolean hasTypeParameters(ExecutableElement methodSymbol) {
        if (methodSymbol != null && methodSymbol.getParameters().size() > 0) {
            for (VariableElement variableElement : methodSymbol.getParameters()) {
                TypeMirror paramType = variableElement.asType();
                if (variableElement.getKind() != ElementKind.TYPE_PARAMETER && paramType.getKind() != TypeKind.TYPEVAR) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isImported(CompilationUnitTree compilationUnit, TypeElement type) {
        for (ImportTree importTree : compilationUnit.getImports()) {
            TypeElement importedTypeElement;
            if (importTree.isStatic() || (importedTypeElement = this.getImportedTypeElement(importTree, compilationUnit)) != type) continue;
            return true;
        }
        return false;
    }

    public TypeElement getStaticImportTarget(CompilationUnitTree compilationUnit, String name) {
        if (compilationUnit == null) {
            return null;
        }
        for (ImportTree importTree : compilationUnit.getImports()) {
            if (!importTree.isStatic() || !importTree.getQualifiedIdentifier().toString().endsWith("." + name)) continue;
            return this.getImportedTypeElement(importTree, compilationUnit);
        }
        return null;
    }

    public TypeElement getImportedTypeElement(ImportTree importTree, CompilationUnitTree compilationUnit) {
        if (!importTree.isStatic()) {
            Object importedType = Util.getType(importTree.getQualifiedIdentifier());
            return importedType == null ? null : (TypeElement)this.types().asElement((TypeMirror)importedType);
        }
        if (importTree.getQualifiedIdentifier() instanceof MemberSelectTree) {
            Object importedElement;
            MemberSelectTree qualified = (MemberSelectTree)importTree.getQualifiedIdentifier();
            if (qualified.getExpression() instanceof MemberSelectTree) {
                qualified = (MemberSelectTree)qualified.getExpression();
            }
            if ((importedElement = Util.getElement(qualified)) instanceof TypeElement) {
                return (TypeElement)importedElement;
            }
        }
        return null;
    }

    public boolean isConstant(ExpressionTree expr) {
        Object element;
        boolean constant = false;
        if (expr instanceof LiteralTree) {
            constant = true;
        } else if ((expr instanceof MemberSelectTree || expr instanceof IdentifierTree) && (element = Util.getElement(expr)).getModifiers().containsAll(Arrays.asList(Modifier.STATIC, Modifier.FINAL))) {
            constant = true;
        }
        return constant;
    }

    public boolean isNullLiteral(Tree tree) {
        return tree instanceof LiteralTree && ((LiteralTree)tree).getValue() == null;
    }

    public boolean isConstantOrNullField(VariableTree var) {
        return !var.getModifiers().getFlags().contains((Object)Modifier.STATIC) && (var.getInitializer() == null || var.getModifiers().getFlags().contains((Object)Modifier.FINAL) && var.getInitializer() instanceof LiteralTree);
    }

    public String getTypeInitialValue(TypeMirror type) {
        if (type == null) {
            return "null";
        }
        if (this.isNumber(type)) {
            return "0";
        }
        if (type.getKind() == TypeKind.BOOLEAN) {
            return "false";
        }
        if (type.getKind() == TypeKind.VOID) {
            return null;
        }
        return "null";
    }

    public List<Element> getAllMembers(TypeElement typeElement) {
        if (typeElement == null) {
            return Collections.emptyList();
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Element element : typeElement.getEnclosedElements()) {
            elements.add(element);
        }
        elements.addAll(this.getAllMembers(typeElement.getSuperclass()));
        return elements;
    }

    private List<Element> getAllMembers(TypeMirror type) {
        if (type == null) {
            return Collections.emptyList();
        }
        return this.getAllMembers((TypeElement)this.context.types.asElement(type));
    }

    public Element getFirstTypeArgumentAsElement(DeclaredType type) {
        if (type == null || type.getTypeArguments().isEmpty()) {
            return null;
        }
        TypeMirror firstTypeArg = type.getTypeArguments().get(0);
        return this.types().asElement(firstTypeArg);
    }

    public TypeMirror getFirstTypeArgument(DeclaredType type) {
        if (type == null || type.getTypeArguments().isEmpty()) {
            return null;
        }
        return type.getTypeArguments().get(0);
    }

    public boolean hasAbstractMethod(TypeElement classSymbol) {
        for (Element element : classSymbol.getEnclosedElements()) {
            if (!(element instanceof ExecutableElement) || !((ExecutableElement)element).getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            return true;
        }
        return false;
    }

    public boolean isOverridingBuiltInJavaObjectMethod(ExecutableElement method) {
        switch (method.toString()) {
            case "toString()": 
            case "hashCode()": 
            case "equals(java.lang.Object)": {
                return true;
            }
        }
        return false;
    }

    public List<ClassTree> getSortedClassDeclarations(List<? extends Tree> decls, CompilationUnitTree compilationUnit) {
        List<ClassTree> classDecls = decls.stream().filter(d -> d instanceof ClassTree).map(d -> (ClassTree)d).collect(Collectors.toList());
        DirectedGraph<ClassTree> defs = new DirectedGraph<ClassTree>();
        List<TypeElement> typeElements = classDecls.stream().map(d -> (TypeElement)Util.getElement(d)).collect(Collectors.toList());
        defs.add((T[])classDecls.toArray(new ClassTree[0]));
        for (int i = 0; i < typeElements.size(); ++i) {
            int superClassIndex = this.indexOfSuperclass(typeElements, (TypeElement)typeElements.get(i));
            if (superClassIndex < 0) continue;
            defs.addEdge((ClassTree)classDecls.get(superClassIndex), (ClassTree)classDecls.get(i));
        }
        return defs.topologicalSort(null);
    }

    private int indexOfSuperclass(List<TypeElement> symbols, TypeElement clazz) {
        int superClassIndex = symbols.indexOf(this.types().asElement(clazz.getSuperclass()));
        if (superClassIndex < 0) {
            for (Element element : clazz.getEnclosedElements()) {
                if (!(element instanceof TypeElement)) continue;
                return this.indexOfSuperclass(symbols, (TypeElement)element);
            }
        }
        return superClassIndex;
    }

    public TypeElement findInnerClassDeclaration(TypeElement clazz, String name) {
        if (clazz == null) {
            return null;
        }
        for (Element element : clazz.getEnclosedElements()) {
            if (!(element instanceof TypeElement) || !element.getSimpleName().toString().equals(name)) continue;
            return (TypeElement)element;
        }
        if (clazz.getSuperclass() != null) {
            return this.findInnerClassDeclaration((TypeElement)this.types().asElement(clazz.getSuperclass()), name);
        }
        return null;
    }

    public TypeMirror getOperatorType(BinaryTree binaryTree) {
        if (binaryTree == null) {
            return null;
        }
        return this.getOperatorElement(binaryTree).getReturnType();
    }

    public TypeMirror getOperatorType(CompoundAssignmentTree compoundAssignmentTree) {
        if (compoundAssignmentTree == null) {
            return null;
        }
        return this.getOperatorElement(compoundAssignmentTree).getReturnType();
    }

    public ExecutableElement getOperatorElement(BinaryTree binaryTree) {
        if (binaryTree == null) {
            return null;
        }
        try {
            return (ExecutableElement)this.javacInternals().binaryTreeOperatorField.get(binaryTree);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot call internal Javac API :( please adapt this code if API changed", e);
        }
    }

    public ExecutableElement getOperatorElement(CompoundAssignmentTree assignmentTree) {
        if (assignmentTree == null) {
            return null;
        }
        try {
            return (ExecutableElement)this.javacInternals().assignOpOperatorField.get(assignmentTree);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot call internal Javac API :( please adapt this code if API changed", e);
        }
    }

    public boolean isLiteralExpression(ExpressionTree expression) {
        if (expression == null) {
            return false;
        }
        if (expression instanceof LiteralTree) {
            return true;
        }
        if (expression instanceof BinaryTree) {
            return this.isLiteralExpression(((BinaryTree)expression).getLeftOperand()) && this.isLiteralExpression(((BinaryTree)expression).getRightOperand());
        }
        if (expression instanceof UnaryTree) {
            return this.isLiteralExpression(((UnaryTree)expression).getExpression());
        }
        return false;
    }

    public List<List<Tree>> getExecutionPaths(MethodTree methodDeclaration) {
        LinkedList<List<Tree>> executionPaths = new LinkedList<List<Tree>>();
        executionPaths.add(new LinkedList());
        LinkedList<List<Tree>> currentPaths = new LinkedList<List<Tree>>(executionPaths);
        LinkedList<BreakTree> activeBreaks = new LinkedList<BreakTree>();
        for (StatementTree statementTree : methodDeclaration.getBody().getStatements()) {
            Util.collectExecutionPaths(statementTree, executionPaths, currentPaths, activeBreaks);
        }
        return executionPaths;
    }

    private static void collectExecutionPaths(Tree currentNode, List<List<Tree>> allExecutionPaths, List<List<Tree>> currentPaths, List<BreakTree> activeBreaks) {
        for (List<Tree> currentPath : new ArrayList<List<Tree>>(currentPaths)) {
            Tree lastStatement = currentPath.isEmpty() ? null : currentPath.get(currentPath.size() - 1);
            if (lastStatement instanceof ReturnTree || lastStatement instanceof BreakTree && activeBreaks.contains(lastStatement)) continue;
            if (allExecutionPaths.size() > 20000) {
                throw new RuntimeException("too many execution paths, aborting");
            }
            currentPath.add(currentNode);
            List<List<Tree>> currentPathForksList = Util.pathsList(currentPath);
            if (currentNode instanceof IfTree) {
                IfTree ifNode = (IfTree)currentNode;
                boolean bl = true;
                Tree[] forks = new StatementTree[]{ifNode.getThenStatement(), ifNode.getElseStatement()};
                Util.evaluateForksExecutionPaths(allExecutionPaths, currentPathForksList, currentPath, bl, activeBreaks, forks);
            } else if (currentNode instanceof BlockTree) {
                for (StatementTree statementTree : ((BlockTree)currentNode).getStatements()) {
                    Util.collectExecutionPaths(statementTree, allExecutionPaths, currentPathForksList, activeBreaks);
                }
            } else if (currentNode instanceof LabeledStatementTree) {
                Util.collectExecutionPaths(((LabeledStatementTree)currentNode).getStatement(), allExecutionPaths, currentPaths, activeBreaks);
            } else if (currentNode instanceof ForLoopTree) {
                Util.collectExecutionPaths(((ForLoopTree)currentNode).getStatement(), allExecutionPaths, currentPaths, activeBreaks);
                activeBreaks.clear();
            } else if (currentNode instanceof EnhancedForLoopTree) {
                Util.collectExecutionPaths(((EnhancedForLoopTree)currentNode).getStatement(), allExecutionPaths, currentPaths, activeBreaks);
                activeBreaks.clear();
            } else if (currentNode instanceof WhileLoopTree) {
                Util.collectExecutionPaths(((WhileLoopTree)currentNode).getStatement(), allExecutionPaths, currentPaths, activeBreaks);
                activeBreaks.clear();
            } else if (currentNode instanceof DoWhileLoopTree) {
                Util.collectExecutionPaths(((DoWhileLoopTree)currentNode).getStatement(), allExecutionPaths, currentPaths, activeBreaks);
                activeBreaks.clear();
            } else if (currentNode instanceof SynchronizedTree) {
                Util.collectExecutionPaths(((SynchronizedTree)currentNode).getBlock(), allExecutionPaths, currentPaths, activeBreaks);
            } else if (currentNode instanceof TryTree) {
                TryTree tryNode = (TryTree)currentNode;
                Util.collectExecutionPaths(tryNode.getBlock(), allExecutionPaths, currentPaths, activeBreaks);
                Tree[] treeArray = tryNode.getCatches().stream().map(catchExp -> catchExp.getBlock()).collect(Collectors.toList()).toArray(new StatementTree[0]);
                Util.evaluateForksExecutionPaths(allExecutionPaths, currentPathForksList, currentPath, false, activeBreaks, treeArray);
                if (tryNode.getFinallyBlock() != null) {
                    Util.collectExecutionPaths(tryNode.getFinallyBlock(), allExecutionPaths, currentPathForksList, activeBreaks);
                }
            } else if (currentNode instanceof SwitchTree) {
                SwitchTree switchNode = (SwitchTree)currentNode;
                Util.evaluateForksExecutionPaths(allExecutionPaths, currentPathForksList, currentPath, true, activeBreaks, switchNode.getCases().toArray(new CaseTree[0]));
                activeBreaks.clear();
            } else if (currentNode instanceof CaseTree) {
                for (StatementTree statementTree : ((CaseTree)currentNode).getStatements()) {
                    Util.collectExecutionPaths(statementTree, allExecutionPaths, currentPathForksList, activeBreaks);
                }
            }
            Util.addAllWithoutDuplicates(currentPaths, currentPathForksList);
        }
    }

    private static void evaluateForksExecutionPaths(List<List<Tree>> allExecutionPaths, List<List<Tree>> currentPaths, List<Tree> currentPath, boolean lastIsCurrentPath, List<BreakTree> activeBreaks, Tree[] forks) {
        int i = 0;
        LinkedList<List<Tree>> generatedExecutionPaths = new LinkedList<List<Tree>>();
        for (Tree fork : forks) {
            List<List<Tree>> currentPathsForFork;
            if (fork == null) continue;
            if (lastIsCurrentPath && ++i == forks.length) {
                currentPathsForFork = Util.pathsList(currentPath);
            } else {
                LinkedList<Tree> forkedPath = new LinkedList<Tree>(currentPath);
                allExecutionPaths.add(forkedPath);
                currentPathsForFork = Util.pathsList(forkedPath);
            }
            Util.collectExecutionPaths(fork, allExecutionPaths, currentPathsForFork, activeBreaks);
            generatedExecutionPaths.addAll(currentPathsForFork);
        }
        Util.addAllWithoutDuplicates(currentPaths, generatedExecutionPaths);
    }

    private static List<List<Tree>> addAllWithoutDuplicates(List<List<Tree>> pathsListUnique, List<List<Tree>> listToBeAdded) {
        for (List<Tree> path : listToBeAdded) {
            boolean pathAlreadyAdded = false;
            for (List<Tree> pathFromUnique : pathsListUnique) {
                if (path != pathFromUnique) continue;
                pathAlreadyAdded = true;
            }
            if (pathAlreadyAdded) continue;
            pathsListUnique.add(path);
        }
        return pathsListUnique;
    }

    @SafeVarargs
    private static List<List<Tree>> pathsList(List<Tree> ... executionPaths) {
        LinkedList<List<Tree>> pathsList = new LinkedList<List<Tree>>();
        for (List<Tree> path : executionPaths) {
            pathsList.add(path);
        }
        return pathsList;
    }

    public boolean isDeclarationOrSubClassDeclaration(TypeMirror classType, String searchedClassName) {
        while (classType != null) {
            TypeElement typeElement = (TypeElement)this.types().asElement(classType);
            if (typeElement.getQualifiedName().toString().equals(searchedClassName)) {
                return true;
            }
            List<? extends TypeMirror> superTypes = this.types().directSupertypes(classType);
            classType = superTypes == null || superTypes.isEmpty() ? null : superTypes.get(0);
        }
        return false;
    }

    public boolean isDeclarationOrSubClassDeclarationBySimpleName(TypeMirror classType, String searchedClassSimpleName) {
        while (classType != null) {
            TypeElement typeElement = (TypeElement)this.types().asElement(classType);
            if (typeElement.getSimpleName().toString().equals(searchedClassSimpleName)) {
                return true;
            }
            List<? extends TypeMirror> superTypes = this.types().directSupertypes(classType);
            classType = superTypes == null || superTypes.isEmpty() ? null : superTypes.get(0);
        }
        return false;
    }

    public long getStartPosition(Tree tree, CompilationUnitTree compilationUnit) {
        return this.sourcePositions().getStartPosition(compilationUnit, tree);
    }

    public SourcePosition getSourcePosition(Tree tree, CompilationUnitTree compilationUnit) {
        return this.getSourcePosition(tree, null, compilationUnit);
    }

    public SourcePosition getSourcePosition(Tree tree, Name nameOffsetForEndPosition, CompilationUnitTree compilationUnit) {
        LineMap lineMap = compilationUnit.getLineMap();
        if (lineMap == null) {
            return null;
        }
        long startPosition = this.getStartPosition(tree, compilationUnit);
        long endPosition = this.sourcePositions().getEndPosition(compilationUnit, tree);
        if (endPosition == -1L) {
            endPosition = startPosition;
        }
        if (nameOffsetForEndPosition != null) {
            endPosition += (long)nameOffsetForEndPosition.length();
        }
        return new SourcePosition(new File(compilationUnit.getSourceFile().getName()), tree, (int)lineMap.getLineNumber(startPosition), (int)lineMap.getColumnNumber(startPosition), (int)lineMap.getLineNumber(endPosition), (int)lineMap.getColumnNumber(endPosition));
    }

    private SourcePositions sourcePositions() {
        return this.trees().getSourcePositions();
    }

    private Trees trees() {
        return this.context.trees;
    }

    private Types types() {
        return this.context.types;
    }

    private Elements elements() {
        return this.context.elements;
    }

    public <T extends Element> T getElementForTreePath(TreePath treePath) {
        return (T)this.trees().getElement(treePath);
    }

    public <T extends TypeMirror> T getElementTypeForTree(Tree tree, CompilationUnitTree compilationUnit) {
        T element = Util.getElement(tree);
        return (T)(element == null ? null : element.asType());
    }

    public <T extends TypeMirror> T getElementTypeForTreePath(TreePath treePath) {
        T element = this.getElementForTreePath(treePath);
        return (T)(element == null ? null : element.asType());
    }

    public <T extends TypeMirror> T getTypeForTreePath(TreePath treePath) {
        if (treePath == null) {
            return null;
        }
        TypeMirror typeMirror = this.trees().getTypeMirror(treePath);
        return (T)typeMirror;
    }

    public <T extends Element> T getParentElement(Element element, Class<T> parentElementClass) {
        Element parent = element;
        while ((parent = parent.getEnclosingElement()) != null) {
            if (!parentElementClass.isAssignableFrom(parent.getClass())) continue;
            return (T)parent;
        }
        return null;
    }

    public CompilationUnitTree getCompilationUnit(Element element) {
        TreePath treePath = this.trees().getPath(element);
        if (treePath == null) {
            return null;
        }
        return treePath.getCompilationUnit();
    }

    public TypeMirror erasureRecursive(TypeMirror type) {
        try {
            Method erasureRecursiveMethod = this.javacInternals().typesErasureRecursiveMethod;
            return (TypeMirror)erasureRecursiveMethod.invoke(this.javacInternals().typesInstance, type);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot call internal Javac API :( please adapt this code if API changed", e);
        }
    }

    public boolean isPrimitiveOrVoid(TypeMirror type) {
        return type != null && (type.getKind() == TypeKind.VOID || type instanceof PrimitiveType);
    }

    public PackageElement getParentPackage(PackageElement packageElement) {
        if (packageElement == null) {
            return null;
        }
        String packageFullName = packageElement.getQualifiedName().toString();
        int lastDotIndex = packageFullName.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return null;
        }
        return this.getPackageByName(packageFullName.substring(0, lastDotIndex));
    }

    public String getQualifiedName(Element element) {
        if (element == null) {
            return null;
        }
        if (element instanceof PackageElement || element instanceof TypeElement) {
            return element.toString();
        }
        String simpleName = element.getSimpleName().toString();
        if (element.getEnclosingElement() != null) {
            return this.getQualifiedName(element.getEnclosingElement()) + "." + simpleName;
        }
        return simpleName;
    }

    public <T> T last(List<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public boolean isInterface(Element typeElement) {
        return typeElement != null && typeElement.getKind() == ElementKind.INTERFACE;
    }

    public boolean isPartOfAnEnum(Element element) {
        if (element == null) {
            return false;
        }
        return element.getKind() == ElementKind.ENUM || element.getKind() == ElementKind.ENUM_CONSTANT;
    }

    public Element getMethodOwner(ExecutableElement methodElement) {
        Element targetType = methodElement.getEnclosingElement();
        if (targetType != null) {
            return targetType;
        }
        TypeMirror ownerType = ((ExecutableType)methodElement.asType()).getReceiverType();
        return ownerType == null ? null : this.types().asElement(ownerType);
    }

    public boolean isGeneratedConstructor(MethodTree methodTree, ClassTree parentClassTree, ExecutableElement methodElement) {
        if (!methodTree.getName().toString().equals(CONSTRUCTOR_METHOD_NAME)) {
            return false;
        }
        if (methodElement.getAnnotationMirrors().size() > 0) {
            return false;
        }
        try {
            int methodPos = (Integer)this.javacInternals().treePosField.get(methodTree);
            int parentClassPos = (Integer)this.javacInternals().treePosField.get(parentClassTree);
            return methodPos == parentClassPos;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot call internal Javac API :( please adapt this code if API changed", e);
        }
    }

    public TypeMirror unboxedTypeOrType(TypeMirror type) {
        try {
            if (this.isPrimitiveOrVoid(type)) {
                return type;
            }
            return this.types().unboxedType(type);
        }
        catch (Exception e) {
            return type;
        }
    }

    public boolean isNullType(TypeMirror type) {
        return type == null || type.getKind() == TypeKind.NULL;
    }

    public void addAnnotation(ModifiersTree modifiers, AnnotationTree annotation) {
        if (modifiers != null) {
            try {
                Object newList = this.javacInternals().listAppendMethod.invoke(modifiers.getAnnotations(), annotation);
                this.javacInternals().modifiersAnnotationsField.set(modifiers, newList);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private JavacInternals javacInternals() {
        return JavacInternals.instance(this.types());
    }

    private static JavaFileObject getSourceFileObjectFromElement(TypeElement element) {
        try {
            if (element == null) {
                return null;
            }
            Field internalSourceFileField = element.getClass().getDeclaredField("sourcefile");
            return (JavaFileObject)internalSourceFileField.get(element);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot call internal Javac API :( please adapt this code if API changed", e);
        }
    }

    public static <T extends TypeMirror> T getType(Tree tree) {
        try {
            return (T)((TypeMirror)typeField.get(tree));
        }
        catch (Exception e) {
            throw new RuntimeException("Fatal error - cannot access legacy Javac API", e);
        }
    }

    public static <E extends Element> E getElement(TypeMirror type) {
        try {
            return (E)((Element)tsymField.get(type));
        }
        catch (Exception e) {
            throw new RuntimeException("Fatal error - cannot access legacy Javac API", e);
        }
    }

    public static <E extends Element> E getTypeElement(Tree tree) {
        Object type = Util.getType(tree);
        return type == null ? null : (E)Util.getElement(type);
    }

    public static <T extends Element> T getElement(Tree tree) {
        if (tree == null) {
            return null;
        }
        try {
            Field symField = symFields.get(tree.getClass());
            if (symField == null) {
                symField = PackageTree.class.isAssignableFrom(tree.getClass()) ? tree.getClass().getDeclaredField("packge") : (NewClassTree.class.isAssignableFrom(tree.getClass()) ? tree.getClass().getDeclaredField("constructor") : tree.getClass().getDeclaredField("sym"));
                symField.setAccessible(true);
                symFields.put(tree.getClass(), symField);
            }
            return (T)((Element)symField.get(tree));
        }
        catch (Exception e) {
            throw new RuntimeException("Fatal error - cannot access legacy Javac API - " + tree.getClass(), e);
        }
    }

    public static <T extends Element> T getElementNoErrors(Tree tree) {
        if (tree == null) {
            return null;
        }
        try {
            Field symField = symFields.get(tree.getClass());
            if (symField == null) {
                symField = PackageTree.class.isAssignableFrom(tree.getClass()) ? tree.getClass().getDeclaredField("packge") : (NewClassTree.class.isAssignableFrom(tree.getClass()) ? tree.getClass().getDeclaredField("constructor") : tree.getClass().getDeclaredField("sym"));
                symField.setAccessible(true);
                symFields.put(tree.getClass(), symField);
            }
            return (T)((Element)symField.get(tree));
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        symFields = new HashMap();
        try {
            ClassLoader classLoader = JavacInternals.class.getClassLoader();
            typeField = classLoader.loadClass("com.sun.tools.javac.tree.JCTree").getDeclaredField("type");
            typeField.setAccessible(true);
            tsymField = classLoader.loadClass("com.sun.tools.javac.code.Type").getDeclaredField("tsym");
            tsymField.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException("Fatal error - cannot access legacy Javac API", e);
        }
    }

    private static class JavacInternals {
        private static JavacInternals instance;
        final Class<?> typesClass;
        final Class<?> typeClass;
        final Method typesErasureRecursiveMethod;
        final Object typesInstance;
        final Field binaryTreeOperatorField;
        final Field assignOpOperatorField;
        final Field treePosField;
        final Field treeTypeField;
        final Field modifiersAnnotationsField;
        final Method listAppendMethod;
        private final Map<Class, Field> treeClassToSymbolField = new HashMap<Class, Field>();
        private final Map<Class, Field> treeClassToTypeSymbolField = new HashMap<Class, Field>();

        private JavacInternals(Types types) {
            try {
                this.typesClass = this.getClass().getClassLoader().loadClass("com.sun.tools.javac.code.Types");
                this.typeClass = this.getClass().getClassLoader().loadClass("com.sun.tools.javac.code.Type");
                this.typesErasureRecursiveMethod = this.typesClass.getMethod("erasureRecursive", this.typeClass);
                Class<?> JCTreeClass = this.getClass().getClassLoader().loadClass("com.sun.tools.javac.tree.JCTree");
                this.binaryTreeOperatorField = Stream.of(JCTreeClass.getDeclaredClasses()).filter(innerClass -> innerClass.getSimpleName().equals("JCBinary")).findFirst().get().getField("operator");
                this.assignOpOperatorField = Stream.of(JCTreeClass.getDeclaredClasses()).filter(innerClass -> innerClass.getSimpleName().equals("JCAssignOp")).findFirst().get().getField("operator");
                Field typesField = types.getClass().getDeclaredField("types");
                typesField.trySetAccessible();
                this.typesInstance = typesField.get(types);
                this.treePosField = JCTreeClass.getDeclaredField("pos");
                this.treeTypeField = JCTreeClass.getDeclaredField("type");
                Class JCModifiersClass = Stream.of(JCTreeClass.getDeclaredClasses()).filter(innerClass -> innerClass.getSimpleName().equals("JCModifiers")).findFirst().get();
                this.modifiersAnnotationsField = JCModifiersClass.getDeclaredField("annotations");
                Class<?> listClass = this.getClass().getClassLoader().loadClass("com.sun.tools.javac.util.List");
                this.listAppendMethod = listClass.getMethod("append", Object.class);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot call internal Javac API :( please adapt this code if API changed", e);
            }
        }

        static JavacInternals instance(Types types) {
            if (instance == null) {
                instance = new JavacInternals(types);
            }
            return instance;
        }

        JavaFileObject getSourceFileObjectFromElement(TypeElement element) {
            try {
                if (element == null) {
                    return null;
                }
                Field internalSourceFileField = element.getClass().getDeclaredField("sourcefile");
                return (JavaFileObject)internalSourceFileField.get(element);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot call internal Javac API :( please adapt this code if API changed", e);
            }
        }
    }

    public static class Static {
        public static void addFiles(String extension, File file, Collection<File> files) {
            Static.addFiles((File f) -> f.getName().endsWith(extension), file, files);
        }

        public static void addFiles(Predicate<File> filter, File file, Collection<File> files) {
            if (file.isDirectory()) {
                for (File f : file.listFiles()) {
                    Static.addFiles(filter, f, files);
                }
            } else if (filter.test(file)) {
                files.add(file);
            }
        }

        public static <T> T newInstance(String fullClassName) {
            String errorMessage = "cannot find or instantiate class: " + fullClassName + " (make sure the class is in the plugin's classpath and that it defines an empty public constructor)";
            Class<?> clazz = null;
            try {
                clazz = Thread.currentThread().getContextClassLoader().loadClass(fullClassName);
            }
            catch (Exception e) {
                try {
                    clazz = Class.forName(fullClassName);
                }
                catch (Exception e2) {
                    throw new RuntimeException(errorMessage, e2);
                }
            }
            try {
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                return (T)constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(errorMessage, e);
            }
        }
    }
}

