/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.util;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;
import javax.lang.model.element.Element;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import org.jsweet.transpiler.JSweetContext;
import org.jsweet.transpiler.SourcePosition;
import org.jsweet.transpiler.TranspilationHandler;
import org.jsweet.transpiler.TypeChecker;
import org.jsweet.transpiler.extension.PrinterAdapter;
import org.jsweet.transpiler.util.AbstractTreeScanner;
import org.jsweet.transpiler.util.Position;
import org.jsweet.transpiler.util.SourceMap;
import org.jsweet.transpiler.util.Util;

public abstract class AbstractTreePrinter
extends AbstractTreeScanner {
    private Stack<Position> positionStack = new Stack();
    private Set<Tree> inlinedExpressions = new HashSet<Tree>();
    public StringBuilder footer = new StringBuilder();
    protected static final String INDENT = "    ";
    private StringBuilder out = new StringBuilder();
    private int indent = 0;
    private PrinterAdapter adapter;
    public TypeChecker typeChecker;
    private int currentLine = 1;
    private int currentColumn = 0;
    private boolean fillSourceMap = true;
    public SourceMap sourceMap = new SourceMap();
    protected boolean inArgListTail = false;

    public boolean isInlinedExpression(Tree tree) {
        return this.inlinedExpressions.contains(tree);
    }

    public void addInlinedExpression(Tree tree) {
        this.inlinedExpressions.add(tree);
    }

    public void clearInlinedExpression() {
        this.inlinedExpressions.clear();
    }

    public Stack<Position> getPositionStack() {
        return this.positionStack;
    }

    public AbstractTreePrinter(TranspilationHandler logHandler, JSweetContext context, CompilationUnitTree compilationUnit, PrinterAdapter adapter, boolean fillSourceMap) {
        super(logHandler, context, compilationUnit);
        this.typeChecker = new TypeChecker(this);
        this.adapter = adapter;
        this.adapter.setPrinter(this);
        this.fillSourceMap = fillSourceMap;
    }

    public String getStringLiteralQuote() {
        return this.getContext().options.isUseSingleQuotesForStringLiterals() ? "'" : "\"";
    }

    public String getOutput() {
        return this.out.toString();
    }

    public AbstractTreePrinter print(Tree tree) {
        this.scan(tree, this.context.trees);
        return this;
    }

    @Override
    protected void enter(Tree tree) {
        super.enter(tree);
        this.positionStack.push(new Position(this.getCurrentPosition(), this.currentLine, this.currentColumn));
        if (this.compilationUnit != null && this.inSourceMap(tree)) {
            SourcePosition sourcePosition = this.util().getSourcePosition(tree, this.compilationUnit);
            Position startPosition = sourcePosition.getStartPosition();
            this.sourceMap.addEntry(startPosition, this.positionStack.peek());
        }
    }

    private boolean inSourceMap(Tree tree) {
        return tree instanceof ExpressionTree || tree instanceof StatementTree || tree instanceof MethodTree;
    }

    @Override
    protected void onRollbacked(Tree target) {
        super.onRollbacked(target);
        Position position = this.positionStack.peek();
        this.out.delete(position.getPosition(), this.out.length());
        this.currentColumn = position.getColumn();
        this.currentLine = position.getLine();
    }

    @Override
    protected void exit() {
        Tree tree = (Tree)this.stack.peek();
        if (this.compilationUnit != null && tree instanceof BlockTree) {
            SourcePosition sourcePosition = this.util().getSourcePosition(tree, this.compilationUnit);
            Position endPosition = sourcePosition.getEndPosition();
            this.sourceMap.addEntry(endPosition, new Position(this.getCurrentPosition(), this.currentLine, this.currentColumn));
        }
        super.exit();
        this.positionStack.pop();
    }

    public int getCurrentPosition() {
        return this.out.length();
    }

    public char getLastPrintedChar() {
        return this.out.charAt(this.out.length() - 1);
    }

    public String getLastPrintedString(int length) {
        return this.out.substring(this.out.length() - length);
    }

    public AbstractTreePrinter printIndent() {
        for (int i = 0; i < this.indent; ++i) {
            this.print(INDENT);
        }
        return this;
    }

    public String getIndentString() {
        Object indentString = "";
        for (int i = 0; i < this.indent; ++i) {
            indentString = (String)indentString + INDENT;
        }
        return indentString;
    }

    public AbstractTreePrinter startIndent() {
        ++this.indent;
        return this;
    }

    public AbstractTreePrinter endIndent() {
        --this.indent;
        return this;
    }

    public AbstractTreePrinter print(String string) {
        this.out.append(string);
        this.currentColumn += string.length();
        return this;
    }

    public AbstractTreePrinter println(String string) {
        return this.print(string).println();
    }

    public AbstractTreePrinter printIdentifier(Element symbol) {
        String adaptedIdentifier = this.context.getActualName(symbol);
        return this.print(adaptedIdentifier);
    }

    public String getQualifiedTypeName(Element type, boolean globals, boolean ignoreLangTypes) {
        return this.getRootRelativeName(type);
    }

    public String getIdentifier(Element symbol) {
        return this.context.getActualName(symbol);
    }

    public AbstractTreePrinter space() {
        return this.print(" ");
    }

    public boolean removeLastChar(char expectedChar) {
        if (this.getLastPrintedChar() == expectedChar) {
            this.removeLastChar();
            return true;
        }
        return false;
    }

    public AbstractTreePrinter removeLastChar() {
        if (this.out.length() == 0) {
            return this;
        }
        if (this.out.charAt(this.out.length() - 1) == '\n') {
            --this.currentLine;
            this.currentColumn = 0;
        } else {
            --this.currentColumn;
        }
        this.out.deleteCharAt(this.out.length() - 1);
        return this;
    }

    public AbstractTreePrinter removeLastChars(int count) {
        for (int i = 0; i < count; ++i) {
            this.removeLastChar();
        }
        return this;
    }

    public AbstractTreePrinter removeLastIndent() {
        this.removeLastChars(this.indent * INDENT.length());
        return this;
    }

    public AbstractTreePrinter println() {
        this.out.append("\n");
        ++this.currentLine;
        this.currentColumn = 0;
        return this;
    }

    public String getResult() {
        return this.out.toString();
    }

    public PrinterAdapter getAdapter() {
        return this.adapter;
    }

    public void setAdapter(PrinterAdapter adapter) {
        this.adapter = adapter;
    }

    public AbstractTreePrinter printArgList(List<? extends TypeMirror> assignedTypes, List<? extends Tree> args, Consumer<Tree> printer) {
        int i = 0;
        for (Tree tree : args) {
            if (printer != null) {
                printer.accept(tree);
            } else if (assignedTypes != null && tree instanceof ExpressionTree && i < assignedTypes.size()) {
                if (!this.substituteAssignedExpression(assignedTypes.get(i++), (ExpressionTree)tree)) {
                    this.print(tree);
                }
            } else {
                this.print(tree);
            }
            this.print(", ");
            this.inArgListTail = true;
        }
        this.inArgListTail = false;
        if (!args.isEmpty()) {
            this.removeLastChars(2);
        }
        return this;
    }

    public AbstractTreePrinter substituteAndPrintAssignedExpression(TypeMirror assignedType, ExpressionTree expression) {
        if (!this.substituteAssignedExpression(assignedType, expression)) {
            this.print(expression);
        }
        return this;
    }

    protected abstract boolean substituteAssignedExpression(TypeMirror var1, ExpressionTree var2);

    public AbstractTreePrinter printArgList(MethodInvocationTree invocationTree) {
        List<? extends ExpressionTree> arguments = invocationTree.getArguments();
        for (int i = 0; i < arguments.size(); ++i) {
            ExpressionTree arg = arguments.get(i);
            Object methodType = Util.getType(invocationTree.getMethodSelect());
            if (methodType != null) {
                TypeMirror paramType;
                List<? extends TypeMirror> argTypes = ((ExecutableType)methodType).getParameterTypes();
                TypeMirror typeMirror = paramType = i < argTypes.size() ? argTypes.get(i) : argTypes.get(argTypes.size() - 1);
                if (!this.substituteAssignedExpression(paramType, arg)) {
                    this.print(arg);
                }
            }
            if (i >= arguments.size() - 1) continue;
            this.print(", ");
        }
        return this;
    }

    public AbstractTreePrinter printArgList(List<? extends TypeMirror> assignedTypes, List<? extends Tree> args) {
        return this.printArgList(assignedTypes, args, null);
    }

    public abstract AbstractTreePrinter printConstructorArgList(NewClassTree var1, boolean var2);

    public abstract AbstractTreePrinter substituteAndPrintType(Tree var1);

    public AbstractTreePrinter printVarNameList(List<VariableTree> args) {
        for (VariableTree arg : args) {
            this.print(arg.getName().toString());
            this.print(", ");
        }
        if (!args.isEmpty()) {
            this.removeLastChars(2);
        }
        return this;
    }

    public AbstractTreePrinter printTypeArgList(List<? extends Tree> args) {
        for (Tree tree : args) {
            this.substituteAndPrintType(tree);
            this.print(", ");
        }
        if (!args.isEmpty()) {
            this.removeLastChars(2);
        }
        return this;
    }

    public int getCurrentLine() {
        return this.currentLine;
    }

    public int getCurrentColumn() {
        return this.currentColumn;
    }

    public boolean isFillSourceMap() {
        return this.fillSourceMap;
    }

    public String getRootRelativeName(Element element) {
        return this.context.getRootRelativeName(this.context.useModules ? this.context.getImportedElements(this.compilationUnit.getSourceFile().getName()) : null, element);
    }

    public String getRootRelativeName(Element element, boolean useJavaNames) {
        return this.context.getRootRelativeName(this.context.useModules ? this.context.getImportedElements(this.compilationUnit.getSourceFile().getName()) : null, element, useJavaNames);
    }

    public int getIndent() {
        return this.indent;
    }
}

