/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.model.support;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.jsweet.transpiler.model.ExtendedElement;
import org.jsweet.transpiler.model.MethodInvocationElement;
import org.jsweet.transpiler.model.support.ExtendedElementSupport;
import org.jsweet.transpiler.util.Util;

public class MethodInvocationElementSupport
extends ExtendedElementSupport<MethodInvocationTree>
implements MethodInvocationElement {
    public MethodInvocationElementSupport(MethodInvocationTree tree) {
        super(tree);
    }

    @Override
    public List<ExtendedElement> getArguments() {
        return ((MethodInvocationTree)this.tree).getArguments().stream().map(this::createElement).collect(Collectors.toList());
    }

    @Override
    public int getArgumentCount() {
        return ((MethodInvocationTree)this.tree).getArguments().size();
    }

    @Override
    public List<ExtendedElement> getArgumentTail() {
        return ((MethodInvocationTree)this.tree).getArguments().stream().skip(1L).map(this::createElement).collect(Collectors.toList());
    }

    @Override
    public ExtendedElement getArgument(int i) {
        return this.createElement(((MethodInvocationTree)this.tree).getArguments().get(i));
    }

    @Override
    public String getMethodName() {
        ExpressionTree methodTree = ((MethodInvocationTree)this.tree).getMethodSelect();
        if (methodTree instanceof IdentifierTree) {
            return methodTree.toString();
        }
        if (methodTree instanceof MemberSelectTree) {
            return ((MemberSelectTree)methodTree).getIdentifier().toString();
        }
        return null;
    }

    @Override
    public ExecutableElement getMethod() {
        ExpressionTree methodTree = ((MethodInvocationTree)this.tree).getMethodSelect();
        return (ExecutableElement)Util.getElement(methodTree);
    }

    @Override
    public ExtendedElement getTargetExpression() {
        ExpressionTree methTree = ((MethodInvocationTree)this.tree).getMethodSelect();
        if (methTree instanceof MemberSelectTree) {
            return this.createElement(((MemberSelectTree)methTree).getExpression());
        }
        return null;
    }

    @Override
    public TypeMirror getTargetType() {
        ExtendedElement targetExpression = this.getTargetExpression();
        return targetExpression == null ? null : targetExpression.getType();
    }
}

