/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.model.support;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.jsweet.transpiler.JSweetContext;
import org.jsweet.transpiler.SourcePosition;
import org.jsweet.transpiler.model.ExtendedElement;
import org.jsweet.transpiler.model.ExtendedElementFactory;
import org.jsweet.transpiler.util.Util;

public class ExtendedElementSupport<T extends Tree>
implements ExtendedElement {
    protected final T tree;

    public ExtendedElementSupport(T tree) {
        Objects.requireNonNull(tree);
        this.tree = tree;
    }

    public T getTree() {
        return this.tree;
    }

    @Override
    public TypeMirror getType() {
        return Util.getType(this.tree);
    }

    @Override
    public Element getTypeAsElement() {
        TypeMirror type = this.getType();
        return type == null ? null : (Element)Util.getElement(type);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExtendedElementSupport)) {
            return false;
        }
        return this.tree == ((ExtendedElementSupport)obj).tree;
    }

    public int hashCode() {
        return this.tree.hashCode();
    }

    public String toString() {
        return this.tree.toString();
    }

    @Override
    public boolean isConstant() {
        if (!(this.getTree() instanceof ExpressionTree)) {
            return false;
        }
        return JSweetContext.current.get().util.isConstant((ExpressionTree)this.getTree());
    }

    @Override
    public boolean isStringLiteral() {
        return this.getTree().getKind() == Tree.Kind.STRING_LITERAL;
    }

    protected ExtendedElement createElement(Tree tree) {
        return ExtendedElementFactory.INSTANCE.create(tree);
    }

    @Override
    public SourcePosition getSourcePosition() {
        return JSweetContext.current.get().util.getSourcePosition((Tree)this.tree, JSweetContext.currentCompilationUnit.get());
    }
}

