/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.extension;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import javax.lang.model.element.Element;
import org.jsweet.transpiler.extension.PrinterAdapter;
import org.jsweet.transpiler.model.MethodInvocationElement;
import org.jsweet.transpiler.model.NewClassElement;

public class MapAdapter
extends PrinterAdapter {
    protected static String[] mapTypes = new String[]{Map.class.getName(), HashMap.class.getName(), TreeMap.class.getName(), Hashtable.class.getName()};

    public MapAdapter(PrinterAdapter parent) {
        super(parent);
        for (String mapType : mapTypes) {
            this.addTypeMapping(mapType, "any");
        }
    }

    @Override
    public boolean substituteNewClass(NewClassElement newClass) {
        String className = newClass.getTypeAsElement().toString();
        if (Arrays.binarySearch(mapTypes, className) >= 0) {
            this.print("new Map(").printArgList(newClass.getArguments()).print(")");
            return true;
        }
        return super.substituteNewClass(newClass);
    }

    @Override
    public boolean substituteMethodInvocation(MethodInvocationElement invocation) {
        Element targetType;
        if (invocation.getTargetExpression() != null && Arrays.binarySearch(mapTypes, (targetType = invocation.getTargetExpression().getTypeAsElement()).toString()) >= 0) {
            switch (invocation.getMethodName()) {
                case "put": {
                    this.printMacroName(invocation.getMethodName());
                    this.print(invocation.getTargetExpression()).print(".set(").printArgList(invocation.getArguments()).print(")");
                    return true;
                }
                case "get": {
                    this.printMacroName(invocation.getMethodName());
                    this.print(invocation.getTargetExpression()).print(".get(").printArgList(invocation.getArguments()).print(")");
                    return true;
                }
                case "containsKey": {
                    this.printMacroName(invocation.getMethodName());
                    this.print(invocation.getTargetExpression()).print(".has(").printArgList(invocation.getArguments()).print(")");
                    return true;
                }
                case "keySet": {
                    this.printMacroName(invocation.getMethodName());
                    this.print("(<any>Array).from(").print(invocation.getTargetExpression()).print(".keys())");
                    return true;
                }
                case "values": {
                    this.printMacroName(invocation.getMethodName());
                    this.print("(<any>Array).from(").print(invocation.getTargetExpression()).print(".values())");
                    return true;
                }
                case "size": {
                    this.printMacroName(invocation.getMethodName());
                    this.print(invocation.getTargetExpression()).print(".size");
                    return true;
                }
            }
        }
        return super.substituteMethodInvocation(invocation);
    }
}

