/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.extension;

import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.jsweet.transpiler.JSweetProblem;
import org.jsweet.transpiler.extension.PrinterAdapter;

public class DisallowGlobalVariablesAdapter
extends PrinterAdapter {
    public DisallowGlobalVariablesAdapter(PrinterAdapter parentAdapter) {
        super(parentAdapter);
    }

    @Override
    public void afterType(TypeElement type) {
        if (!type.getQualifiedName().toString().startsWith("def.") && type.getSimpleName().toString().equals("Globals")) {
            for (Element element : type.getEnclosedElements()) {
                VariableElement field;
                if (element.getKind() != ElementKind.FIELD || !(field = (VariableElement)element).getModifiers().contains((Object)Modifier.STATIC) || field.getModifiers().contains((Object)Modifier.FINAL)) continue;
                this.report(field, JSweetProblem.USER_ERROR, "global variables are not allowed");
            }
        }
        super.afterType(type);
    }
}

