/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.extension;

import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.jsweet.transpiler.extension.AnnotationManager;
import org.jsweet.transpiler.extension.PrinterAdapter;

public class AddPrefixToNonPublicMembersAdapter
extends PrinterAdapter {
    public AddPrefixToNonPublicMembersAdapter(PrinterAdapter parentAdapter) {
        super(parentAdapter);
        this.addAnnotationManager(new AnnotationManager(){

            @Override
            public AnnotationManager.Action manageAnnotation(Element element, String annotationType) {
                return "jsweet.lang.Name".equals(annotationType) && this.isNonPublicMember(element) ? AnnotationManager.Action.ADD : AnnotationManager.Action.VOID;
            }

            @Override
            public <T> T getAnnotationValue(Element element, String annotationType, String propertyName, Class<T> propertyClass, T defaultValue) {
                if ("jsweet.lang.Name".equals(annotationType) && this.isNonPublicMember(element)) {
                    return propertyClass.cast("__" + element.getSimpleName());
                }
                return null;
            }

            private boolean isNonPublicMember(Element element) {
                return (element instanceof VariableElement || element instanceof ExecutableElement) && element.getEnclosingElement() instanceof TypeElement && !element.getModifiers().contains((Object)Modifier.PUBLIC) && AddPrefixToNonPublicMembersAdapter.this.util().isSourceElement(element);
            }
        });
    }
}

